/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;

public class ContainerPlayer
extends AbstractCraftingMenu {
    public static final int CONTAINER_ID = 0;
    public static final int RESULT_SLOT = 0;
    private static final int CRAFTING_GRID_WIDTH = 2;
    private static final int CRAFTING_GRID_HEIGHT = 2;
    public static final int CRAFT_SLOT_START = 1;
    public static final int CRAFT_SLOT_COUNT = 4;
    public static final int CRAFT_SLOT_END = 5;
    public static final int ARMOR_SLOT_START = 5;
    public static final int ARMOR_SLOT_COUNT = 4;
    public static final int ARMOR_SLOT_END = 9;
    public static final int INV_SLOT_START = 9;
    public static final int INV_SLOT_END = 36;
    public static final int USE_ROW_SLOT_START = 36;
    public static final int USE_ROW_SLOT_END = 45;
    public static final int SHIELD_SLOT = 45;
    public static final MinecraftKey EMPTY_ARMOR_SLOT_HELMET = MinecraftKey.withDefaultNamespace("container/slot/helmet");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_CHESTPLATE = MinecraftKey.withDefaultNamespace("container/slot/chestplate");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_LEGGINGS = MinecraftKey.withDefaultNamespace("container/slot/leggings");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_BOOTS = MinecraftKey.withDefaultNamespace("container/slot/boots");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_SHIELD = MinecraftKey.withDefaultNamespace("container/slot/shield");
    private static final Map<EnumItemSlot, MinecraftKey> TEXTURE_EMPTY_SLOTS = Map.of(EnumItemSlot.FEET, EMPTY_ARMOR_SLOT_BOOTS, EnumItemSlot.LEGS, EMPTY_ARMOR_SLOT_LEGGINGS, EnumItemSlot.CHEST, EMPTY_ARMOR_SLOT_CHESTPLATE, EnumItemSlot.HEAD, EMPTY_ARMOR_SLOT_HELMET);
    private static final EnumItemSlot[] SLOT_IDS = new EnumItemSlot[]{EnumItemSlot.HEAD, EnumItemSlot.CHEST, EnumItemSlot.LEGS, EnumItemSlot.FEET};
    public final boolean active;
    private final EntityHuman owner;

    public ContainerPlayer(PlayerInventory var0, boolean var1, final EntityHuman var2) {
        super(null, 0, 2, 2);
        this.active = var1;
        this.owner = var2;
        this.addResultSlot(var2, 154, 28);
        this.addCraftingGridSlots(98, 18);
        for (int var3 = 0; var3 < 4; ++var3) {
            EnumItemSlot var4 = SLOT_IDS[var3];
            MinecraftKey var5 = TEXTURE_EMPTY_SLOTS.get(var4);
            this.addSlot(new ArmorSlot(var0, var2, var4, 39 - var3, 8, 8 + var3 * 18, var5));
        }
        this.addStandardInventorySlots(var0, 8, 84);
        this.addSlot(new Slot(this, var0, 40, 77, 62){

            @Override
            public void setByPlayer(ItemStack var0, ItemStack var1) {
                var2.onEquipItem(EnumItemSlot.OFFHAND, var1, var0);
                super.setByPlayer(var0, var1);
            }

            @Override
            public MinecraftKey getNoItemIcon() {
                return EMPTY_ARMOR_SLOT_SHIELD;
            }
        });
    }

    public static boolean isHotbarSlot(int var0) {
        return var0 >= 36 && var0 < 45 || var0 == 45;
    }

    @Override
    public void slotsChanged(IInventory var0) {
        World world = this.owner.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            ContainerWorkbench.slotChangedCraftingGrid(this, var1, this.owner, this.craftSlots, this.resultSlots, null);
        }
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.resultSlots.clearContent();
        if (var0.level().isClientSide()) {
            return;
        }
        this.clearContainer(var0, this.craftSlots);
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return true;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3.hasItem()) {
            int var6;
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            EnumItemSlot var5 = var0.getEquipmentSlotForItem(var2);
            if (var1 == 0) {
                if (!this.moveItemStackTo(var4, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 >= 1 && var1 < 5 ? !this.moveItemStackTo(var4, 9, 45, false) : (var1 >= 5 && var1 < 9 ? !this.moveItemStackTo(var4, 9, 45, false) : (var5.getType() == EnumItemSlot.Function.HUMANOID_ARMOR && !((Slot)this.slots.get(8 - var5.getIndex())).hasItem() ? !this.moveItemStackTo(var4, var6 = 8 - var5.getIndex(), var6 + 1, false) : (var5 == EnumItemSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(var4, 45, 46, false) : (var1 >= 9 && var1 < 36 ? !this.moveItemStackTo(var4, 36, 45, false) : (var1 >= 36 && var1 < 45 ? !this.moveItemStackTo(var4, 9, 36, false) : !this.moveItemStackTo(var4, 9, 45, false))))))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY, var2);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
            if (var1 == 0) {
                var0.drop(var4, false);
            }
        }
        return var2;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultSlots && super.canTakeItemForPickAll(var0, var1);
    }

    @Override
    public Slot getResultSlot() {
        return (Slot)this.slots.get(0);
    }

    @Override
    public List<Slot> getInputGridSlots() {
        return this.slots.subList(1, 5);
    }

    public InventoryCrafting getCraftSlots() {
        return this.craftSlots;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    @Override
    protected EntityHuman owner() {
        return this.owner;
    }
}

