/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;

public class ContainerWorkbench
extends AbstractCraftingMenu {
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    public static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_COUNT = 9;
    private static final int CRAFT_SLOT_END = 10;
    private static final int INV_SLOT_START = 10;
    private static final int INV_SLOT_END = 37;
    private static final int USE_ROW_SLOT_START = 37;
    private static final int USE_ROW_SLOT_END = 46;
    public final ContainerAccess access;
    private final EntityHuman player;
    private boolean placingRecipe;

    public ContainerWorkbench(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerWorkbench(int var0, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.CRAFTING, var0, 3, 3);
        this.access = var2;
        this.player = var1.player;
        this.addResultSlot(this.player, 124, 35);
        this.addCraftingGridSlots(30, 17);
        this.addStandardInventorySlots(var1, 8, 84);
    }

    protected static void slotChangedCraftingGrid(Container var0, WorldServer var1, EntityHuman var2, InventoryCrafting var3, InventoryCraftResult var4, @Nullable RecipeHolder<RecipeCrafting> var5) {
        CraftingInput var6 = var3.asCraftInput();
        EntityPlayer var7 = (EntityPlayer)var2;
        ItemStack var8 = ItemStack.EMPTY;
        Optional<RecipeHolder<RecipeCrafting>> var9 = var1.getServer().getRecipeManager().getRecipeFor(Recipes.CRAFTING, var6, (World)var1, var5);
        if (var9.isPresent()) {
            ItemStack var12;
            RecipeHolder<RecipeCrafting> var10 = var9.get();
            RecipeCrafting var11 = var10.value();
            if (var4.setRecipeUsed(var7, var10) && (var12 = var11.assemble(var6, var1.registryAccess())).isItemEnabled(var1.enabledFeatures())) {
                var8 = var12;
            }
        }
        var4.setItem(0, var8);
        var0.setRemoteSlot(0, var8);
        var7.connection.send(new PacketPlayOutSetSlot(var0.containerId, var0.incrementStateId(), 0, var8));
    }

    @Override
    public void slotsChanged(IInventory var02) {
        if (!this.placingRecipe) {
            this.access.execute((var0, var1) -> {
                if (var0 instanceof WorldServer) {
                    WorldServer var2 = (WorldServer)var0;
                    ContainerWorkbench.slotChangedCraftingGrid(this, var2, this.player, this.craftSlots, this.resultSlots, null);
                }
            });
        }
    }

    @Override
    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    @Override
    public void finishPlacingRecipe(WorldServer var0, RecipeHolder<RecipeCrafting> var1) {
        this.placingRecipe = false;
        ContainerWorkbench.slotChangedCraftingGrid(this, var0, this.player, this.craftSlots, this.resultSlots, var1);
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.craftSlots));
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerWorkbench.stillValid(this.access, var0, Blocks.CRAFTING_TABLE);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == 0) {
                var4.getItem().onCraftedBy(var4, var0);
                if (!this.moveItemStackTo(var4, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 >= 10 && var1 < 46 ? !this.moveItemStackTo(var4, 1, 10, false) && (var1 < 37 ? !this.moveItemStackTo(var4, 37, 46, false) : !this.moveItemStackTo(var4, 10, 37, false)) : !this.moveItemStackTo(var4, 10, 46, false)) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
            if (var1 == 0) {
                var0.drop(var4, false);
            }
        }
        return var2;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultSlots && super.canTakeItemForPickAll(var0, var1);
    }

    @Override
    public Slot getResultSlot() {
        return (Slot)this.slots.get(0);
    }

    @Override
    public List<Slot> getInputGridSlots() {
        return this.slots.subList(1, 10);
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    @Override
    protected EntityHuman owner() {
        return this.player;
    }
}

