/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class ItemFireball
extends Item
implements ProjectileItem {
    public ItemFireball(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        IBlockData var3 = var1.getBlockState(var2);
        boolean var4 = false;
        if (BlockCampfire.canLight(var3) || CandleBlock.canLight(var3) || CandleCakeBlock.canLight(var3)) {
            this.playSound(var1, var2);
            var1.setBlockAndUpdate(var2, (IBlockData)var3.setValue(BlockProperties.LIT, true));
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.BLOCK_CHANGE, var2);
            var4 = true;
        } else if (BlockFireAbstract.canBePlacedAt(var1, var2 = var2.relative(var0.getClickedFace()), var0.getHorizontalDirection())) {
            this.playSound(var1, var2);
            var1.setBlockAndUpdate(var2, BlockFireAbstract.getState(var1, var2));
            var1.gameEvent((Entity)var0.getPlayer(), GameEvent.BLOCK_PLACE, var2);
            var4 = true;
        }
        if (var4) {
            var0.getItemInHand().shrink(1);
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.FAIL;
    }

    private void playSound(World var0, BlockPosition var1) {
        RandomSource var2 = var0.getRandom();
        var0.playSound(null, var1, SoundEffects.FIRECHARGE_USE, SoundCategory.BLOCKS, 1.0f, (var2.nextFloat() - var2.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        RandomSource var4 = var0.getRandom();
        double var5 = var4.triangle((double)var3.getStepX(), 0.11485000000000001);
        double var7 = var4.triangle((double)var3.getStepY(), 0.11485000000000001);
        double var9 = var4.triangle((double)var3.getStepZ(), 0.11485000000000001);
        Vec3D var11 = new Vec3D(var5, var7, var9);
        EntitySmallFireball var12 = new EntitySmallFireball(var0, var1.x(), var1.y(), var1.z(), var11.normalize());
        var12.setItem(var2);
        return var12;
    }

    @Override
    public void shoot(IProjectile var0, double var1, double var3, double var5, float var7, float var8) {
    }

    @Override
    public ProjectileItem.a createDispenseConfig() {
        return ProjectileItem.a.builder().positionFunction((var0, var1) -> BlockDispenser.getDispensePosition(var0, 1.0, Vec3D.ZERO)).uncertainty(6.6666665f).power(1.0f).overrideDispenseEvent(1018).build();
    }
}

