/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class CustomData {
    public static final CustomData EMPTY = new CustomData(new NBTTagCompound());
    public static final Codec<NBTTagCompound> COMPOUND_TAG_CODEC = Codec.withAlternative(NBTTagCompound.CODEC, MojangsonParser.FLATTENED_CODEC);
    public static final Codec<CustomData> CODEC = COMPOUND_TAG_CODEC.xmap(CustomData::new, var0 -> var0.tag);
    @Deprecated
    public static final StreamCodec<ByteBuf, CustomData> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(CustomData::new, var0 -> var0.tag);
    private final NBTTagCompound tag;

    private CustomData(NBTTagCompound var0) {
        this.tag = var0;
    }

    public static CustomData of(NBTTagCompound var0) {
        return new CustomData(var0.copy());
    }

    public boolean matchedBy(NBTTagCompound var0) {
        return GameProfileSerializer.compareNbt(var0, this.tag, true);
    }

    public static void update(DataComponentType<CustomData> var0, ItemStack var1, Consumer<NBTTagCompound> var2) {
        CustomData var3 = var1.getOrDefault(var0, EMPTY).update(var2);
        if (var3.tag.isEmpty()) {
            var1.remove(var0);
        } else {
            var1.set(var0, var3);
        }
    }

    public static void set(DataComponentType<CustomData> var0, ItemStack var1, NBTTagCompound var2) {
        if (!var2.isEmpty()) {
            var1.set(var0, CustomData.of(var2));
        } else {
            var1.remove(var0);
        }
    }

    public CustomData update(Consumer<NBTTagCompound> var0) {
        NBTTagCompound var1 = this.tag.copy();
        var0.accept(var1);
        return new CustomData(var1);
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public NBTTagCompound copyTag() {
        return this.tag.copy();
    }

    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 instanceof CustomData) {
            CustomData var1 = (CustomData)var0;
            return this.tag.equals(var1.tag);
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }
}

