/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class RayTrace {
    private final Vec3D from;
    private final Vec3D to;
    private final BlockCollisionOption block;
    private final FluidCollisionOption fluid;
    private final VoxelShapeCollision collisionContext;

    public RayTrace(Vec3D var0, Vec3D var1, BlockCollisionOption var2, FluidCollisionOption var3, Entity var4) {
        this(var0, var1, var2, var3, VoxelShapeCollision.of(var4));
    }

    public RayTrace(Vec3D var0, Vec3D var1, BlockCollisionOption var2, FluidCollisionOption var3, VoxelShapeCollision var4) {
        this.from = var0;
        this.to = var1;
        this.block = var2;
        this.fluid = var3;
        this.collisionContext = var4;
    }

    public Vec3D getTo() {
        return this.to;
    }

    public Vec3D getFrom() {
        return this.from;
    }

    public VoxelShape getBlockShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return this.block.get(var0, var1, var2, this.collisionContext);
    }

    public VoxelShape getFluidShape(Fluid var0, IBlockAccess var1, BlockPosition var2) {
        return this.fluid.canPick(var0) ? var0.getShape(var1, var2) : VoxelShapes.empty();
    }

    public static final class BlockCollisionOption
    extends Enum<BlockCollisionOption>
    implements c {
        public static final /* enum */ BlockCollisionOption COLLIDER = new BlockCollisionOption(BlockBase.BlockData::getCollisionShape);
        public static final /* enum */ BlockCollisionOption OUTLINE = new BlockCollisionOption(BlockBase.BlockData::getShape);
        public static final /* enum */ BlockCollisionOption VISUAL = new BlockCollisionOption(BlockBase.BlockData::getVisualShape);
        public static final /* enum */ BlockCollisionOption FALLDAMAGE_RESETTING = new BlockCollisionOption((var0, var1, var2, var3) -> {
            VoxelShapeCollisionEntity var4;
            if (var0.is(TagsBlock.FALL_DAMAGE_RESETTING)) {
                return VoxelShapes.block();
            }
            if (var3 instanceof VoxelShapeCollisionEntity && (var4 = (VoxelShapeCollisionEntity)var3).getEntity() != null && var4.getEntity().getType() == EntityTypes.PLAYER) {
                if (var0.is(Blocks.END_GATEWAY) || var0.is(Blocks.END_PORTAL)) {
                    return VoxelShapes.block();
                }
                if (var1 instanceof WorldServer) {
                    WorldServer var5 = (WorldServer)var1;
                    if (var0.is(Blocks.NETHER_PORTAL) && var5.getGameRules().getInt(GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY) == 0) {
                        return VoxelShapes.block();
                    }
                }
            }
            return VoxelShapes.empty();
        });
        private final c shapeGetter;
        private static final /* synthetic */ BlockCollisionOption[] f;

        public static BlockCollisionOption[] values() {
            return (BlockCollisionOption[])f.clone();
        }

        public static BlockCollisionOption valueOf(String var0) {
            return Enum.valueOf(BlockCollisionOption.class, var0);
        }

        private BlockCollisionOption(c var2) {
            this.shapeGetter = var2;
        }

        @Override
        public VoxelShape get(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
            return this.shapeGetter.get(var0, var1, var2, var3);
        }

        private static /* synthetic */ BlockCollisionOption[] a() {
            return new BlockCollisionOption[]{COLLIDER, OUTLINE, VISUAL, FALLDAMAGE_RESETTING};
        }

        static {
            f = BlockCollisionOption.a();
        }
    }

    public static final class FluidCollisionOption
    extends Enum<FluidCollisionOption> {
        public static final /* enum */ FluidCollisionOption NONE = new FluidCollisionOption(var0 -> false);
        public static final /* enum */ FluidCollisionOption SOURCE_ONLY = new FluidCollisionOption(Fluid::isSource);
        public static final /* enum */ FluidCollisionOption ANY = new FluidCollisionOption(var0 -> !var0.isEmpty());
        public static final /* enum */ FluidCollisionOption WATER = new FluidCollisionOption(var0 -> var0.is(TagsFluid.WATER));
        private final Predicate<Fluid> canPick;
        private static final /* synthetic */ FluidCollisionOption[] f;

        public static FluidCollisionOption[] values() {
            return (FluidCollisionOption[])f.clone();
        }

        public static FluidCollisionOption valueOf(String var0) {
            return Enum.valueOf(FluidCollisionOption.class, var0);
        }

        private FluidCollisionOption(Predicate var2) {
            this.canPick = var2;
        }

        public boolean canPick(Fluid var0) {
            return this.canPick.test(var0);
        }

        private static /* synthetic */ FluidCollisionOption[] a() {
            return new FluidCollisionOption[]{NONE, SOURCE_ONLY, ANY, WATER};
        }

        static {
            f = FluidCollisionOption.a();
        }
    }

    public static interface c {
        public VoxelShape get(IBlockData var1, IBlockAccess var2, BlockPosition var3, VoxelShapeCollision var4);
    }
}

