/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockHopper
extends BlockTileEntity {
    public static final MapCodec<BlockHopper> CODEC = BlockHopper.simpleCodec(BlockHopper::new);
    public static final BlockStateEnum<EnumDirection> FACING = BlockProperties.FACING_HOPPER;
    public static final BlockStateBoolean ENABLED = BlockProperties.ENABLED;
    private final Function<IBlockData, VoxelShape> shapes;
    private final Map<EnumDirection, VoxelShape> interactionShapes;

    public MapCodec<BlockHopper> codec() {
        return CODEC;
    }

    public BlockHopper(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.DOWN)).setValue(ENABLED, true));
        VoxelShape var1 = Block.column(12.0, 11.0, 16.0);
        this.shapes = this.makeShapes(var1);
        this.interactionShapes = ImmutableMap.builderWithExpectedSize((int)5).putAll(VoxelShapes.rotateHorizontal(VoxelShapes.or(var1, Block.boxZ(4.0, 8.0, 10.0, 0.0, 4.0)))).put((Object)EnumDirection.DOWN, (Object)var1).build();
    }

    private Function<IBlockData, VoxelShape> makeShapes(VoxelShape var0) {
        VoxelShape var1 = VoxelShapes.or(Block.column(16.0, 10.0, 16.0), Block.column(8.0, 4.0, 10.0));
        VoxelShape var22 = VoxelShapes.join(var1, var0, OperatorBoolean.ONLY_FIRST);
        Map<EnumDirection, VoxelShape> var3 = VoxelShapes.rotateAll(Block.boxZ(4.0, 4.0, 8.0, 0.0, 8.0), new Vec3D(8.0, 6.0, 8.0).scale(0.0625));
        return this.getShapeForEachState(var2 -> VoxelShapes.or(var22, VoxelShapes.join((VoxelShape)var3.get(var2.getValue(FACING)), VoxelShapes.block(), OperatorBoolean.AND)), ENABLED);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected VoxelShape getInteractionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return this.interactionShapes.get(var0.getValue(FACING));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var1 = var0.getClickedFace().getOpposite();
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var1.getAxis() == EnumDirection.EnumAxis.Y ? EnumDirection.DOWN : var1)).setValue(ENABLED, true);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityHopper(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return var0.isClientSide() ? null : BlockHopper.createTickerHelper(var2, TileEntityTypes.HOPPER, TileEntityHopper::pushItemsTick);
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.checkPoweredState(var1, var2, var0);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity;
        if (!var1.isClientSide() && (tileEntity = var1.getBlockEntity(var2)) instanceof TileEntityHopper) {
            TileEntityHopper var5 = (TileEntityHopper)tileEntity;
            var3.openMenu(var5);
            var3.awardStat(StatisticList.INSPECT_HOPPER);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        this.checkPoweredState(var1, var2, var0);
    }

    private void checkPoweredState(World var0, BlockPosition var1, IBlockData var2) {
        boolean var3;
        boolean bl = var3 = !var0.hasNeighborSignal(var1);
        if (var3 != var2.getValue(ENABLED)) {
            var0.setBlock(var1, (IBlockData)var2.setValue(ENABLED, var3), 2);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        return Container.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, ENABLED);
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4) {
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityHopper) {
            TileEntityHopper.entityInside(var1, var2, var0, var3, (TileEntityHopper)var5);
        }
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

