/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.apache.commons.io.FileUtils;

public class RecreatingChunkStorage
extends IChunkLoader {
    private final IOWorker writeWorker;
    private final Path writeFolder;

    public RecreatingChunkStorage(RegionStorageInfo var0, Path var1, RegionStorageInfo var2, Path var3, DataFixer var4, boolean var5) {
        super(var0, var1, var4, var5);
        this.writeFolder = var3;
        this.writeWorker = new IOWorker(var2, var3, var5);
    }

    @Override
    public CompletableFuture<Void> write(ChunkCoordIntPair var0, Supplier<NBTTagCompound> var1) {
        this.handleLegacyStructureIndex(var0);
        return this.writeWorker.store(var0, var1);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.writeWorker.close();
        if (this.writeFolder.toFile().exists()) {
            FileUtils.deleteDirectory((File)this.writeFolder.toFile());
        }
    }
}

