/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3D;

public record BlockPositionSource(BlockPosition pos) implements PositionSource
{
    public static final MapCodec<BlockPositionSource> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BlockPosition.CODEC.fieldOf("pos").forGetter(BlockPositionSource::pos)).apply((Applicative)var0, BlockPositionSource::new));
    public static final StreamCodec<ByteBuf, BlockPositionSource> STREAM_CODEC = StreamCodec.composite(BlockPosition.STREAM_CODEC, BlockPositionSource::pos, BlockPositionSource::new);

    @Override
    public Optional<Vec3D> getPosition(World var0) {
        return Optional.of(Vec3D.atCenterOf(this.pos));
    }

    public PositionSourceType<BlockPositionSource> getType() {
        return PositionSourceType.BLOCK;
    }

    public static class a
    implements PositionSourceType<BlockPositionSource> {
        @Override
        public MapCodec<BlockPositionSource> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<ByteBuf, BlockPositionSource> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

