/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public final class DensityFunctions {
    private static final Codec<DensityFunction> CODEC = BuiltInRegistries.DENSITY_FUNCTION_TYPE.byNameCodec().dispatch(var0 -> var0.codec().codec(), Function.identity());
    protected static final double MAX_REASONABLE_NOISE_VALUE = 1000000.0;
    static final Codec<Double> NOISE_VALUE_CODEC = Codec.doubleRange((double)-1000000.0, (double)1000000.0);
    public static final Codec<DensityFunction> DIRECT_CODEC = Codec.either(NOISE_VALUE_CODEC, CODEC).xmap(var0 -> (DensityFunction)var0.map(DensityFunctions::constant, Function.identity()), var0 -> {
        if (var0 instanceof h) {
            h var1 = (h)var0;
            return Either.left((Object)var1.value());
        }
        return Either.right((Object)var0);
    });

    public static MapCodec<? extends DensityFunction> bootstrap(IRegistry<MapCodec<? extends DensityFunction>> var0) {
        DensityFunctions.register(var0, "blend_alpha", d.CODEC);
        DensityFunctions.register(var0, "blend_offset", f.CODEC);
        DensityFunctions.register(var0, "beardifier", b.CODEC);
        DensityFunctions.register(var0, "old_blended_noise", BlendedNoise.CODEC);
        for (m.a a2 : m.a.values()) {
            DensityFunctions.register(var0, a2.getSerializedName(), a2.codec);
        }
        DensityFunctions.register(var0, "noise", p.CODEC);
        DensityFunctions.register(var0, "end_islands", i.CODEC);
        DensityFunctions.register(var0, "weird_scaled_sampler", aa.CODEC);
        DensityFunctions.register(var0, "shifted_noise", w.CODEC);
        DensityFunctions.register(var0, "range_choice", r.CODEC);
        DensityFunctions.register(var0, "shift_a", t.CODEC);
        DensityFunctions.register(var0, "shift_b", u.CODEC);
        DensityFunctions.register(var0, "shift", s.CODEC);
        DensityFunctions.register(var0, "blend_density", e.CODEC);
        DensityFunctions.register(var0, "clamp", g.CODEC);
        for (Enum enum_ : l.a.values()) {
            DensityFunctions.register(var0, ((l.a)enum_).getSerializedName(), ((l.a)enum_).codec);
        }
        for (Enum enum_ : z.a.values()) {
            DensityFunctions.register(var0, ((z.a)enum_).getSerializedName(), ((z.a)enum_).codec);
        }
        DensityFunctions.register(var0, "spline", x.CODEC);
        DensityFunctions.register(var0, "constant", h.CODEC);
        DensityFunctions.register(var0, "y_clamped_gradient", ab.CODEC);
        return DensityFunctions.register(var0, "find_top_surface", j.CODEC);
    }

    private static MapCodec<? extends DensityFunction> register(IRegistry<MapCodec<? extends DensityFunction>> var0, String var1, KeyDispatchDataCodec<? extends DensityFunction> var2) {
        return IRegistry.register(var0, var1, var2.codec());
    }

    static <A, O> KeyDispatchDataCodec<O> singleArgumentCodec(Codec<A> var0, Function<A, O> var1, Function<O, A> var2) {
        return KeyDispatchDataCodec.of(var0.fieldOf("argument").xmap(var1, var2));
    }

    static <O> KeyDispatchDataCodec<O> singleFunctionArgumentCodec(Function<DensityFunction, O> var0, Function<O, DensityFunction> var1) {
        return DensityFunctions.singleArgumentCodec(DensityFunction.HOLDER_HELPER_CODEC, var0, var1);
    }

    static <O> KeyDispatchDataCodec<O> doubleFunctionArgumentCodec(BiFunction<DensityFunction, DensityFunction, O> var0, Function<O, DensityFunction> var1, Function<O, DensityFunction> var2) {
        return KeyDispatchDataCodec.of(RecordCodecBuilder.mapCodec(var3 -> var3.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument1").forGetter(var1), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument2").forGetter(var2)).apply((Applicative)var3, var0)));
    }

    static <O> KeyDispatchDataCodec<O> makeCodec(MapCodec<O> var0) {
        return KeyDispatchDataCodec.of(var0);
    }

    private DensityFunctions() {
    }

    public static DensityFunction interpolated(DensityFunction var0) {
        return new m(m.a.Interpolated, var0);
    }

    public static DensityFunction flatCache(DensityFunction var0) {
        return new m(m.a.FlatCache, var0);
    }

    public static DensityFunction cache2d(DensityFunction var0) {
        return new m(m.a.Cache2D, var0);
    }

    public static DensityFunction cacheOnce(DensityFunction var0) {
        return new m(m.a.CacheOnce, var0);
    }

    public static DensityFunction cacheAllInCell(DensityFunction var0) {
        return new m(m.a.CacheAllInCell, var0);
    }

    public static DensityFunction mappedNoise(Holder<NoiseGeneratorNormal.a> var0, @Deprecated double var1, double var3, double var5, double var7) {
        return DensityFunctions.mapFromUnitTo(new p(new DensityFunction.c(var0), var1, var3), var5, var7);
    }

    public static DensityFunction mappedNoise(Holder<NoiseGeneratorNormal.a> var0, double var1, double var3, double var5) {
        return DensityFunctions.mappedNoise(var0, 1.0, var1, var3, var5);
    }

    public static DensityFunction mappedNoise(Holder<NoiseGeneratorNormal.a> var0, double var1, double var3) {
        return DensityFunctions.mappedNoise(var0, 1.0, 1.0, var1, var3);
    }

    public static DensityFunction shiftedNoise2d(DensityFunction var0, DensityFunction var1, double var2, Holder<NoiseGeneratorNormal.a> var4) {
        return new w(var0, DensityFunctions.zero(), var1, var2, 0.0, new DensityFunction.c(var4));
    }

    public static DensityFunction noise(Holder<NoiseGeneratorNormal.a> var0) {
        return DensityFunctions.noise(var0, 1.0, 1.0);
    }

    public static DensityFunction noise(Holder<NoiseGeneratorNormal.a> var0, double var1, double var3) {
        return new p(new DensityFunction.c(var0), var1, var3);
    }

    public static DensityFunction noise(Holder<NoiseGeneratorNormal.a> var0, double var1) {
        return DensityFunctions.noise(var0, 1.0, var1);
    }

    public static DensityFunction rangeChoice(DensityFunction var0, double var1, double var3, DensityFunction var5, DensityFunction var6) {
        return new r(var0, var1, var3, var5, var6);
    }

    public static DensityFunction shiftA(Holder<NoiseGeneratorNormal.a> var0) {
        return new t(new DensityFunction.c(var0));
    }

    public static DensityFunction shiftB(Holder<NoiseGeneratorNormal.a> var0) {
        return new u(new DensityFunction.c(var0));
    }

    public static DensityFunction shift(Holder<NoiseGeneratorNormal.a> var0) {
        return new s(new DensityFunction.c(var0));
    }

    public static DensityFunction blendDensity(DensityFunction var0) {
        return new e(var0);
    }

    public static DensityFunction endIslands(long var0) {
        return new i(var0);
    }

    public static DensityFunction weirdScaledSampler(DensityFunction var0, Holder<NoiseGeneratorNormal.a> var1, aa.a var2) {
        return new aa(var0, new DensityFunction.c(var1), var2);
    }

    public static DensityFunction add(DensityFunction var0, DensityFunction var1) {
        return z.create(z.a.ADD, var0, var1);
    }

    public static DensityFunction mul(DensityFunction var0, DensityFunction var1) {
        return z.create(z.a.MUL, var0, var1);
    }

    public static DensityFunction min(DensityFunction var0, DensityFunction var1) {
        return z.create(z.a.MIN, var0, var1);
    }

    public static DensityFunction max(DensityFunction var0, DensityFunction var1) {
        return z.create(z.a.MAX, var0, var1);
    }

    public static DensityFunction spline(CubicSpline<x.b, x.a> var0) {
        return new x(var0);
    }

    public static DensityFunction zero() {
        return h.ZERO;
    }

    public static DensityFunction constant(double var0) {
        return new h(var0);
    }

    public static DensityFunction yClampedGradient(int var0, int var1, double var2, double var4) {
        return new ab(var0, var1, var2, var4);
    }

    public static DensityFunction map(DensityFunction var0, l.a var1) {
        return l.create(var1, var0);
    }

    private static DensityFunction mapFromUnitTo(DensityFunction var0, double var1, double var3) {
        double var5 = (var1 + var3) * 0.5;
        double var7 = (var3 - var1) * 0.5;
        return DensityFunctions.add(DensityFunctions.constant(var5), DensityFunctions.mul(DensityFunctions.constant(var7), var0));
    }

    public static DensityFunction blendAlpha() {
        return d.INSTANCE;
    }

    public static DensityFunction blendOffset() {
        return f.INSTANCE;
    }

    public static DensityFunction lerp(DensityFunction var0, DensityFunction var1, DensityFunction var2) {
        if (var1 instanceof h) {
            h var3 = (h)var1;
            return DensityFunctions.lerp(var0, var3.value, var2);
        }
        DensityFunction var3 = DensityFunctions.cacheOnce(var0);
        DensityFunction var4 = DensityFunctions.add(DensityFunctions.mul(var3, DensityFunctions.constant(-1.0)), DensityFunctions.constant(1.0));
        return DensityFunctions.add(DensityFunctions.mul(var1, var4), DensityFunctions.mul(var2, var3));
    }

    public static DensityFunction lerp(DensityFunction var0, double var1, DensityFunction var3) {
        return DensityFunctions.add(DensityFunctions.mul(var0, DensityFunctions.add(var3, DensityFunctions.constant(-var1))), DensityFunctions.constant(var1));
    }

    public static DensityFunction findTopSurface(DensityFunction var0, DensityFunction var1, int var2, int var3) {
        return new j(var0, var1, var2, var3);
    }

    protected static final class d
    extends Enum<d>
    implements DensityFunction.d {
        public static final /* enum */ d INSTANCE = new d();
        public static final KeyDispatchDataCodec<DensityFunction> CODEC;
        private static final /* synthetic */ d[] f;

        public static d[] values() {
            return (d[])f.clone();
        }

        public static d valueOf(String var0) {
            return Enum.valueOf(d.class, var0);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return 1.0;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            Arrays.fill(var0, 1.0);
        }

        @Override
        public double minValue() {
            return 1.0;
        }

        @Override
        public double maxValue() {
            return 1.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        private static /* synthetic */ d[] k() {
            return new d[]{INSTANCE};
        }

        static {
            f = d.k();
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    protected static final class f
    extends Enum<f>
    implements DensityFunction.d {
        public static final /* enum */ f INSTANCE = new f();
        public static final KeyDispatchDataCodec<DensityFunction> CODEC;
        private static final /* synthetic */ f[] f;

        public static f[] values() {
            return (f[])f.clone();
        }

        public static f valueOf(String var0) {
            return Enum.valueOf(f.class, var0);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return 0.0;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            Arrays.fill(var0, 0.0);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        private static /* synthetic */ f[] k() {
            return new f[]{INSTANCE};
        }

        static {
            f = net.minecraft.world.level.levelgen.DensityFunctions$f.k();
            CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)INSTANCE));
        }
    }

    protected static final class b
    extends Enum<b>
    implements c {
        public static final /* enum */ b INSTANCE = new b();
        private static final /* synthetic */ b[] b;

        public static b[] values() {
            return (b[])b.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return 0.0;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            Arrays.fill(var0, 0.0);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }

        private static /* synthetic */ b[] k() {
            return new b[]{INSTANCE};
        }

        static {
            b = net.minecraft.world.level.levelgen.DensityFunctions$b.k();
        }
    }

    protected record m(a type, DensityFunction wrapped) implements n
    {
        @Override
        public double compute(DensityFunction.b var0) {
            return this.wrapped.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            this.wrapped.fillArray(var0, var1);
        }

        @Override
        public double minValue() {
            return this.wrapped.minValue();
        }

        @Override
        public double maxValue() {
            return this.wrapped.maxValue();
        }

        static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a Interpolated = new a("interpolated");
            public static final /* enum */ a FlatCache = new a("flat_cache");
            public static final /* enum */ a Cache2D = new a("cache_2d");
            public static final /* enum */ a CacheOnce = new a("cache_once");
            public static final /* enum */ a CacheAllInCell = new a("cache_all_in_cell");
            private final String name;
            final KeyDispatchDataCodec<n> codec = DensityFunctions.singleFunctionArgumentCodec(var0 -> new m(this, (DensityFunction)var0), n::wrapped);
            private static final /* synthetic */ a[] h;

            public static a[] values() {
                return (a[])h.clone();
            }

            public static a valueOf(String var0) {
                return Enum.valueOf(a.class, var0);
            }

            private a(String var2) {
                this.name = var2;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{Interpolated, FlatCache, Cache2D, CacheOnce, CacheAllInCell};
            }

            static {
                h = a.a();
            }
        }
    }

    protected record p(DensityFunction.c noise, @Deprecated double xzScale, double yScale) implements DensityFunction
    {
        public static final MapCodec<p> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.c.CODEC.fieldOf("noise").forGetter(p::noise), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(p::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(p::yScale)).apply((Applicative)var0, p::new));
        public static final KeyDispatchDataCodec<p> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.b var0) {
            return this.noise.getValue((double)var0.blockX() * this.xzScale, (double)var0.blockY() * this.yScale, (double)var0.blockZ() * this.xzScale);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new p(var0.visitNoise(this.noise), this.xzScale, this.yScale));
        }

        @Override
        public double minValue() {
            return -this.maxValue();
        }

        @Override
        public double maxValue() {
            return this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected static final class i
    implements DensityFunction.d {
        public static final KeyDispatchDataCodec<i> CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)new i(0L)));
        private static final float ISLAND_THRESHOLD = -0.9f;
        private final NoiseGenerator3Handler islandNoise;

        public i(long var0) {
            LegacyRandomSource var2 = new LegacyRandomSource(var0);
            var2.consumeCount(17292);
            this.islandNoise = new NoiseGenerator3Handler(var2);
        }

        private static float getHeightValue(NoiseGenerator3Handler var0, int var1, int var2) {
            int var3 = var1 / 2;
            int var4 = var2 / 2;
            int var5 = var1 % 2;
            int var6 = var2 % 2;
            float var7 = 100.0f - MathHelper.sqrt(var1 * var1 + var2 * var2) * 8.0f;
            var7 = MathHelper.clamp(var7, -100.0f, 80.0f);
            for (int var8 = -12; var8 <= 12; ++var8) {
                for (int var9 = -12; var9 <= 12; ++var9) {
                    long var10 = var3 + var8;
                    long var12 = var4 + var9;
                    if (var10 * var10 + var12 * var12 <= 4096L || !(var0.getValue(var10, var12) < (double)-0.9f)) continue;
                    float var14 = (MathHelper.abs(var10) * 3439.0f + MathHelper.abs(var12) * 147.0f) % 13.0f + 9.0f;
                    float var15 = var5 - var8 * 2;
                    float var16 = var6 - var9 * 2;
                    float var17 = 100.0f - MathHelper.sqrt(var15 * var15 + var16 * var16) * var14;
                    var17 = MathHelper.clamp(var17, -100.0f, 80.0f);
                    var7 = Math.max(var7, var17);
                }
            }
            return var7;
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return ((double)i.getHeightValue(this.islandNoise, var0.blockX() / 8, var0.blockZ() / 8) - 8.0) / 128.0;
        }

        @Override
        public double minValue() {
            return -0.84375;
        }

        @Override
        public double maxValue() {
            return 0.5625;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record aa(DensityFunction input, DensityFunction.c noise, a rarityValueMapper) implements y
    {
        private static final MapCodec<aa> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(aa::input), (App)DensityFunction.c.CODEC.fieldOf("noise").forGetter(aa::noise), (App)a.CODEC.fieldOf("rarity_value_mapper").forGetter(aa::rarityValueMapper)).apply((Applicative)var0, aa::new));
        public static final KeyDispatchDataCodec<aa> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double transform(DensityFunction.b var0, double var1) {
            double var3 = this.rarityValueMapper.mapper.get(var1);
            return var3 * Math.abs(this.noise.getValue((double)var0.blockX() / var3, (double)var0.blockY() / var3, (double)var0.blockZ() / var3));
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new aa(this.input.mapAll(var0), var0.visitNoise(this.noise), this.rarityValueMapper));
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return this.rarityValueMapper.maxRarity * this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a TYPE1 = new a("type_1", NoiseRouterData.a::getSpaghettiRarity3D, 2.0);
            public static final /* enum */ a TYPE2 = new a("type_2", NoiseRouterData.a::getSphaghettiRarity2D, 3.0);
            public static final Codec<a> CODEC;
            private final String name;
            final Double2DoubleFunction mapper;
            final double maxRarity;
            private static final /* synthetic */ a[] g;

            public static a[] values() {
                return (a[])g.clone();
            }

            public static a valueOf(String var0) {
                return Enum.valueOf(a.class, var0);
            }

            private a(String var2, Double2DoubleFunction var3, double var4) {
                this.name = var2;
                this.mapper = var3;
                this.maxRarity = var4;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{TYPE1, TYPE2};
            }

            static {
                g = a.a();
                CODEC = INamable.fromEnum(a::values);
            }
        }
    }

    protected record w(DensityFunction shiftX, DensityFunction shiftY, DensityFunction shiftZ, double xzScale, double yScale, DensityFunction.c noise) implements DensityFunction
    {
        private static final MapCodec<w> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_x").forGetter(w::shiftX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_y").forGetter(w::shiftY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_z").forGetter(w::shiftZ), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(w::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(w::yScale), (App)DensityFunction.c.CODEC.fieldOf("noise").forGetter(w::noise)).apply((Applicative)var0, w::new));
        public static final KeyDispatchDataCodec<w> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.b var0) {
            double var1 = (double)var0.blockX() * this.xzScale + this.shiftX.compute(var0);
            double var3 = (double)var0.blockY() * this.yScale + this.shiftY.compute(var0);
            double var5 = (double)var0.blockZ() * this.xzScale + this.shiftZ.compute(var0);
            return this.noise.getValue(var1, var3, var5);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new w(this.shiftX.mapAll(var0), this.shiftY.mapAll(var0), this.shiftZ.mapAll(var0), this.xzScale, this.yScale, var0.visitNoise(this.noise)));
        }

        @Override
        public double minValue() {
            return -this.maxValue();
        }

        @Override
        public double maxValue() {
            return this.noise.maxValue();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record r(DensityFunction input, double minInclusive, double maxExclusive, DensityFunction whenInRange, DensityFunction whenOutOfRange) implements DensityFunction
    {
        public static final MapCodec<r> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(r::input), (App)NOISE_VALUE_CODEC.fieldOf("min_inclusive").forGetter(r::minInclusive), (App)NOISE_VALUE_CODEC.fieldOf("max_exclusive").forGetter(r::maxExclusive), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("when_in_range").forGetter(r::whenInRange), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("when_out_of_range").forGetter(r::whenOutOfRange)).apply((Applicative)var0, r::new));
        public static final KeyDispatchDataCodec<r> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.b var0) {
            double var1 = this.input.compute(var0);
            if (var1 >= this.minInclusive && var1 < this.maxExclusive) {
                return this.whenInRange.compute(var0);
            }
            return this.whenOutOfRange.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            this.input.fillArray(var0, var1);
            for (int var2 = 0; var2 < var0.length; ++var2) {
                double var3 = var0[var2];
                var0[var2] = var3 >= this.minInclusive && var3 < this.maxExclusive ? this.whenInRange.compute(var1.forIndex(var2)) : this.whenOutOfRange.compute(var1.forIndex(var2));
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new r(this.input.mapAll(var0), this.minInclusive, this.maxExclusive, this.whenInRange.mapAll(var0), this.whenOutOfRange.mapAll(var0)));
        }

        @Override
        public double minValue() {
            return Math.min(this.whenInRange.minValue(), this.whenOutOfRange.minValue());
        }

        @Override
        public double maxValue() {
            return Math.max(this.whenInRange.maxValue(), this.whenOutOfRange.maxValue());
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record t(DensityFunction.c offsetNoise) implements v
    {
        static final KeyDispatchDataCodec<t> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.c.CODEC, t::new, t::offsetNoise);

        @Override
        public double compute(DensityFunction.b var0) {
            return this.compute(var0.blockX(), 0.0, var0.blockZ());
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new t(var0.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record u(DensityFunction.c offsetNoise) implements v
    {
        static final KeyDispatchDataCodec<u> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.c.CODEC, u::new, u::offsetNoise);

        @Override
        public double compute(DensityFunction.b var0) {
            return this.compute(var0.blockZ(), var0.blockX(), 0.0);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new u(var0.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record s(DensityFunction.c offsetNoise) implements v
    {
        static final KeyDispatchDataCodec<s> CODEC = DensityFunctions.singleArgumentCodec(DensityFunction.c.CODEC, s::new, s::offsetNoise);

        @Override
        public double compute(DensityFunction.b var0) {
            return this.compute(var0.blockX(), var0.blockY(), var0.blockZ());
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new s(var0.visitNoise(this.offsetNoise)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record e(DensityFunction input) implements y
    {
        static final KeyDispatchDataCodec<e> CODEC = DensityFunctions.singleFunctionArgumentCodec(e::new, e::input);

        @Override
        public double transform(DensityFunction.b var0, double var1) {
            return var0.getBlender().blendDensity(var0, var1);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new e(this.input.mapAll(var0)));
        }

        @Override
        public double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record g(DensityFunction input, double minValue, double maxValue) implements q
    {
        private static final MapCodec<g> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.DIRECT_CODEC.fieldOf("input").forGetter(g::input), (App)NOISE_VALUE_CODEC.fieldOf("min").forGetter(g::minValue), (App)NOISE_VALUE_CODEC.fieldOf("max").forGetter(g::maxValue)).apply((Applicative)var0, g::new));
        public static final KeyDispatchDataCodec<g> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double transform(double var0) {
            return MathHelper.clamp(var0, this.minValue, this.maxValue);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return new g(this.input.mapAll(var0), this.minValue, this.maxValue);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record l(a type, DensityFunction input, double minValue, double maxValue) implements q
    {
        public static l create(a var0, DensityFunction var1) {
            double var2 = var1.minValue();
            double var4 = var1.maxValue();
            double var6 = l.transform(var0, var2);
            double var8 = l.transform(var0, var4);
            if (var0 == a.INVERT) {
                if (var2 < 0.0 && var4 > 0.0) {
                    return new l(var0, var1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                }
                return new l(var0, var1, var8, var6);
            }
            if (var0 == a.ABS || var0 == a.SQUARE) {
                return new l(var0, var1, Math.max(0.0, var2), Math.max(var6, var8));
            }
            return new l(var0, var1, var6, var8);
        }

        private static double transform(a var0, double var1) {
            return switch (var0.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Math.abs(var1);
                case 1 -> var1 * var1;
                case 2 -> var1 * var1 * var1;
                case 3 -> {
                    if (var1 > 0.0) {
                        yield var1;
                    }
                    yield var1 * 0.5;
                }
                case 4 -> {
                    if (var1 > 0.0) {
                        yield var1;
                    }
                    yield var1 * 0.25;
                }
                case 5 -> 1.0 / var1;
                case 6 -> {
                    double var3 = MathHelper.clamp(var1, -1.0, 1.0);
                    yield var3 / 2.0 - var3 * var3 * var3 / 24.0;
                }
            };
        }

        @Override
        public double transform(double var0) {
            return l.transform(this.type, var0);
        }

        @Override
        public l mapAll(DensityFunction.f var0) {
            return l.create(this.type, this.input.mapAll(var0));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type.codec;
        }

        @Override
        public /* synthetic */ DensityFunction mapAll(DensityFunction.f f2) {
            return this.mapAll(f2);
        }

        static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a ABS = new a("abs");
            public static final /* enum */ a SQUARE = new a("square");
            public static final /* enum */ a CUBE = new a("cube");
            public static final /* enum */ a HALF_NEGATIVE = new a("half_negative");
            public static final /* enum */ a QUARTER_NEGATIVE = new a("quarter_negative");
            public static final /* enum */ a INVERT = new a("invert");
            public static final /* enum */ a SQUEEZE = new a("squeeze");
            private final String name;
            final KeyDispatchDataCodec<l> codec = DensityFunctions.singleFunctionArgumentCodec(var0 -> l.create(this, var0), l::input);
            private static final /* synthetic */ a[] j;

            public static a[] values() {
                return (a[])j.clone();
            }

            public static a valueOf(String var0) {
                return Enum.valueOf(a.class, var0);
            }

            private a(String var2) {
                this.name = var2;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{ABS, SQUARE, CUBE, HALF_NEGATIVE, QUARTER_NEGATIVE, INVERT, SQUEEZE};
            }

            static {
                j = a.a();
            }
        }
    }

    static interface z
    extends DensityFunction {
        public static final Logger LOGGER = LogUtils.getLogger();

        public static z create(a var0, DensityFunction var1, DensityFunction var2) {
            double var13;
            double var3 = var1.minValue();
            double var5 = var2.minValue();
            double var7 = var1.maxValue();
            double var9 = var2.maxValue();
            if (var0 == a.MIN || var0 == a.MAX) {
                boolean var12;
                boolean var11 = var3 >= var9;
                boolean bl = var12 = var5 >= var7;
                if (var11 || var12) {
                    LOGGER.warn("Creating a {} function between two non-overlapping inputs: {} and {}", new Object[]{var0, var1, var2});
                }
            }
            double var11 = switch (var0.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> var3 + var5;
                case 3 -> Math.max(var3, var5);
                case 2 -> Math.min(var3, var5);
                case 1 -> var3 > 0.0 && var5 > 0.0 ? var3 * var5 : (var7 < 0.0 && var9 < 0.0 ? var7 * var9 : Math.min(var3 * var9, var7 * var5));
            };
            switch (var0.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    double d2 = var7 + var9;
                    break;
                }
                case 3: {
                    double d2 = Math.max(var7, var9);
                    break;
                }
                case 2: {
                    double d2 = Math.min(var7, var9);
                    break;
                }
                case 1: {
                    double d2 = var3 > 0.0 && var5 > 0.0 ? var7 * var9 : (var13 = var7 < 0.0 && var9 < 0.0 ? var3 * var5 : Math.max(var3 * var5, var7 * var9));
                }
            }
            if (var0 == a.MUL || var0 == a.ADD) {
                if (var1 instanceof h) {
                    h var15 = (h)var1;
                    return new o(var0 == a.ADD ? o.a.ADD : o.a.MUL, var2, var11, var13, var15.value);
                }
                if (var2 instanceof h) {
                    h var15 = (h)var2;
                    return new o(var0 == a.ADD ? o.a.ADD : o.a.MUL, var1, var11, var13, var15.value);
                }
            }
            return new net.minecraft.world.level.levelgen.DensityFunctions$a(var0, var1, var2, var11, var13);
        }

        public a type();

        public DensityFunction argument1();

        public DensityFunction argument2();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type().codec;
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a ADD = new a("add");
            public static final /* enum */ a MUL = new a("mul");
            public static final /* enum */ a MIN = new a("min");
            public static final /* enum */ a MAX = new a("max");
            final KeyDispatchDataCodec<z> codec = DensityFunctions.doubleFunctionArgumentCodec((var0, var1) -> z.create(this, var0, var1), z::argument1, z::argument2);
            private final String name;
            private static final /* synthetic */ a[] g;

            public static a[] values() {
                return (a[])g.clone();
            }

            public static a valueOf(String var0) {
                return Enum.valueOf(a.class, var0);
            }

            private a(String var2) {
                this.name = var2;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{ADD, MUL, MIN, MAX};
            }

            static {
                g = a.a();
            }
        }
    }

    public record x(CubicSpline<b, a> spline) implements DensityFunction
    {
        private static final Codec<CubicSpline<b, a>> SPLINE_CODEC = CubicSpline.codec(a.CODEC);
        private static final MapCodec<x> DATA_CODEC = SPLINE_CODEC.fieldOf("spline").xmap(x::new, x::spline);
        public static final KeyDispatchDataCodec<x> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.b var0) {
            return this.spline.apply(new b(var0));
        }

        @Override
        public double minValue() {
            return this.spline.minValue();
        }

        @Override
        public double maxValue() {
            return this.spline.maxValue();
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new x(this.spline.mapAll((I var1) -> var1.mapAll(var0))));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        public record b(DensityFunction.b context) {
        }

        public record a(Holder<DensityFunction> function) implements BoundedFloatFunction<b>
        {
            public static final Codec<a> CODEC = DensityFunction.CODEC.xmap(a::new, a::function);

            @Override
            public String toString() {
                Optional<ResourceKey<DensityFunction>> var0 = this.function.unwrapKey();
                if (var0.isPresent()) {
                    ResourceKey<DensityFunction> var1 = var0.get();
                    if (var1 == NoiseRouterData.CONTINENTS) {
                        return "continents";
                    }
                    if (var1 == NoiseRouterData.EROSION) {
                        return "erosion";
                    }
                    if (var1 == NoiseRouterData.RIDGES) {
                        return "weirdness";
                    }
                    if (var1 == NoiseRouterData.RIDGES_FOLDED) {
                        return "ridges";
                    }
                }
                return "Coordinate[" + String.valueOf(this.function) + "]";
            }

            @Override
            public float apply(b var0) {
                return (float)this.function.value().compute(var0.context());
            }

            @Override
            public float minValue() {
                return this.function.isBound() ? (float)this.function.value().minValue() : Float.NEGATIVE_INFINITY;
            }

            @Override
            public float maxValue() {
                return this.function.isBound() ? (float)this.function.value().maxValue() : Float.POSITIVE_INFINITY;
            }

            public a mapAll(DensityFunction.f var0) {
                return new a(new Holder.a<DensityFunction>(this.function.value().mapAll(var0)));
            }
        }
    }

    static final class h
    extends Record
    implements DensityFunction.d {
        final double value;
        static final KeyDispatchDataCodec<h> CODEC = DensityFunctions.singleArgumentCodec(NOISE_VALUE_CODEC, h::new, h::value);
        static final h ZERO = new h(0.0);

        h(double var0) {
            this.value = var0;
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return this.value;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            Arrays.fill(var0, this.value);
        }

        @Override
        public double minValue() {
            return this.value;
        }

        @Override
        public double maxValue() {
            return this.value;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "value", "value"}, this, var0);
        }

        public double value() {
            return this.value;
        }
    }

    record ab(int fromY, int toY, double fromValue, double toValue) implements DensityFunction.d
    {
        private static final MapCodec<ab> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.intRange((int)(DimensionManager.MIN_Y * 2), (int)(DimensionManager.MAX_Y * 2)).fieldOf("from_y").forGetter(ab::fromY), (App)Codec.intRange((int)(DimensionManager.MIN_Y * 2), (int)(DimensionManager.MAX_Y * 2)).fieldOf("to_y").forGetter(ab::toY), (App)NOISE_VALUE_CODEC.fieldOf("from_value").forGetter(ab::fromValue), (App)NOISE_VALUE_CODEC.fieldOf("to_value").forGetter(ab::toValue)).apply((Applicative)var0, ab::new));
        public static final KeyDispatchDataCodec<ab> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.b var0) {
            return MathHelper.clampedMap((double)var0.blockY(), (double)this.fromY, (double)this.toY, this.fromValue, this.toValue);
        }

        @Override
        public double minValue() {
            return Math.min(this.fromValue, this.toValue);
        }

        @Override
        public double maxValue() {
            return Math.max(this.fromValue, this.toValue);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record j(DensityFunction density, DensityFunction upperBound, int lowerBound, int cellHeight) implements DensityFunction
    {
        private static final MapCodec<j> DATA_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("density").forGetter(j::density), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("upper_bound").forGetter(j::upperBound), (App)Codec.intRange((int)(DimensionManager.MIN_Y * 2), (int)(DimensionManager.MAX_Y * 2)).fieldOf("lower_bound").forGetter(j::lowerBound), (App)ExtraCodecs.POSITIVE_INT.fieldOf("cell_height").forGetter(j::cellHeight)).apply((Applicative)var0, j::new));
        public static final KeyDispatchDataCodec<j> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.b var0) {
            int var1 = MathHelper.floor(this.upperBound.compute(var0) / (double)this.cellHeight) * this.cellHeight;
            if (var1 <= this.lowerBound) {
                return this.lowerBound;
            }
            for (int var2 = var1; var2 >= this.lowerBound; var2 -= this.cellHeight) {
                DensityFunction.e e2 = new DensityFunction.e(var0.blockX(), var2, var0.blockZ());
                if (!(this.density.compute(e2) > 0.0)) continue;
                return var2;
            }
            return this.lowerBound;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new j(this.density.mapAll(var0), this.upperBound.mapAll(var0), this.lowerBound, this.cellHeight));
        }

        @Override
        public double minValue() {
            return this.lowerBound;
        }

        @Override
        public double maxValue() {
            return Math.max((double)this.lowerBound, this.upperBound.maxValue());
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record a(z.a type, DensityFunction argument1, DensityFunction argument2, double minValue, double maxValue) implements z
    {
        @Override
        public double compute(DensityFunction.b var0) {
            double var1 = this.argument1.compute(var0);
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> var1 + this.argument2.compute(var0);
                case 1 -> {
                    if (var1 == 0.0) {
                        yield 0.0;
                    }
                    yield var1 * this.argument2.compute(var0);
                }
                case 2 -> {
                    if (var1 < this.argument2.minValue()) {
                        yield var1;
                    }
                    yield Math.min(var1, this.argument2.compute(var0));
                }
                case 3 -> var1 > this.argument2.maxValue() ? var1 : Math.max(var1, this.argument2.compute(var0));
            };
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            this.argument1.fillArray(var0, var1);
            switch (this.type.ordinal()) {
                case 0: {
                    double[] var2 = new double[var0.length];
                    this.argument2.fillArray(var2, var1);
                    for (int var3 = 0; var3 < var0.length; ++var3) {
                        var0[var3] = var0[var3] + var2[var3];
                    }
                    break;
                }
                case 1: {
                    for (int var2 = 0; var2 < var0.length; ++var2) {
                        double var3 = var0[var2];
                        var0[var2] = var3 == 0.0 ? 0.0 : var3 * this.argument2.compute(var1.forIndex(var2));
                    }
                    break;
                }
                case 2: {
                    double var2 = this.argument2.minValue();
                    for (int var4 = 0; var4 < var0.length; ++var4) {
                        double var5 = var0[var4];
                        var0[var4] = var5 < var2 ? var5 : Math.min(var5, this.argument2.compute(var1.forIndex(var4)));
                    }
                    break;
                }
                case 3: {
                    double var2 = this.argument2.maxValue();
                    for (int var4 = 0; var4 < var0.length; ++var4) {
                        double var5 = var0[var4];
                        var0[var4] = var5 > var2 ? var5 : Math.max(var5, this.argument2.compute(var1.forIndex(var4)));
                    }
                    break;
                }
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(z.create(this.type, this.argument1.mapAll(var0), this.argument2.mapAll(var0)));
        }
    }

    record o(a specificType, DensityFunction input, double minValue, double maxValue, double argument) implements q,
    z
    {
        @Override
        public z.a type() {
            return this.specificType == a.MUL ? z.a.MUL : z.a.ADD;
        }

        @Override
        public DensityFunction argument1() {
            return DensityFunctions.constant(this.argument);
        }

        @Override
        public DensityFunction argument2() {
            return this.input;
        }

        @Override
        public double transform(double var0) {
            return switch (this.specificType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> var0 * this.argument;
                case 1 -> var0 + this.argument;
            };
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            double var8;
            double var6;
            DensityFunction var1 = this.input.mapAll(var0);
            double var2 = var1.minValue();
            double var4 = var1.maxValue();
            if (this.specificType == a.ADD) {
                var6 = var2 + this.argument;
                var8 = var4 + this.argument;
            } else if (this.argument >= 0.0) {
                var6 = var2 * this.argument;
                var8 = var4 * this.argument;
            } else {
                var6 = var4 * this.argument;
                var8 = var2 * this.argument;
            }
            return new o(this.specificType, var1, var6, var8, this.argument);
        }

        static final class a
        extends Enum<a> {
            public static final /* enum */ a MUL = new a();
            public static final /* enum */ a ADD = new a();
            private static final /* synthetic */ a[] c;

            public static a[] values() {
                return (a[])c.clone();
            }

            public static a valueOf(String var0) {
                return Enum.valueOf(a.class, var0);
            }

            private static /* synthetic */ a[] a() {
                return new a[]{MUL, ADD};
            }

            static {
                c = a.a();
            }
        }
    }

    static interface v
    extends DensityFunction {
        public DensityFunction.c offsetNoise();

        @Override
        default public double minValue() {
            return -this.maxValue();
        }

        @Override
        default public double maxValue() {
            return this.offsetNoise().maxValue() * 4.0;
        }

        default public double compute(double var0, double var2, double var4) {
            return this.offsetNoise().getValue(var0 * 0.25, var2 * 0.25, var4 * 0.25) * 4.0;
        }

        @Override
        default public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }
    }

    public static interface n
    extends DensityFunction {
        public m.a type();

        public DensityFunction wrapped();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return this.type().codec;
        }

        @Override
        default public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new m(this.type(), this.wrapped().mapAll(var0)));
        }
    }

    @VisibleForDebug
    public record k(Holder<DensityFunction> function) implements DensityFunction
    {
        @Override
        public double compute(DensityFunction.b var0) {
            return this.function.value().compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            this.function.value().fillArray(var0, var1);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.f var0) {
            return var0.apply(new k(new Holder.a<DensityFunction>(this.function.value().mapAll(var0))));
        }

        @Override
        public double minValue() {
            return this.function.isBound() ? this.function.value().minValue() : Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return this.function.isBound() ? this.function.value().maxValue() : Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            throw new UnsupportedOperationException("Calling .codec() on HolderHolder");
        }
    }

    public static interface c
    extends DensityFunction.d {
        public static final KeyDispatchDataCodec<DensityFunction> CODEC = KeyDispatchDataCodec.of(MapCodec.unit((Object)b.INSTANCE));

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    static interface q
    extends DensityFunction {
        public DensityFunction input();

        @Override
        default public double compute(DensityFunction.b var0) {
            return this.transform(this.input().compute(var0));
        }

        @Override
        default public void fillArray(double[] var0, DensityFunction.a var1) {
            this.input().fillArray(var0, var1);
            for (int var2 = 0; var2 < var0.length; ++var2) {
                var0[var2] = this.transform(var0[var2]);
            }
        }

        public double transform(double var1);
    }

    static interface y
    extends DensityFunction {
        public DensityFunction input();

        @Override
        default public double compute(DensityFunction.b var0) {
            return this.transform(var0, this.input().compute(var0));
        }

        @Override
        default public void fillArray(double[] var0, DensityFunction.a var1) {
            this.input().fillArray(var0, var1);
            for (int var2 = 0; var2 < var0.length; ++var2) {
                var0[var2] = this.transform(var1.forIndex(var2), var0[var2]);
            }
        }

        public double transform(DensityFunction.b var1, double var2);
    }
}

