/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;

public class MultifaceGrowthFeature
extends WorldGenerator<MultifaceGrowthConfiguration> {
    public MultifaceGrowthFeature(Codec<MultifaceGrowthConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<MultifaceGrowthConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        RandomSource var3 = var0.random();
        MultifaceGrowthConfiguration var4 = var0.config();
        if (!MultifaceGrowthFeature.isAirOrWater(var1.getBlockState(var2))) {
            return false;
        }
        List<EnumDirection> var5 = var4.getShuffledDirections(var3);
        if (MultifaceGrowthFeature.placeGrowthIfPossible(var1, var2, var1.getBlockState(var2), var4, var3, var5)) {
            return true;
        }
        BlockPosition.MutableBlockPosition var6 = var2.mutable();
        block0: for (EnumDirection var8 : var5) {
            var6.set(var2);
            List<EnumDirection> var9 = var4.getShuffledDirectionsExcept(var3, var8.getOpposite());
            for (int var10 = 0; var10 < var4.searchRange; ++var10) {
                var6.setWithOffset((BaseBlockPosition)var2, var8);
                IBlockData var11 = var1.getBlockState(var6);
                if (!MultifaceGrowthFeature.isAirOrWater(var11) && !var11.is(var4.placeBlock)) continue block0;
                if (!MultifaceGrowthFeature.placeGrowthIfPossible(var1, var6, var11, var4, var3, var9)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean placeGrowthIfPossible(GeneratorAccessSeed var0, BlockPosition var1, IBlockData var2, MultifaceGrowthConfiguration var3, RandomSource var4, List<EnumDirection> var5) {
        BlockPosition.MutableBlockPosition var6 = var1.mutable();
        for (EnumDirection var8 : var5) {
            IBlockData var9 = var0.getBlockState(var6.setWithOffset((BaseBlockPosition)var1, var8));
            if (!var9.is(var3.canBePlacedOn)) continue;
            IBlockData var10 = var3.placeBlock.getStateForPlacement(var2, var0, var1, var8);
            if (var10 == null) {
                return false;
            }
            var0.setBlock(var1, var10, 3);
            var0.getChunk(var1).markPosForPostprocessing(var1);
            if (var4.nextFloat() < var3.chanceOfSpreading) {
                var3.placeBlock.getSpreader().spreadFromFaceTowardRandomDirection(var10, var0, var1, var8, var4, true);
            }
            return true;
        }
        return false;
    }

    private static boolean isAirOrWater(IBlockData var0) {
        return var0.isAir() || var0.is(Blocks.WATER);
    }
}

