/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import org.slf4j.Logger;

public class DefinedStructureProcessorJigsawReplacement
extends DefinedStructureProcessor {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<DefinedStructureProcessorJigsawReplacement> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final DefinedStructureProcessorJigsawReplacement INSTANCE = new DefinedStructureProcessorJigsawReplacement();

    private DefinedStructureProcessorJigsawReplacement() {
    }

    @Override
    @Nullable
    public DefinedStructure.BlockInfo processBlock(IWorldReader var0, BlockPosition var1, BlockPosition var2, DefinedStructure.BlockInfo var3, DefinedStructure.BlockInfo var4, DefinedStructureInfo var5) {
        IBlockData var8;
        IBlockData var6 = var4.state();
        if (!var6.is(Blocks.JIGSAW) || SharedConstants.DEBUG_KEEP_JIGSAW_BLOCKS_DURING_STRUCTURE_GEN) {
            return var4;
        }
        if (var4.nbt() == null) {
            LOGGER.warn("Jigsaw block at {} is missing nbt, will not replace", (Object)var1);
            return var4;
        }
        String var7 = var4.nbt().getStringOr("final_state", "minecraft:air");
        try {
            ArgumentBlock.a var9 = ArgumentBlock.parseForBlock(var0.holderLookup(Registries.BLOCK), var7, true);
            var8 = var9.blockState();
        }
        catch (CommandSyntaxException var9) {
            LOGGER.error("Failed to parse jigsaw replacement state '{}' at {}: {}", new Object[]{var7, var1, var9.getMessage()});
            return null;
        }
        if (var8.is(Blocks.STRUCTURE_VOID)) {
            return null;
        }
        return new DefinedStructure.BlockInfo(var4.pos(), var8, null);
    }

    @Override
    protected DefinedStructureStructureProcessorType<?> getType() {
        return DefinedStructureStructureProcessorType.JIGSAW_REPLACEMENT;
    }
}

