/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.redstone.Orientation;

public abstract class RedstoneWireEvaluator {
    protected final BlockRedstoneWire wireBlock;

    protected RedstoneWireEvaluator(BlockRedstoneWire var0) {
        this.wireBlock = var0;
    }

    public abstract void updatePowerStrength(World var1, BlockPosition var2, IBlockData var3, @Nullable Orientation var4, boolean var5);

    protected int getBlockSignal(World var0, BlockPosition var1) {
        return this.wireBlock.getBlockSignal(var0, var1);
    }

    protected int getWireSignal(BlockPosition var0, IBlockData var1) {
        return var1.is(this.wireBlock) ? var1.getValue(BlockRedstoneWire.POWER) : 0;
    }

    protected int getIncomingWireSignal(World var0, BlockPosition var1) {
        int var2 = 0;
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var8;
            BlockPosition var5 = var1.relative(var4);
            IBlockData var6 = var0.getBlockState(var5);
            var2 = Math.max(var2, this.getWireSignal(var5, var6));
            BlockPosition var7 = var1.above();
            if (var6.isRedstoneConductor(var0, var5) && !var0.getBlockState(var7).isRedstoneConductor(var0, var7)) {
                var8 = var5.above();
                var2 = Math.max(var2, this.getWireSignal(var8, var0.getBlockState(var8)));
                continue;
            }
            if (var6.isRedstoneConductor(var0, var5)) continue;
            var8 = var5.below();
            var2 = Math.max(var2, this.getWireSignal(var8, var0.getBlockState(var8)));
        }
        return Math.max(0, var2 - 1);
    }
}

