/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionFillPlayerHead
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionFillPlayerHead> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionFillPlayerHead.commonFields(var02).and((App)LootTableInfo.EntityTarget.CODEC.fieldOf("entity").forGetter(var0 -> var0.entityTarget)).apply((Applicative)var02, LootItemFunctionFillPlayerHead::new));
    private final LootTableInfo.EntityTarget entityTarget;

    public LootItemFunctionFillPlayerHead(List<LootItemCondition> var0, LootTableInfo.EntityTarget var1) {
        super(var0);
        this.entityTarget = var1;
    }

    public LootItemFunctionType<LootItemFunctionFillPlayerHead> getType() {
        return LootItemFunctions.FILL_PLAYER_HEAD;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.entityTarget.getParam());
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        Entity entity;
        if (var0.is(Items.PLAYER_HEAD) && (entity = var1.getOptionalParameter(this.entityTarget.getParam())) instanceof EntityHuman) {
            EntityHuman var2 = (EntityHuman)entity;
            var0.set(DataComponents.PROFILE, ResolvableProfile.createResolved(var2.getGameProfile()));
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> fillPlayerHead(LootTableInfo.EntityTarget var0) {
        return LootItemFunctionFillPlayerHead.simpleBuilder(var1 -> new LootItemFunctionFillPlayerHead((List<LootItemCondition>)var1, var0));
    }
}

