/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.DoubleListOffset;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeSlice;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class VoxelShape {
    protected final VoxelShapeDiscrete shape;
    @Nullable
    private VoxelShape[] faces;

    protected VoxelShape(VoxelShapeDiscrete var0) {
        this.shape = var0;
    }

    public double min(EnumDirection.EnumAxis var0) {
        int var1 = this.shape.firstFull(var0);
        if (var1 >= this.shape.getSize(var0)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.get(var0, var1);
    }

    public double max(EnumDirection.EnumAxis var0) {
        int var1 = this.shape.lastFull(var0);
        if (var1 <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.get(var0, var1);
    }

    public AxisAlignedBB bounds() {
        if (this.isEmpty()) {
            throw SystemUtils.pauseInIde(new UnsupportedOperationException("No bounds for empty shape."));
        }
        return new AxisAlignedBB(this.min(EnumDirection.EnumAxis.X), this.min(EnumDirection.EnumAxis.Y), this.min(EnumDirection.EnumAxis.Z), this.max(EnumDirection.EnumAxis.X), this.max(EnumDirection.EnumAxis.Y), this.max(EnumDirection.EnumAxis.Z));
    }

    public VoxelShape singleEncompassing() {
        if (this.isEmpty()) {
            return VoxelShapes.empty();
        }
        return VoxelShapes.box(this.min(EnumDirection.EnumAxis.X), this.min(EnumDirection.EnumAxis.Y), this.min(EnumDirection.EnumAxis.Z), this.max(EnumDirection.EnumAxis.X), this.max(EnumDirection.EnumAxis.Y), this.max(EnumDirection.EnumAxis.Z));
    }

    protected double get(EnumDirection.EnumAxis var0, int var1) {
        return this.getCoords(var0).getDouble(var1);
    }

    public abstract DoubleList getCoords(EnumDirection.EnumAxis var1);

    public boolean isEmpty() {
        return this.shape.isEmpty();
    }

    public VoxelShape move(Vec3D var0) {
        return this.move(var0.x, var0.y, var0.z);
    }

    public VoxelShape move(BaseBlockPosition var0) {
        return this.move(var0.getX(), var0.getY(), var0.getZ());
    }

    public VoxelShape move(double var0, double var2, double var4) {
        if (this.isEmpty()) {
            return VoxelShapes.empty();
        }
        return new VoxelShapeArray(this.shape, (DoubleList)new DoubleListOffset(this.getCoords(EnumDirection.EnumAxis.X), var0), (DoubleList)new DoubleListOffset(this.getCoords(EnumDirection.EnumAxis.Y), var2), (DoubleList)new DoubleListOffset(this.getCoords(EnumDirection.EnumAxis.Z), var4));
    }

    public VoxelShape optimize() {
        VoxelShape[] var0 = new VoxelShape[]{VoxelShapes.empty()};
        this.forAllBoxes((var1, var3, var5, var7, var9, var11) -> {
            var0[0] = VoxelShapes.joinUnoptimized(var0[0], VoxelShapes.box(var1, var3, var5, var7, var9, var11), OperatorBoolean.OR);
        });
        return var0[0];
    }

    public void forAllEdges(VoxelShapes.a var0) {
        this.shape.forAllEdges((var1, var2, var3, var4, var5, var6) -> var0.consume(this.get(EnumDirection.EnumAxis.X, var1), this.get(EnumDirection.EnumAxis.Y, var2), this.get(EnumDirection.EnumAxis.Z, var3), this.get(EnumDirection.EnumAxis.X, var4), this.get(EnumDirection.EnumAxis.Y, var5), this.get(EnumDirection.EnumAxis.Z, var6)), true);
    }

    public void forAllBoxes(VoxelShapes.a var0) {
        DoubleList var1 = this.getCoords(EnumDirection.EnumAxis.X);
        DoubleList var2 = this.getCoords(EnumDirection.EnumAxis.Y);
        DoubleList var3 = this.getCoords(EnumDirection.EnumAxis.Z);
        this.shape.forAllBoxes((var4, var5, var6, var7, var8, var9) -> var0.consume(var1.getDouble(var4), var2.getDouble(var5), var3.getDouble(var6), var1.getDouble(var7), var2.getDouble(var8), var3.getDouble(var9)), true);
    }

    public List<AxisAlignedBB> toAabbs() {
        ArrayList var0 = Lists.newArrayList();
        this.forAllBoxes((var1, var3, var5, var7, var9, var11) -> var0.add(new AxisAlignedBB(var1, var3, var5, var7, var9, var11)));
        return var0;
    }

    public double min(EnumDirection.EnumAxis var0, double var1, double var3) {
        int var8;
        EnumDirection.EnumAxis var5 = EnumAxisCycle.FORWARD.cycle(var0);
        EnumDirection.EnumAxis var6 = EnumAxisCycle.BACKWARD.cycle(var0);
        int var7 = this.findIndex(var5, var1);
        int var9 = this.shape.firstFull(var0, var7, var8 = this.findIndex(var6, var3));
        if (var9 >= this.shape.getSize(var0)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.get(var0, var9);
    }

    public double max(EnumDirection.EnumAxis var0, double var1, double var3) {
        int var8;
        EnumDirection.EnumAxis var5 = EnumAxisCycle.FORWARD.cycle(var0);
        EnumDirection.EnumAxis var6 = EnumAxisCycle.BACKWARD.cycle(var0);
        int var7 = this.findIndex(var5, var1);
        int var9 = this.shape.lastFull(var0, var7, var8 = this.findIndex(var6, var3));
        if (var9 <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.get(var0, var9);
    }

    protected int findIndex(EnumDirection.EnumAxis var0, double var1) {
        return MathHelper.binarySearch(0, this.shape.getSize(var0) + 1, var3 -> var1 < this.get(var0, var3)) - 1;
    }

    @Nullable
    public MovingObjectPositionBlock clip(Vec3D var0, Vec3D var1, BlockPosition var2) {
        if (this.isEmpty()) {
            return null;
        }
        Vec3D var3 = var1.subtract(var0);
        if (var3.lengthSqr() < 1.0E-7) {
            return null;
        }
        Vec3D var4 = var0.add(var3.scale(0.001));
        if (this.shape.isFullWide(this.findIndex(EnumDirection.EnumAxis.X, var4.x - (double)var2.getX()), this.findIndex(EnumDirection.EnumAxis.Y, var4.y - (double)var2.getY()), this.findIndex(EnumDirection.EnumAxis.Z, var4.z - (double)var2.getZ()))) {
            return new MovingObjectPositionBlock(var4, EnumDirection.getApproximateNearest(var3.x, var3.y, var3.z).getOpposite(), var2, true);
        }
        return AxisAlignedBB.clip(this.toAabbs(), var0, var1, var2);
    }

    public Optional<Vec3D> closestPointTo(Vec3D var0) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        Vec3D[] var1 = new Vec3D[1];
        this.forAllBoxes((var2, var4, var6, var8, var10, var12) -> {
            double var14 = MathHelper.clamp(var0.x(), var2, var8);
            double var16 = MathHelper.clamp(var0.y(), var4, var10);
            double var18 = MathHelper.clamp(var0.z(), var6, var12);
            if (var1[0] == null || var0.distanceToSqr(var14, var16, var18) < var0.distanceToSqr(var1[0])) {
                var1[0] = new Vec3D(var14, var16, var18);
            }
        });
        return Optional.of(var1[0]);
    }

    public VoxelShape getFaceShape(EnumDirection var0) {
        VoxelShape var1;
        if (this.isEmpty() || this == VoxelShapes.block()) {
            return this;
        }
        if (this.faces != null) {
            var1 = this.faces[var0.ordinal()];
            if (var1 != null) {
                return var1;
            }
        } else {
            this.faces = new VoxelShape[6];
        }
        this.faces[var0.ordinal()] = var1 = this.calculateFace(var0);
        return var1;
    }

    private VoxelShape calculateFace(EnumDirection var0) {
        EnumDirection.EnumAxis var1 = var0.getAxis();
        if (this.isCubeLikeAlong(var1)) {
            return this;
        }
        EnumDirection.EnumAxisDirection var2 = var0.getAxisDirection();
        int var3 = this.findIndex(var1, var2 == EnumDirection.EnumAxisDirection.POSITIVE ? 0.9999999 : 1.0E-7);
        VoxelShapeSlice var4 = new VoxelShapeSlice(this, var1, var3);
        if (var4.isEmpty()) {
            return VoxelShapes.empty();
        }
        if (var4.isCubeLike()) {
            return VoxelShapes.block();
        }
        return var4;
    }

    protected boolean isCubeLike() {
        for (EnumDirection.EnumAxis var3 : EnumDirection.EnumAxis.VALUES) {
            if (this.isCubeLikeAlong(var3)) continue;
            return false;
        }
        return true;
    }

    private boolean isCubeLikeAlong(EnumDirection.EnumAxis var0) {
        DoubleList var1 = this.getCoords(var0);
        return var1.size() == 2 && DoubleMath.fuzzyEquals((double)var1.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)var1.getDouble(1), (double)1.0, (double)1.0E-7);
    }

    public double collide(EnumDirection.EnumAxis var0, AxisAlignedBB var1, double var2) {
        return this.collideX(EnumAxisCycle.between(var0, EnumDirection.EnumAxis.X), var1, var2);
    }

    protected double collideX(EnumAxisCycle var0, AxisAlignedBB var1, double var2) {
        block11: {
            int var17;
            int var15;
            double var10;
            EnumDirection.EnumAxis var5;
            EnumAxisCycle var4;
            block10: {
                if (this.isEmpty()) {
                    return var2;
                }
                if (Math.abs(var2) < 1.0E-7) {
                    return 0.0;
                }
                var4 = var0.inverse();
                var5 = var4.cycle(EnumDirection.EnumAxis.X);
                EnumDirection.EnumAxis var6 = var4.cycle(EnumDirection.EnumAxis.Y);
                EnumDirection.EnumAxis var7 = var4.cycle(EnumDirection.EnumAxis.Z);
                double var8 = var1.max(var5);
                var10 = var1.min(var5);
                int var12 = this.findIndex(var5, var10 + 1.0E-7);
                int var13 = this.findIndex(var5, var8 - 1.0E-7);
                int var14 = Math.max(0, this.findIndex(var6, var1.min(var6) + 1.0E-7));
                var15 = Math.min(this.shape.getSize(var6), this.findIndex(var6, var1.max(var6) - 1.0E-7) + 1);
                int var16 = Math.max(0, this.findIndex(var7, var1.min(var7) + 1.0E-7));
                var17 = Math.min(this.shape.getSize(var7), this.findIndex(var7, var1.max(var7) - 1.0E-7) + 1);
                int var18 = this.shape.getSize(var5);
                if (!(var2 > 0.0)) break block10;
                for (int var19 = var13 + 1; var19 < var18; ++var19) {
                    for (int var20 = var14; var20 < var15; ++var20) {
                        for (int var21 = var16; var21 < var17; ++var21) {
                            if (!this.shape.isFullWide(var4, var19, var20, var21)) continue;
                            double var22 = this.get(var5, var19) - var8;
                            if (var22 >= -1.0E-7) {
                                var2 = Math.min(var2, var22);
                            }
                            return var2;
                        }
                    }
                }
                break block11;
            }
            if (!(var2 < 0.0)) break block11;
            for (int var19 = var12 - 1; var19 >= 0; --var19) {
                for (int var20 = var14; var20 < var15; ++var20) {
                    for (int var21 = var16; var21 < var17; ++var21) {
                        if (!this.shape.isFullWide(var4, var19, var20, var21)) continue;
                        double var22 = this.get(var5, var19 + 1) - var10;
                        if (var22 <= 1.0E-7) {
                            var2 = Math.max(var2, var22);
                        }
                        return var2;
                    }
                }
            }
        }
        return var2;
    }

    public boolean equals(Object var0) {
        return super.equals(var0);
    }

    public String toString() {
        return this.isEmpty() ? "EMPTY" : "VoxelShape[" + String.valueOf(this.bounds()) + "]";
    }
}

