/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class VoxelShapeCollisionEntity
implements VoxelShapeCollision {
    private final boolean descending;
    private final double entityBottom;
    private final boolean placement;
    private final ItemStack heldItem;
    private final boolean alwaysCollideWithFluid;
    @Nullable
    private final Entity entity;

    protected VoxelShapeCollisionEntity(boolean var0, boolean var1, double var2, ItemStack var4, boolean var5, @Nullable Entity var6) {
        this.descending = var0;
        this.placement = var1;
        this.entityBottom = var2;
        this.heldItem = var4;
        this.alwaysCollideWithFluid = var5;
        this.entity = var6;
    }

    @Deprecated
    protected VoxelShapeCollisionEntity(Entity var0, boolean var1, boolean var2) {
        ItemStack itemStack;
        boolean bl = var0.isDescending();
        double d2 = var0.getY();
        if (var0 instanceof EntityLiving) {
            EntityLiving var3 = (EntityLiving)var0;
            itemStack = var3.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        this(bl, var2, d2, itemStack, var1, var0);
    }

    @Override
    public boolean isHoldingItem(Item var0) {
        return this.heldItem.is(var0);
    }

    @Override
    public boolean alwaysCollideWithFluid() {
        return this.alwaysCollideWithFluid;
    }

    @Override
    public boolean canStandOnFluid(Fluid var0, Fluid var1) {
        Entity entity = this.entity;
        if (entity instanceof EntityLiving) {
            EntityLiving var2 = (EntityLiving)entity;
            return var2.canStandOnFluid(var1) && !var0.getType().isSame(var1.getType());
        }
        return false;
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, ICollisionAccess var1, BlockPosition var2) {
        return var0.getCollisionShape(var1, var2, this);
    }

    @Override
    public boolean isDescending() {
        return this.descending;
    }

    @Override
    public boolean isAbove(VoxelShape var0, BlockPosition var1, boolean var2) {
        return this.entityBottom > (double)var1.getY() + var0.max(EnumDirection.EnumAxis.Y) - (double)1.0E-5f;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean isPlacement() {
        return this.placement;
    }

    protected static class a
    extends VoxelShapeCollisionEntity {
        protected static final VoxelShapeCollision WITHOUT_FLUID_COLLISIONS = new a(false);
        protected static final VoxelShapeCollision WITH_FLUID_COLLISIONS = new a(true);

        public a(boolean var0) {
            super(false, false, -1.7976931348623157E308, ItemStack.EMPTY, var0, null);
        }

        @Override
        public boolean isAbove(VoxelShape var0, BlockPosition var1, boolean var2) {
            return var2;
        }
    }
}

