/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class ScoreboardObjective {
    private final Scoreboard scoreboard;
    private final String name;
    private final IScoreboardCriteria criteria;
    public IChatBaseComponent displayName;
    private IChatBaseComponent formattedDisplayName;
    private IScoreboardCriteria.EnumScoreboardHealthDisplay renderType;
    private boolean displayAutoUpdate;
    @Nullable
    private NumberFormat numberFormat;

    public ScoreboardObjective(Scoreboard var0, String var1, IScoreboardCriteria var2, IChatBaseComponent var3, IScoreboardCriteria.EnumScoreboardHealthDisplay var4, boolean var5, @Nullable NumberFormat var6) {
        this.scoreboard = var0;
        this.name = var1;
        this.criteria = var2;
        this.displayName = var3;
        this.formattedDisplayName = this.createFormattedDisplayName();
        this.renderType = var4;
        this.displayAutoUpdate = var5;
        this.numberFormat = var6;
    }

    public a pack() {
        return new a(this.name, this.criteria, this.displayName, this.renderType, this.displayAutoUpdate, Optional.ofNullable(this.numberFormat));
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public String getName() {
        return this.name;
    }

    public IScoreboardCriteria getCriteria() {
        return this.criteria;
    }

    public IChatBaseComponent getDisplayName() {
        return this.displayName;
    }

    public boolean displayAutoUpdate() {
        return this.displayAutoUpdate;
    }

    @Nullable
    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public NumberFormat numberFormatOrDefault(NumberFormat var0) {
        return Objects.requireNonNullElse(this.numberFormat, var0);
    }

    private IChatBaseComponent createFormattedDisplayName() {
        return ChatComponentUtils.wrapInSquareBrackets(this.displayName.copy().withStyle(var0 -> var0.withHoverEvent(new ChatHoverable.e(IChatBaseComponent.literal(this.name)))));
    }

    public IChatBaseComponent getFormattedDisplayName() {
        return this.formattedDisplayName;
    }

    public void setDisplayName(IChatBaseComponent var0) {
        this.displayName = var0;
        this.formattedDisplayName = this.createFormattedDisplayName();
        this.scoreboard.onObjectiveChanged(this);
    }

    public IScoreboardCriteria.EnumScoreboardHealthDisplay getRenderType() {
        return this.renderType;
    }

    public void setRenderType(IScoreboardCriteria.EnumScoreboardHealthDisplay var0) {
        this.renderType = var0;
        this.scoreboard.onObjectiveChanged(this);
    }

    public void setDisplayAutoUpdate(boolean var0) {
        this.displayAutoUpdate = var0;
        this.scoreboard.onObjectiveChanged(this);
    }

    public void setNumberFormat(@Nullable NumberFormat var0) {
        this.numberFormat = var0;
        this.scoreboard.onObjectiveChanged(this);
    }

    public record a(String name, IScoreboardCriteria criteria, IChatBaseComponent displayName, IScoreboardCriteria.EnumScoreboardHealthDisplay renderType, boolean displayAutoUpdate, Optional<NumberFormat> numberFormat) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.fieldOf("Name").forGetter(a::name), (App)IScoreboardCriteria.CODEC.optionalFieldOf("CriteriaName", (Object)IScoreboardCriteria.DUMMY).forGetter(a::criteria), (App)ComponentSerialization.CODEC.fieldOf("DisplayName").forGetter(a::displayName), (App)IScoreboardCriteria.EnumScoreboardHealthDisplay.CODEC.optionalFieldOf("RenderType", IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER).forGetter(a::renderType), (App)Codec.BOOL.optionalFieldOf("display_auto_update", (Object)false).forGetter(a::displayAutoUpdate), (App)NumberFormatTypes.CODEC.optionalFieldOf("format").forGetter(a::numberFormat)).apply((Applicative)var0, a::new));
    }
}

