/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;

public record AdvancementRequirements(List<List<String>> requirements) {
    public static final Codec<AdvancementRequirements> CODEC = Codec.STRING.listOf().listOf().xmap(AdvancementRequirements::new, AdvancementRequirements::requirements);
    public static final AdvancementRequirements EMPTY = new AdvancementRequirements(List.of());

    public AdvancementRequirements(FriendlyByteBuf var02) {
        this(var02.readList(var0 -> var0.readList(FriendlyByteBuf::readUtf)));
    }

    public void write(FriendlyByteBuf var02) {
        var02.writeCollection(this.requirements, (var0, var1) -> var0.writeCollection(var1, FriendlyByteBuf::writeUtf));
    }

    public static AdvancementRequirements allOf(Collection<String> var0) {
        return new AdvancementRequirements(var0.stream().map(List::of).toList());
    }

    public static AdvancementRequirements anyOf(Collection<String> var0) {
        return new AdvancementRequirements(List.of(List.copyOf(var0)));
    }

    public int size() {
        return this.requirements.size();
    }

    public boolean test(Predicate<String> var0) {
        if (this.requirements.isEmpty()) {
            return false;
        }
        for (List<String> var2 : this.requirements) {
            if (AdvancementRequirements.anyMatch(var2, var0)) continue;
            return false;
        }
        return true;
    }

    public int count(Predicate<String> var0) {
        int var1 = 0;
        for (List<String> var3 : this.requirements) {
            if (!AdvancementRequirements.anyMatch(var3, var0)) continue;
            ++var1;
        }
        return var1;
    }

    private static boolean anyMatch(List<String> var0, Predicate<String> var1) {
        for (String var3 : var0) {
            if (!var1.test(var3)) continue;
            return true;
        }
        return false;
    }

    public DataResult<AdvancementRequirements> validate(Set<String> var0) {
        ObjectOpenHashSet var1 = new ObjectOpenHashSet();
        for (List<String> list : this.requirements) {
            if (list.isEmpty() && var0.isEmpty()) {
                return DataResult.error(() -> "Requirement entry cannot be empty");
            }
            var1.addAll(list);
        }
        if (!var0.equals(var1)) {
            Sets.SetView var2 = Sets.difference(var0, (Set)var1);
            Sets.SetView setView = Sets.difference((Set)var1, var0);
            return DataResult.error(() -> AdvancementRequirements.lambda$validate$3((Set)var2, (Set)setView));
        }
        return DataResult.success((Object)this);
    }

    public boolean isEmpty() {
        return this.requirements.isEmpty();
    }

    @Override
    public String toString() {
        return this.requirements.toString();
    }

    public Set<String> names() {
        ObjectOpenHashSet var0 = new ObjectOpenHashSet();
        for (List<String> var2 : this.requirements) {
            var0.addAll(var2);
        }
        return var0;
    }

    private static /* synthetic */ String lambda$validate$3(Set var0, Set var1) {
        return "Advancement completion requirements did not exactly match specified criteria. Missing: " + String.valueOf(var0) + ". Unknown: " + String.valueOf(var1);
    }

    public static interface Strategy {
        public static final Strategy AND = AdvancementRequirements::allOf;
        public static final Strategy OR = AdvancementRequirements::anyOf;

        public AdvancementRequirements create(Collection<String> var1);
    }
}

