/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SlotsPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;

public record EntityPredicate(Optional<EntityTypePredicate> entityType, Optional<DistancePredicate> distanceToPlayer, Optional<MovementPredicate> movement, LocationWrapper location, Optional<MobEffectsPredicate> effects, Optional<NbtPredicate> nbt, Optional<EntityFlagsPredicate> flags, Optional<EntityEquipmentPredicate> equipment, Optional<EntitySubPredicate> subPredicate, Optional<Integer> periodicTick, Optional<EntityPredicate> vehicle, Optional<EntityPredicate> passenger, Optional<EntityPredicate> targetedEntity, Optional<String> team, Optional<SlotsPredicate> slots, DataComponentMatchers components) {
    public static final Codec<EntityPredicate> CODEC = Codec.recursive((String)"EntityPredicate", var0 -> RecordCodecBuilder.create(var1 -> var1.group((App)EntityTypePredicate.CODEC.optionalFieldOf("type").forGetter(EntityPredicate::entityType), (App)DistancePredicate.CODEC.optionalFieldOf("distance").forGetter(EntityPredicate::distanceToPlayer), (App)MovementPredicate.CODEC.optionalFieldOf("movement").forGetter(EntityPredicate::movement), (App)LocationWrapper.CODEC.forGetter(EntityPredicate::location), (App)MobEffectsPredicate.CODEC.optionalFieldOf("effects").forGetter(EntityPredicate::effects), (App)NbtPredicate.CODEC.optionalFieldOf("nbt").forGetter(EntityPredicate::nbt), (App)EntityFlagsPredicate.CODEC.optionalFieldOf("flags").forGetter(EntityPredicate::flags), (App)EntityEquipmentPredicate.CODEC.optionalFieldOf("equipment").forGetter(EntityPredicate::equipment), (App)EntitySubPredicate.CODEC.optionalFieldOf("type_specific").forGetter(EntityPredicate::subPredicate), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("periodic_tick").forGetter(EntityPredicate::periodicTick), (App)var0.optionalFieldOf("vehicle").forGetter(EntityPredicate::vehicle), (App)var0.optionalFieldOf("passenger").forGetter(EntityPredicate::passenger), (App)var0.optionalFieldOf("targeted_entity").forGetter(EntityPredicate::targetedEntity), (App)Codec.STRING.optionalFieldOf("team").forGetter(EntityPredicate::team), (App)SlotsPredicate.CODEC.optionalFieldOf("slots").forGetter(EntityPredicate::slots), (App)DataComponentMatchers.CODEC.forGetter(EntityPredicate::components)).apply((Applicative)var1, EntityPredicate::new)));
    public static final Codec<ContextAwarePredicate> ADVANCEMENT_CODEC = Codec.withAlternative(ContextAwarePredicate.CODEC, CODEC, EntityPredicate::wrap);

    public static ContextAwarePredicate wrap(Builder var0) {
        return EntityPredicate.wrap(var0.build());
    }

    public static Optional<ContextAwarePredicate> wrap(Optional<EntityPredicate> var0) {
        return var0.map(EntityPredicate::wrap);
    }

    public static List<ContextAwarePredicate> wrap(Builder ... var0) {
        return Stream.of(var0).map(EntityPredicate::wrap).toList();
    }

    public static ContextAwarePredicate wrap(EntityPredicate var0) {
        LootItemCondition var1 = LootItemEntityPropertyCondition.hasProperties(LootContext.EntityTarget.THIS, var0).build();
        return new ContextAwarePredicate(List.of(var1));
    }

    public boolean matches(ServerPlayer var0, @Nullable Entity var1) {
        return this.matches(var0.level(), var0.position(), var1);
    }

    public boolean matches(ServerLevel var0, @Nullable Vec3 var1, @Nullable Entity var22) {
        Object var3;
        if (var22 == null) {
            return false;
        }
        if (this.entityType.isPresent() && !this.entityType.get().matches(var22.getType())) {
            return false;
        }
        if (var1 == null ? this.distanceToPlayer.isPresent() : this.distanceToPlayer.isPresent() && !this.distanceToPlayer.get().matches(var1.x, var1.y, var1.z, var22.getX(), var22.getY(), var22.getZ())) {
            return false;
        }
        if (this.movement.isPresent()) {
            var3 = var22.getKnownMovement();
            Vec3 var4 = ((Vec3)var3).scale(20.0);
            if (!this.movement.get().matches(var4.x, var4.y, var4.z, var22.fallDistance)) {
                return false;
            }
        }
        if (this.location.located.isPresent() && !this.location.located.get().matches(var0, var22.getX(), var22.getY(), var22.getZ())) {
            return false;
        }
        if (this.location.steppingOn.isPresent()) {
            var3 = Vec3.atCenterOf(var22.getOnPos());
            if (!var22.onGround() || !this.location.steppingOn.get().matches(var0, ((Vec3)var3).x(), ((Vec3)var3).y(), ((Vec3)var3).z())) {
                return false;
            }
        }
        if (this.location.affectsMovement.isPresent()) {
            var3 = Vec3.atCenterOf(var22.getBlockPosBelowThatAffectsMyMovement());
            if (!this.location.affectsMovement.get().matches(var0, ((Vec3)var3).x(), ((Vec3)var3).y(), ((Vec3)var3).z())) {
                return false;
            }
        }
        if (this.effects.isPresent() && !this.effects.get().matches(var22)) {
            return false;
        }
        if (this.flags.isPresent() && !this.flags.get().matches(var22)) {
            return false;
        }
        if (this.equipment.isPresent() && !this.equipment.get().matches(var22)) {
            return false;
        }
        if (this.subPredicate.isPresent() && !this.subPredicate.get().matches(var22, var0, var1)) {
            return false;
        }
        if (this.vehicle.isPresent() && !this.vehicle.get().matches(var0, var1, var22.getVehicle())) {
            return false;
        }
        if (this.passenger.isPresent() && var22.getPassengers().stream().noneMatch(var2 -> this.passenger.get().matches(var0, var1, (Entity)var2))) {
            return false;
        }
        if (this.targetedEntity.isPresent() && !this.targetedEntity.get().matches(var0, var1, var22 instanceof Mob ? ((Mob)var22).getTarget() : null)) {
            return false;
        }
        if (this.periodicTick.isPresent() && var22.tickCount % this.periodicTick.get() != 0) {
            return false;
        }
        if (this.team.isPresent() && ((var3 = var22.getTeam()) == null || !this.team.get().equals(((Team)var3).getName()))) {
            return false;
        }
        if (this.slots.isPresent() && !this.slots.get().matches(var22)) {
            return false;
        }
        if (!this.components.test(var22)) {
            return false;
        }
        return this.nbt.isEmpty() || this.nbt.get().matches(var22);
    }

    public static LootContext createContext(ServerPlayer var0, Entity var1) {
        LootParams var2 = new LootParams.Builder(var0.level()).withParameter(LootContextParams.THIS_ENTITY, var1).withParameter(LootContextParams.ORIGIN, var0.position()).create(LootContextParamSets.ADVANCEMENT_ENTITY);
        return new LootContext.Builder(var2).create(Optional.empty());
    }

    public static final class LocationWrapper
    extends Record {
        final Optional<LocationPredicate> located;
        final Optional<LocationPredicate> steppingOn;
        final Optional<LocationPredicate> affectsMovement;
        public static final MapCodec<LocationWrapper> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(LocationWrapper::located), (App)LocationPredicate.CODEC.optionalFieldOf("stepping_on").forGetter(LocationWrapper::steppingOn), (App)LocationPredicate.CODEC.optionalFieldOf("movement_affected_by").forGetter(LocationWrapper::affectsMovement)).apply((Applicative)var0, LocationWrapper::new));

        public LocationWrapper(Optional<LocationPredicate> var0, Optional<LocationPredicate> var1, Optional<LocationPredicate> var2) {
            this.located = var0;
            this.steppingOn = var1;
            this.affectsMovement = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LocationWrapper.class, "located;steppingOn;affectsMovement", "located", "steppingOn", "affectsMovement"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LocationWrapper.class, "located;steppingOn;affectsMovement", "located", "steppingOn", "affectsMovement"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LocationWrapper.class, "located;steppingOn;affectsMovement", "located", "steppingOn", "affectsMovement"}, this, var0);
        }

        public Optional<LocationPredicate> located() {
            return this.located;
        }

        public Optional<LocationPredicate> steppingOn() {
            return this.steppingOn;
        }

        public Optional<LocationPredicate> affectsMovement() {
            return this.affectsMovement;
        }
    }

    public static class Builder {
        private Optional<EntityTypePredicate> entityType = Optional.empty();
        private Optional<DistancePredicate> distanceToPlayer = Optional.empty();
        private Optional<MovementPredicate> movement = Optional.empty();
        private Optional<LocationPredicate> located = Optional.empty();
        private Optional<LocationPredicate> steppingOnLocation = Optional.empty();
        private Optional<LocationPredicate> movementAffectedBy = Optional.empty();
        private Optional<MobEffectsPredicate> effects = Optional.empty();
        private Optional<NbtPredicate> nbt = Optional.empty();
        private Optional<EntityFlagsPredicate> flags = Optional.empty();
        private Optional<EntityEquipmentPredicate> equipment = Optional.empty();
        private Optional<EntitySubPredicate> subPredicate = Optional.empty();
        private Optional<Integer> periodicTick = Optional.empty();
        private Optional<EntityPredicate> vehicle = Optional.empty();
        private Optional<EntityPredicate> passenger = Optional.empty();
        private Optional<EntityPredicate> targetedEntity = Optional.empty();
        private Optional<String> team = Optional.empty();
        private Optional<SlotsPredicate> slots = Optional.empty();
        private DataComponentMatchers components = DataComponentMatchers.ANY;

        public static Builder entity() {
            return new Builder();
        }

        public Builder of(HolderGetter<EntityType<?>> var0, EntityType<?> var1) {
            this.entityType = Optional.of(EntityTypePredicate.of(var0, var1));
            return this;
        }

        public Builder of(HolderGetter<EntityType<?>> var0, TagKey<EntityType<?>> var1) {
            this.entityType = Optional.of(EntityTypePredicate.of(var0, var1));
            return this;
        }

        public Builder entityType(EntityTypePredicate var0) {
            this.entityType = Optional.of(var0);
            return this;
        }

        public Builder distance(DistancePredicate var0) {
            this.distanceToPlayer = Optional.of(var0);
            return this;
        }

        public Builder moving(MovementPredicate var0) {
            this.movement = Optional.of(var0);
            return this;
        }

        public Builder located(LocationPredicate.Builder var0) {
            this.located = Optional.of(var0.build());
            return this;
        }

        public Builder steppingOn(LocationPredicate.Builder var0) {
            this.steppingOnLocation = Optional.of(var0.build());
            return this;
        }

        public Builder movementAffectedBy(LocationPredicate.Builder var0) {
            this.movementAffectedBy = Optional.of(var0.build());
            return this;
        }

        public Builder effects(MobEffectsPredicate.Builder var0) {
            this.effects = var0.build();
            return this;
        }

        public Builder nbt(NbtPredicate var0) {
            this.nbt = Optional.of(var0);
            return this;
        }

        public Builder flags(EntityFlagsPredicate.Builder var0) {
            this.flags = Optional.of(var0.build());
            return this;
        }

        public Builder equipment(EntityEquipmentPredicate.Builder var0) {
            this.equipment = Optional.of(var0.build());
            return this;
        }

        public Builder equipment(EntityEquipmentPredicate var0) {
            this.equipment = Optional.of(var0);
            return this;
        }

        public Builder subPredicate(EntitySubPredicate var0) {
            this.subPredicate = Optional.of(var0);
            return this;
        }

        public Builder periodicTick(int var0) {
            this.periodicTick = Optional.of(var0);
            return this;
        }

        public Builder vehicle(Builder var0) {
            this.vehicle = Optional.of(var0.build());
            return this;
        }

        public Builder passenger(Builder var0) {
            this.passenger = Optional.of(var0.build());
            return this;
        }

        public Builder targetedEntity(Builder var0) {
            this.targetedEntity = Optional.of(var0.build());
            return this;
        }

        public Builder team(String var0) {
            this.team = Optional.of(var0);
            return this;
        }

        public Builder slots(SlotsPredicate var0) {
            this.slots = Optional.of(var0);
            return this;
        }

        public Builder components(DataComponentMatchers var0) {
            this.components = var0;
            return this;
        }

        public EntityPredicate build() {
            return new EntityPredicate(this.entityType, this.distanceToPlayer, this.movement, new LocationWrapper(this.located, this.steppingOnLocation, this.movementAffectedBy), this.effects, this.nbt, this.flags, this.equipment, this.subPredicate, this.periodicTick, this.vehicle, this.passenger, this.targetedEntity, this.team, this.slots, this.components);
        }
    }
}

