/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ParticleArgument
implements ArgumentType<ParticleOptions> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "particle{foo:bar}");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_PARTICLE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("particle.notFound", var0));
    public static final DynamicCommandExceptionType ERROR_INVALID_OPTIONS = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("particle.invalidOptions", var0));
    private final HolderLookup.Provider registries;
    private static final TagParser<?> VALUE_PARSER = TagParser.create(NbtOps.INSTANCE);

    public ParticleArgument(CommandBuildContext var0) {
        this.registries = var0;
    }

    public static ParticleArgument particle(CommandBuildContext var0) {
        return new ParticleArgument(var0);
    }

    public static ParticleOptions getParticle(CommandContext<CommandSourceStack> var0, String var1) {
        return (ParticleOptions)var0.getArgument(var1, ParticleOptions.class);
    }

    public ParticleOptions parse(StringReader var0) throws CommandSyntaxException {
        return ParticleArgument.readParticle(var0, this.registries);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static ParticleOptions readParticle(StringReader var0, HolderLookup.Provider var1) throws CommandSyntaxException {
        ParticleType<?> var2 = ParticleArgument.readParticleType(var0, var1.lookupOrThrow(Registries.PARTICLE_TYPE));
        return ParticleArgument.readParticle(VALUE_PARSER, var0, var2, var1);
    }

    private static ParticleType<?> readParticleType(StringReader var0, HolderLookup<ParticleType<?>> var1) throws CommandSyntaxException {
        ResourceLocation var2 = ResourceLocation.read(var0);
        ResourceKey<ParticleType<?>> var3 = ResourceKey.create(Registries.PARTICLE_TYPE, var2);
        return var1.get(var3).orElseThrow(() -> ERROR_UNKNOWN_PARTICLE.createWithContext((ImmutableStringReader)var0, (Object)var2)).value();
    }

    private static <T extends ParticleOptions, O> T readParticle(TagParser<O> var0, StringReader var1, ParticleType<T> var2, HolderLookup.Provider var3) throws CommandSyntaxException {
        RegistryOps<O> var5 = var3.createSerializationContext(var0.getOps());
        Object var4 = var1.canRead() && var1.peek() == '{' ? var0.parseAsArgument(var1) : var5.emptyMap();
        return (T)((ParticleOptions)var2.codec().codec().parse(var5, var4).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)ERROR_INVALID_OPTIONS).create(arg_0)));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        HolderGetter var2 = this.registries.lookupOrThrow(Registries.PARTICLE_TYPE);
        return SharedSuggestionProvider.suggestResource(var2.listElementIds().map(ResourceKey::location), var1);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

