/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockPredicateArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    private final HolderLookup<Block> blocks;

    public BlockPredicateArgument(CommandBuildContext var0) {
        this.blocks = var0.lookupOrThrow(Registries.BLOCK);
    }

    public static BlockPredicateArgument blockPredicate(CommandBuildContext var0) {
        return new BlockPredicateArgument(var0);
    }

    public Result parse(StringReader var0) throws CommandSyntaxException {
        return BlockPredicateArgument.parse(this.blocks, var0);
    }

    public static Result parse(HolderLookup<Block> var02, StringReader var1) throws CommandSyntaxException {
        return (Result)BlockStateParser.parseForTesting(var02, var1, true).map(var0 -> new BlockPredicate(var0.blockState(), var0.properties().keySet(), var0.nbt()), var0 -> new TagPredicate(var0.tag(), var0.vagueProperties(), var0.nbt()));
    }

    public static Predicate<BlockInWorld> getBlockPredicate(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return (Predicate)var0.getArgument(var1, Result.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return BlockStateParser.fillSuggestions(this.blocks, var1, true, true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface Result
    extends Predicate<BlockInWorld> {
        public boolean requiresNbt();
    }

    static class TagPredicate
    implements Result {
        private final HolderSet<Block> tag;
        @Nullable
        private final CompoundTag nbt;
        private final Map<String, String> vagueProperties;

        TagPredicate(HolderSet<Block> var0, Map<String, String> var1, @Nullable CompoundTag var2) {
            this.tag = var0;
            this.vagueProperties = var1;
            this.nbt = var2;
        }

        @Override
        public boolean test(BlockInWorld var0) {
            BlockState var1 = var0.getState();
            if (!var1.is(this.tag)) {
                return false;
            }
            for (Map.Entry<String, String> var3 : this.vagueProperties.entrySet()) {
                Property<?> var4 = var1.getBlock().getStateDefinition().getProperty(var3.getKey());
                if (var4 == null) {
                    return false;
                }
                Comparable var5 = var4.getValue(var3.getValue()).orElse(null);
                if (var5 == null) {
                    return false;
                }
                if (var1.getValue(var4) == var5) continue;
                return false;
            }
            if (this.nbt != null) {
                BlockEntity var2 = var0.getEntity();
                return var2 != null && NbtUtils.compareNbt(this.nbt, var2.saveWithFullMetadata(var0.getLevel().registryAccess()), true);
            }
            return true;
        }

        @Override
        public boolean requiresNbt() {
            return this.nbt != null;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((BlockInWorld)object);
        }
    }

    static class BlockPredicate
    implements Result {
        private final BlockState state;
        private final Set<Property<?>> properties;
        @Nullable
        private final CompoundTag nbt;

        public BlockPredicate(BlockState var0, Set<Property<?>> var1, @Nullable CompoundTag var2) {
            this.state = var0;
            this.properties = var1;
            this.nbt = var2;
        }

        @Override
        public boolean test(BlockInWorld var0) {
            BlockState var1 = var0.getState();
            if (!var1.is(this.state.getBlock())) {
                return false;
            }
            for (Property<?> var3 : this.properties) {
                if (var1.getValue(var3) == this.state.getValue(var3)) continue;
                return false;
            }
            if (this.nbt != null) {
                BlockEntity var2 = var0.getEntity();
                return var2 != null && NbtUtils.compareNbt(this.nbt, var2.saveWithFullMetadata(var0.getLevel().registryAccess()), true);
            }
            return true;
        }

        @Override
        public boolean requiresNbt() {
            return this.nbt != null;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((BlockInWorld)object);
        }
    }
}

