/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public record LocalCoordinates(double left, double up, double forwards) implements Coordinates
{
    public static final char PREFIX_LOCAL_COORDINATE = '^';

    @Override
    public Vec3 getPosition(CommandSourceStack var0) {
        Vec2 var1 = var0.getRotation();
        Vec3 var2 = var0.getAnchor().apply(var0);
        float var3 = Mth.cos((var1.y + 90.0f) * ((float)Math.PI / 180));
        float var4 = Mth.sin((var1.y + 90.0f) * ((float)Math.PI / 180));
        float var5 = Mth.cos(-var1.x * ((float)Math.PI / 180));
        float var6 = Mth.sin(-var1.x * ((float)Math.PI / 180));
        float var7 = Mth.cos((-var1.x + 90.0f) * ((float)Math.PI / 180));
        float var8 = Mth.sin((-var1.x + 90.0f) * ((float)Math.PI / 180));
        Vec3 var9 = new Vec3(var3 * var5, var6, var4 * var5);
        Vec3 var10 = new Vec3(var3 * var7, var8, var4 * var7);
        Vec3 var11 = var9.cross(var10).scale(-1.0);
        double var12 = var9.x * this.forwards + var10.x * this.up + var11.x * this.left;
        double var14 = var9.y * this.forwards + var10.y * this.up + var11.y * this.left;
        double var16 = var9.z * this.forwards + var10.z * this.up + var11.z * this.left;
        return new Vec3(var2.x + var12, var2.y + var14, var2.z + var16);
    }

    @Override
    public Vec2 getRotation(CommandSourceStack var0) {
        return Vec2.ZERO;
    }

    @Override
    public boolean isXRelative() {
        return true;
    }

    @Override
    public boolean isYRelative() {
        return true;
    }

    @Override
    public boolean isZRelative() {
        return true;
    }

    public static LocalCoordinates parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        double var2 = LocalCoordinates.readDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        double var4 = LocalCoordinates.readDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        double var6 = LocalCoordinates.readDouble(var0, var1);
        return new LocalCoordinates(var2, var4, var6);
    }

    private static double readDouble(StringReader var0, int var1) throws CommandSyntaxException {
        if (!var0.canRead()) {
            throw WorldCoordinate.ERROR_EXPECTED_DOUBLE.createWithContext((ImmutableStringReader)var0);
        }
        if (var0.peek() != '^') {
            var0.setCursor(var1);
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        return var0.canRead() && var0.peek() != ' ' ? var0.readDouble() : 0.0;
    }
}

