/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.AncientCityStructurePieces;
import net.minecraft.data.worldgen.BastionPieces;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.PillagerOutpostPools;
import net.minecraft.data.worldgen.TrailRuinsStructurePools;
import net.minecraft.data.worldgen.TrialChambersStructurePools;
import net.minecraft.data.worldgen.VillagePools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class Pools {
    public static final ResourceKey<StructureTemplatePool> EMPTY = Pools.createKey("empty");

    public static ResourceKey<StructureTemplatePool> createKey(ResourceLocation var0) {
        return ResourceKey.create(Registries.TEMPLATE_POOL, var0);
    }

    public static ResourceKey<StructureTemplatePool> createKey(String var0) {
        return Pools.createKey(ResourceLocation.withDefaultNamespace(var0));
    }

    public static ResourceKey<StructureTemplatePool> parseKey(String var0) {
        return Pools.createKey(ResourceLocation.parse(var0));
    }

    public static void register(BootstrapContext<StructureTemplatePool> var0, String var1, StructureTemplatePool var2) {
        var0.register(Pools.createKey(var1), var2);
    }

    public static void bootstrap(BootstrapContext<StructureTemplatePool> var0) {
        HolderGetter<StructureTemplatePool> var1 = var0.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> var2 = var1.getOrThrow(EMPTY);
        var0.register(EMPTY, new StructureTemplatePool(var2, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of(), StructureTemplatePool.Projection.RIGID));
        BastionPieces.bootstrap(var0);
        PillagerOutpostPools.bootstrap(var0);
        VillagePools.bootstrap(var0);
        AncientCityStructurePieces.bootstrap(var0);
        TrailRuinsStructurePools.bootstrap(var0);
        TrialChambersStructurePools.bootstrap(var0);
    }
}

