/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestSequence;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class GameTestHelper {
    private final GameTestInfo testInfo;
    private boolean finalCheckAdded;

    public GameTestHelper(GameTestInfo var0) {
        this.testInfo = var0;
    }

    public GameTestAssertException assertionException(Component var0) {
        return new GameTestAssertException(var0, this.testInfo.getTick());
    }

    public GameTestAssertException assertionException(String var0, Object ... var1) {
        return this.assertionException(Component.translatableEscape(var0, var1));
    }

    public GameTestAssertPosException assertionException(BlockPos var0, Component var1) {
        return new GameTestAssertPosException(var1, this.absolutePos(var0), var0, this.testInfo.getTick());
    }

    public GameTestAssertPosException assertionException(BlockPos var0, String var1, Object ... var2) {
        return this.assertionException(var0, Component.translatableEscape(var1, var2));
    }

    public ServerLevel getLevel() {
        return this.testInfo.getLevel();
    }

    public BlockState getBlockState(BlockPos var0) {
        return this.getLevel().getBlockState(this.absolutePos(var0));
    }

    public <T extends BlockEntity> T getBlockEntity(BlockPos var0, Class<T> var1) {
        BlockEntity var2 = this.getLevel().getBlockEntity(this.absolutePos(var0));
        if (var2 == null) {
            throw this.assertionException(var0, "test.error.missing_block_entity", new Object[0]);
        }
        if (var1.isInstance(var2)) {
            return (T)((BlockEntity)var1.cast(var2));
        }
        throw this.assertionException(var0, "test.error.wrong_block_entity", var2.getType().builtInRegistryHolder().getRegisteredName());
    }

    public void killAllEntities() {
        this.killAllEntitiesOfClass(Entity.class);
    }

    public void killAllEntitiesOfClass(Class<? extends Entity> var02) {
        AABB var1 = this.getBounds();
        List<Entity> var2 = this.getLevel().getEntitiesOfClass(var02, var1.inflate(1.0), var0 -> !(var0 instanceof Player));
        var2.forEach(var0 -> var0.kill(this.getLevel()));
    }

    public ItemEntity spawnItem(Item var0, Vec3 var1) {
        ServerLevel var2 = this.getLevel();
        Vec3 var3 = this.absoluteVec(var1);
        ItemEntity var4 = new ItemEntity(var2, var3.x, var3.y, var3.z, new ItemStack(var0, 1));
        var4.setDeltaMovement(0.0, 0.0, 0.0);
        var2.addFreshEntity(var4);
        return var4;
    }

    public ItemEntity spawnItem(Item var0, float var1, float var2, float var3) {
        return this.spawnItem(var0, new Vec3(var1, var2, var3));
    }

    public ItemEntity spawnItem(Item var0, BlockPos var1) {
        return this.spawnItem(var0, var1.getX(), var1.getY(), var1.getZ());
    }

    public <E extends Entity> E spawn(EntityType<E> var0, BlockPos var1) {
        return this.spawn(var0, Vec3.atBottomCenterOf(var1));
    }

    public <E extends Entity> List<E> spawn(EntityType<E> var0, BlockPos var1, int var2) {
        return this.spawn(var0, Vec3.atBottomCenterOf(var1), var2);
    }

    public <E extends Entity> List<E> spawn(EntityType<E> var0, Vec3 var1, int var2) {
        ArrayList<E> var3 = new ArrayList<E>();
        for (int var4 = 0; var4 < var2; ++var4) {
            var3.add(this.spawn(var0, var1));
        }
        return var3;
    }

    public <E extends Entity> E spawn(EntityType<E> var0, Vec3 var1) {
        Object var4;
        ServerLevel var2 = this.getLevel();
        E var3 = var0.create(var2, EntitySpawnReason.STRUCTURE);
        if (var3 == null) {
            throw this.assertionException(BlockPos.containing(var1), "test.error.spawn_failure", var0.builtInRegistryHolder().getRegisteredName());
        }
        if (var3 instanceof Mob) {
            var4 = (Mob)var3;
            ((Mob)var4).setPersistenceRequired();
        }
        var4 = this.absoluteVec(var1);
        float var5 = ((Entity)var3).rotate(this.getTestRotation());
        ((Entity)var3).snapTo(((Vec3)var4).x, ((Vec3)var4).y, ((Vec3)var4).z, var5, ((Entity)var3).getXRot());
        ((Entity)var3).setYBodyRot(var5);
        ((Entity)var3).setYHeadRot(var5);
        var2.addFreshEntity((Entity)var3);
        return var3;
    }

    public void hurt(Entity var0, DamageSource var1, float var2) {
        var0.hurtServer(this.getLevel(), var1, var2);
    }

    public void kill(Entity var0) {
        var0.kill(this.getLevel());
    }

    public <E extends Entity> E findOneEntity(EntityType<E> var0) {
        return this.findClosestEntity(var0, 0, 0, 0, 2.147483647E9);
    }

    public <E extends Entity> E findClosestEntity(EntityType<E> var0, int var12, int var22, int var3, double var4) {
        List<E> var6 = this.findEntities(var0, var12, var22, var3, var4);
        if (var6.isEmpty()) {
            throw this.assertionException("test.error.expected_entity_around", var0.getDescription(), var12, var22, var3);
        }
        if (var6.size() > 1) {
            throw this.assertionException("test.error.too_many_entities", var0.toShortString(), var12, var22, var3, var6.size());
        }
        Vec3 var7 = this.absoluteVec(new Vec3(var12, var22, var3));
        var6.sort((var1, var2) -> {
            double var3 = var1.position().distanceTo(var7);
            double var5 = var2.position().distanceTo(var7);
            return Double.compare(var3, var5);
        });
        return (E)((Entity)var6.get(0));
    }

    public <E extends Entity> List<E> findEntities(EntityType<E> var0, int var1, int var2, int var3, double var4) {
        return this.findEntities(var0, Vec3.atBottomCenterOf(new BlockPos(var1, var2, var3)), var4);
    }

    public <E extends Entity> List<E> findEntities(EntityType<E> var0, Vec3 var12, double var2) {
        ServerLevel var4 = this.getLevel();
        Vec3 var5 = this.absoluteVec(var12);
        AABB var6 = this.testInfo.getStructureBounds();
        AABB var7 = new AABB(var5.add(-var2, -var2, -var2), var5.add(var2, var2, var2));
        return var4.getEntities(var0, var6, var1 -> var1.getBoundingBox().intersects(var7) && var1.isAlive());
    }

    public <E extends Entity> E spawn(EntityType<E> var0, int var1, int var2, int var3) {
        return this.spawn(var0, new BlockPos(var1, var2, var3));
    }

    public <E extends Entity> E spawn(EntityType<E> var0, float var1, float var2, float var3) {
        return this.spawn(var0, new Vec3(var1, var2, var3));
    }

    public <E extends Mob> E spawnWithNoFreeWill(EntityType<E> var0, BlockPos var1) {
        Mob var2 = (Mob)this.spawn(var0, var1);
        var2.removeFreeWill();
        return (E)var2;
    }

    public <E extends Mob> E spawnWithNoFreeWill(EntityType<E> var0, int var1, int var2, int var3) {
        return this.spawnWithNoFreeWill(var0, new BlockPos(var1, var2, var3));
    }

    public <E extends Mob> E spawnWithNoFreeWill(EntityType<E> var0, Vec3 var1) {
        Mob var2 = (Mob)this.spawn(var0, var1);
        var2.removeFreeWill();
        return (E)var2;
    }

    public <E extends Mob> E spawnWithNoFreeWill(EntityType<E> var0, float var1, float var2, float var3) {
        return this.spawnWithNoFreeWill(var0, new Vec3(var1, var2, var3));
    }

    public void moveTo(Mob var0, float var1, float var2, float var3) {
        Vec3 var4 = this.absoluteVec(new Vec3(var1, var2, var3));
        var0.snapTo(var4.x, var4.y, var4.z, var0.getYRot(), var0.getXRot());
    }

    public GameTestSequence walkTo(Mob var0, BlockPos var1, float var2) {
        return this.startSequence().thenExecuteAfter(2, () -> {
            Path var3 = var0.getNavigation().createPath(this.absolutePos(var1), 0);
            var0.getNavigation().moveTo(var3, (double)var2);
        });
    }

    public void pressButton(int var0, int var1, int var2) {
        this.pressButton(new BlockPos(var0, var1, var2));
    }

    public void pressButton(BlockPos var0) {
        this.assertBlockTag(BlockTags.BUTTONS, var0);
        BlockPos var1 = this.absolutePos(var0);
        BlockState var2 = this.getLevel().getBlockState(var1);
        ButtonBlock var3 = (ButtonBlock)var2.getBlock();
        var3.press(var2, this.getLevel(), var1, null);
    }

    public void useBlock(BlockPos var0) {
        this.useBlock(var0, this.makeMockPlayer(GameType.CREATIVE));
    }

    public void useBlock(BlockPos var0, Player var1) {
        BlockPos var2 = this.absolutePos(var0);
        this.useBlock(var0, var1, new BlockHitResult(Vec3.atCenterOf(var2), Direction.NORTH, var2, true));
    }

    public void useBlock(BlockPos var0, Player var1, BlockHitResult var2) {
        InteractionHand var5;
        BlockPos var3 = this.absolutePos(var0);
        BlockState var4 = this.getLevel().getBlockState(var3);
        InteractionResult var6 = var4.useItemOn(var1.getItemInHand(var5 = InteractionHand.MAIN_HAND), this.getLevel(), var1, var5, var2);
        if (var6.consumesAction()) {
            return;
        }
        if (var6 instanceof InteractionResult.TryEmptyHandInteraction && var4.useWithoutItem(this.getLevel(), var1, var2).consumesAction()) {
            return;
        }
        UseOnContext var7 = new UseOnContext(var1, var5, var2);
        var1.getItemInHand(var5).useOn(var7);
    }

    public LivingEntity makeAboutToDrown(LivingEntity var0) {
        var0.setAirSupply(0);
        var0.setHealth(0.25f);
        return var0;
    }

    public LivingEntity withLowHealth(LivingEntity var0) {
        var0.setHealth(0.25f);
        return var0;
    }

    public Player makeMockPlayer(final GameType var0) {
        return new Player(this, this.getLevel(), new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            @Nonnull
            public GameType gameMode() {
                return var0;
            }

            @Override
            public boolean isClientAuthoritative() {
                return false;
            }
        };
    }

    @Deprecated(forRemoval=true)
    public ServerPlayer makeMockServerPlayerInLevel() {
        CommonListenerCookie var0 = CommonListenerCookie.createInitial(new GameProfile(UUID.randomUUID(), "test-mock-player"), false);
        ServerPlayer var1 = new ServerPlayer(this, this.getLevel().getServer(), this.getLevel(), var0.gameProfile(), var0.clientInformation()){

            @Override
            public GameType gameMode() {
                return GameType.CREATIVE;
            }
        };
        Connection var2 = new Connection(PacketFlow.SERVERBOUND);
        EmbeddedChannel var3 = new EmbeddedChannel(new ChannelHandler[]{var2});
        this.getLevel().getServer().getPlayerList().placeNewPlayer(var2, var1, var0);
        return var1;
    }

    public void pullLever(int var0, int var1, int var2) {
        this.pullLever(new BlockPos(var0, var1, var2));
    }

    public void pullLever(BlockPos var0) {
        this.assertBlockPresent(Blocks.LEVER, var0);
        BlockPos var1 = this.absolutePos(var0);
        BlockState var2 = this.getLevel().getBlockState(var1);
        LeverBlock var3 = (LeverBlock)var2.getBlock();
        var3.pull(var2, this.getLevel(), var1, null);
    }

    public void pulseRedstone(BlockPos var0, long var1) {
        this.setBlock(var0, Blocks.REDSTONE_BLOCK);
        this.runAfterDelay(var1, () -> this.setBlock(var0, Blocks.AIR));
    }

    public void destroyBlock(BlockPos var0) {
        this.getLevel().destroyBlock(this.absolutePos(var0), false, null);
    }

    public void setBlock(int var0, int var1, int var2, Block var3) {
        this.setBlock(new BlockPos(var0, var1, var2), var3);
    }

    public void setBlock(int var0, int var1, int var2, BlockState var3) {
        this.setBlock(new BlockPos(var0, var1, var2), var3);
    }

    public void setBlock(BlockPos var0, Block var1) {
        this.setBlock(var0, var1.defaultBlockState());
    }

    public void setBlock(BlockPos var0, BlockState var1) {
        this.getLevel().setBlock(this.absolutePos(var0), var1, 3);
    }

    public void setBlock(BlockPos var0, Block var1, Direction var2) {
        this.setBlock(var0, var1.defaultBlockState(), var2);
    }

    public void setBlock(BlockPos var0, BlockState var1, Direction var2) {
        BlockState var3 = var1;
        if (var1.hasProperty(HorizontalDirectionalBlock.FACING)) {
            var3 = (BlockState)var1.setValue(HorizontalDirectionalBlock.FACING, var2);
        }
        if (var1.hasProperty(BlockStateProperties.FACING)) {
            var3 = (BlockState)var1.setValue(BlockStateProperties.FACING, var2);
        }
        this.getLevel().setBlock(this.absolutePos(var0), var3, 3);
    }

    public void setNight() {
        this.setDayTime(13000);
    }

    public void setDayTime(int var0) {
        this.getLevel().setDayTime(var0);
    }

    public void assertBlockPresent(Block var0, int var1, int var2, int var3) {
        this.assertBlockPresent(var0, new BlockPos(var1, var2, var3));
    }

    public void assertBlockPresent(Block var0, BlockPos var12) {
        BlockState var22 = this.getBlockState(var12);
        this.assertBlock(var12, var2 -> var22.is(var0), var1 -> Component.translatable("test.error.expected_block", var0.getName(), var1.getName()));
    }

    public void assertBlockNotPresent(Block var0, int var1, int var2, int var3) {
        this.assertBlockNotPresent(var0, new BlockPos(var1, var2, var3));
    }

    public void assertBlockNotPresent(Block var0, BlockPos var12) {
        this.assertBlock(var12, var2 -> !this.getBlockState(var12).is(var0), var1 -> Component.translatable("test.error.unexpected_block", var0.getName()));
    }

    public void assertBlockTag(TagKey<Block> var0, BlockPos var12) {
        this.assertBlockState(var12, var1 -> var1.is(var0), var1 -> Component.translatable("test.error.expected_block_tag", Component.translationArg(var0.location()), var1.getBlock().getName()));
    }

    public void succeedWhenBlockPresent(Block var0, int var1, int var2, int var3) {
        this.succeedWhenBlockPresent(var0, new BlockPos(var1, var2, var3));
    }

    public void succeedWhenBlockPresent(Block var0, BlockPos var1) {
        this.succeedWhen(() -> this.assertBlockPresent(var0, var1));
    }

    public void assertBlock(BlockPos var0, Predicate<Block> var12, Function<Block, Component> var2) {
        this.assertBlockState(var0, var1 -> var12.test(var1.getBlock()), var1 -> (Component)var2.apply(var1.getBlock()));
    }

    public <T extends Comparable<T>> void assertBlockProperty(BlockPos var0, Property<T> var1, T var2) {
        BlockState var3 = this.getBlockState(var0);
        boolean var4 = var3.hasProperty(var1);
        if (!var4) {
            throw this.assertionException(var0, "test.error.block_property_missing", var1.getName(), var2);
        }
        if (!var3.getValue(var1).equals(var2)) {
            throw this.assertionException(var0, "test.error.block_property_mismatch", var1.getName(), var2, var3.getValue(var1));
        }
    }

    public <T extends Comparable<T>> void assertBlockProperty(BlockPos var0, Property<T> var12, Predicate<T> var22, Component var3) {
        this.assertBlockState(var0, var2 -> {
            if (!var2.hasProperty(var12)) {
                return false;
            }
            Object var3 = var2.getValue(var12);
            return var22.test(var3);
        }, var1 -> var3);
    }

    public void assertBlockState(BlockPos var0, BlockState var1) {
        BlockState var2 = this.getBlockState(var0);
        if (!var2.equals(var1)) {
            throw this.assertionException(var0, "test.error.state_not_equal", var1, var2);
        }
    }

    public void assertBlockState(BlockPos var0, Predicate<BlockState> var1, Function<BlockState, Component> var2) {
        BlockState var3 = this.getBlockState(var0);
        if (!var1.test(var3)) {
            throw this.assertionException(var0, var2.apply(var3));
        }
    }

    public <T extends BlockEntity> void assertBlockEntityData(BlockPos var0, Class<T> var1, Predicate<T> var2, Supplier<Component> var3) {
        T var4 = this.getBlockEntity(var0, var1);
        if (!var2.test(var4)) {
            throw this.assertionException(var0, var3.get());
        }
    }

    public void assertRedstoneSignal(BlockPos var0, Direction var1, IntPredicate var2, Supplier<Component> var3) {
        BlockPos var4 = this.absolutePos(var0);
        ServerLevel var5 = this.getLevel();
        BlockState var6 = var5.getBlockState(var4);
        int var7 = var6.getSignal(var5, var4, var1);
        if (!var2.test(var7)) {
            throw this.assertionException(var0, var3.get());
        }
    }

    public void assertEntityPresent(EntityType<?> var0) {
        if (!this.getLevel().hasEntities(var0, this.getBounds(), Entity::isAlive)) {
            throw this.assertionException("test.error.expected_entity_in_test", var0.getDescription());
        }
    }

    public void assertEntityPresent(EntityType<?> var0, int var1, int var2, int var3) {
        this.assertEntityPresent(var0, new BlockPos(var1, var2, var3));
    }

    public void assertEntityPresent(EntityType<?> var0, BlockPos var1) {
        BlockPos var2 = this.absolutePos(var1);
        if (!this.getLevel().hasEntities(var0, new AABB(var2), Entity::isAlive)) {
            throw this.assertionException(var1, "test.error.expected_entity", var0.getDescription());
        }
    }

    public void assertEntityPresent(EntityType<?> var0, AABB var1) {
        AABB var2 = this.absoluteAABB(var1);
        if (!this.getLevel().hasEntities(var0, var2, Entity::isAlive)) {
            throw this.assertionException(BlockPos.containing(var1.getCenter()), "test.error.expected_entity", var0.getDescription());
        }
    }

    public void assertEntitiesPresent(EntityType<?> var0, int var1) {
        List<Entity> var2 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (var2.size() != var1) {
            throw this.assertionException("test.error.expected_entity_count", var1, var0.getDescription(), var2.size());
        }
    }

    public void assertEntitiesPresent(EntityType<?> var0, BlockPos var1, int var2, double var3) {
        BlockPos var5 = this.absolutePos(var1);
        List<?> var6 = this.getEntities(var0, var1, var3);
        if (var6.size() != var2) {
            throw this.assertionException(var1, "test.error.expected_entity_count", var2, var0.getDescription(), var6.size());
        }
    }

    public void assertEntityPresent(EntityType<?> var0, BlockPos var1, double var2) {
        List<?> var4 = this.getEntities(var0, var1, var2);
        if (var4.isEmpty()) {
            BlockPos var5 = this.absolutePos(var1);
            throw this.assertionException(var1, "test.error.expected_entity", var0.getDescription());
        }
    }

    public <T extends Entity> List<T> getEntities(EntityType<T> var0, BlockPos var1, double var2) {
        BlockPos var4 = this.absolutePos(var1);
        return this.getLevel().getEntities(var0, new AABB(var4).inflate(var2), Entity::isAlive);
    }

    public <T extends Entity> List<T> getEntities(EntityType<T> var0) {
        return this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
    }

    public void assertEntityInstancePresent(Entity var0, int var1, int var2, int var3) {
        this.assertEntityInstancePresent(var0, new BlockPos(var1, var2, var3));
    }

    public void assertEntityInstancePresent(Entity var0, BlockPos var12) {
        BlockPos var2 = this.absolutePos(var12);
        List<Entity> var3 = this.getLevel().getEntities(var0.getType(), new AABB(var2), Entity::isAlive);
        var3.stream().filter(var1 -> var1 == var0).findFirst().orElseThrow(() -> this.assertionException(var12, "test.error.expected_entity", var0.getType().getDescription()));
    }

    public void assertItemEntityCountIs(Item var0, BlockPos var1, double var2, int var4) {
        BlockPos var5 = this.absolutePos(var1);
        List<ItemEntity> var6 = this.getLevel().getEntities(EntityType.ITEM, new AABB(var5).inflate(var2), Entity::isAlive);
        int var7 = 0;
        for (ItemEntity var9 : var6) {
            ItemStack var10 = var9.getItem();
            if (!var10.is(var0)) continue;
            var7 += var10.getCount();
        }
        if (var7 != var4) {
            throw this.assertionException(var1, "test.error.expected_items_count", var4, var0.getName(), var7);
        }
    }

    public void assertItemEntityPresent(Item var0, BlockPos var12, double var2) {
        BlockPos var4 = this.absolutePos(var12);
        Predicate<ItemEntity> var5 = var1 -> var1.isAlive() && var1.getItem().is(var0);
        if (!this.getLevel().hasEntities(EntityType.ITEM, new AABB(var4).inflate(var2), var5)) {
            throw this.assertionException(var12, "test.error.expected_item", var0.getName());
        }
    }

    public void assertItemEntityNotPresent(Item var0, BlockPos var12, double var2) {
        BlockPos var4 = this.absolutePos(var12);
        Predicate<ItemEntity> var5 = var1 -> var1.isAlive() && var1.getItem().is(var0);
        if (this.getLevel().hasEntities(EntityType.ITEM, new AABB(var4).inflate(var2), var5)) {
            throw this.assertionException(var12, "test.error.unexpected_item", var0.getName());
        }
    }

    public void assertItemEntityPresent(Item var0) {
        Predicate<ItemEntity> var12 = var1 -> var1.isAlive() && var1.getItem().is(var0);
        if (!this.getLevel().hasEntities(EntityType.ITEM, this.getBounds(), var12)) {
            throw this.assertionException("test.error.expected_item", var0.getName());
        }
    }

    public void assertItemEntityNotPresent(Item var0) {
        Predicate<ItemEntity> var12 = var1 -> var1.isAlive() && var1.getItem().is(var0);
        if (this.getLevel().hasEntities(EntityType.ITEM, this.getBounds(), var12)) {
            throw this.assertionException("test.error.unexpected_item", var0.getName());
        }
    }

    public void assertEntityNotPresent(EntityType<?> var0) {
        List<Entity> var1 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (!var1.isEmpty()) {
            throw this.assertionException(var1.getFirst().blockPosition(), "test.error.unexpected_entity", var0.getDescription());
        }
    }

    public void assertEntityNotPresent(EntityType<?> var0, int var1, int var2, int var3) {
        this.assertEntityNotPresent(var0, new BlockPos(var1, var2, var3));
    }

    public void assertEntityNotPresent(EntityType<?> var0, BlockPos var1) {
        BlockPos var2 = this.absolutePos(var1);
        if (this.getLevel().hasEntities(var0, new AABB(var2), Entity::isAlive)) {
            throw this.assertionException(var1, "test.error.unexpected_entity", var0.getDescription());
        }
    }

    public void assertEntityNotPresent(EntityType<?> var0, AABB var1) {
        AABB var2 = this.absoluteAABB(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, var2, Entity::isAlive);
        if (!var3.isEmpty()) {
            throw this.assertionException(var3.getFirst().blockPosition(), "test.error.unexpected_entity", var0.getDescription());
        }
    }

    public void assertEntityTouching(EntityType<?> var0, double var12, double var3, double var5) {
        Vec3 var7 = new Vec3(var12, var3, var5);
        Vec3 var8 = this.absoluteVec(var7);
        Predicate<Entity> var9 = var1 -> var1.getBoundingBox().intersects(var8, var8);
        if (!this.getLevel().hasEntities(var0, this.getBounds(), var9)) {
            throw this.assertionException("test.error.expected_entity_touching", var0.getDescription(), var8.x(), var8.y(), var8.z(), var12, var3, var5);
        }
    }

    public void assertEntityNotTouching(EntityType<?> var0, double var12, double var3, double var5) {
        Vec3 var7 = new Vec3(var12, var3, var5);
        Vec3 var8 = this.absoluteVec(var7);
        Predicate<Entity> var9 = var1 -> !var1.getBoundingBox().intersects(var8, var8);
        if (!this.getLevel().hasEntities(var0, this.getBounds(), var9)) {
            throw this.assertionException("test.error.expected_entity_not_touching", var0.getDescription(), var8.x(), var8.y(), var8.z(), var12, var3, var5);
        }
    }

    public <E extends Entity, T> void assertEntityData(BlockPos var0, EntityType<E> var1, Predicate<E> var2) {
        BlockPos var3 = this.absolutePos(var0);
        List<Entity> var4 = this.getLevel().getEntities(var1, new AABB(var3), Entity::isAlive);
        if (var4.isEmpty()) {
            throw this.assertionException(var0, "test.error.expected_entity", var1.getDescription());
        }
        for (Entity var6 : var4) {
            if (var2.test(var6)) continue;
            throw this.assertionException(var6.blockPosition(), "test.error.expected_entity_data_predicate", var6.getName());
        }
    }

    public <E extends Entity, T> void assertEntityData(BlockPos var0, EntityType<E> var1, Function<? super E, T> var2, @Nullable T var3) {
        BlockPos var4 = this.absolutePos(var0);
        List<Entity> var5 = this.getLevel().getEntities(var1, new AABB(var4), Entity::isAlive);
        if (var5.isEmpty()) {
            throw this.assertionException(var0, "test.error.expected_entity", var1.getDescription());
        }
        for (Entity var7 : var5) {
            T var8 = var2.apply(var7);
            if (Objects.equals(var8, var3)) continue;
            throw this.assertionException(var0, "test.error.expected_entity_data", var3, var8);
        }
    }

    public <E extends LivingEntity> void assertEntityIsHolding(BlockPos var0, EntityType<E> var1, Item var2) {
        BlockPos var3 = this.absolutePos(var0);
        List<LivingEntity> var4 = this.getLevel().getEntities(var1, new AABB(var3), Entity::isAlive);
        if (var4.isEmpty()) {
            throw this.assertionException(var0, "test.error.expected_entity", var1.getDescription());
        }
        for (LivingEntity var6 : var4) {
            if (!var6.isHolding(var2)) continue;
            return;
        }
        throw this.assertionException(var0, "test.error.expected_entity_holding", var2.getName());
    }

    public <E extends Entity> void assertEntityInventoryContains(BlockPos var02, EntityType<E> var12, Item var2) {
        BlockPos var3 = this.absolutePos(var02);
        List<Entity> var4 = this.getLevel().getEntities(var12, new AABB(var3), var0 -> ((Entity)var0).isAlive());
        if (var4.isEmpty()) {
            throw this.assertionException(var02, "test.error.expected_entity", var12.getDescription());
        }
        for (Entity var6 : var4) {
            if (!((InventoryCarrier)((Object)var6)).getInventory().hasAnyMatching(var1 -> var1.is(var2))) continue;
            return;
        }
        throw this.assertionException(var02, "test.error.expected_entity_having", var2.getName());
    }

    public void assertContainerEmpty(BlockPos var0) {
        BaseContainerBlockEntity var1 = this.getBlockEntity(var0, BaseContainerBlockEntity.class);
        if (!var1.isEmpty()) {
            throw this.assertionException(var0, "test.error.expected_empty_container", new Object[0]);
        }
    }

    public void assertContainerContainsSingle(BlockPos var0, Item var1) {
        BaseContainerBlockEntity var2 = this.getBlockEntity(var0, BaseContainerBlockEntity.class);
        if (var2.countItem(var1) != 1) {
            throw this.assertionException(var0, "test.error.expected_container_contents_single", var1.getName());
        }
    }

    public void assertContainerContains(BlockPos var0, Item var1) {
        BaseContainerBlockEntity var2 = this.getBlockEntity(var0, BaseContainerBlockEntity.class);
        if (var2.countItem(var1) == 0) {
            throw this.assertionException(var0, "test.error.expected_container_contents", var1.getName());
        }
    }

    public void assertSameBlockStates(BoundingBox var0, BlockPos var1) {
        BlockPos.betweenClosedStream(var0).forEach(var2 -> {
            BlockPos var3 = var1.offset(var2.getX() - var0.minX(), var2.getY() - var0.minY(), var2.getZ() - var0.minZ());
            this.assertSameBlockState((BlockPos)var2, var3);
        });
    }

    public void assertSameBlockState(BlockPos var0, BlockPos var1) {
        BlockState var3;
        BlockState var2 = this.getBlockState(var0);
        if (var2 != (var3 = this.getBlockState(var1))) {
            throw this.assertionException(var0, "test.error.state_not_equal", var3, var2);
        }
    }

    public void assertAtTickTimeContainerContains(long var0, BlockPos var2, Item var3) {
        this.runAtTickTime(var0, () -> this.assertContainerContainsSingle(var2, var3));
    }

    public void assertAtTickTimeContainerEmpty(long var0, BlockPos var2) {
        this.runAtTickTime(var0, () -> this.assertContainerEmpty(var2));
    }

    public <E extends Entity, T> void succeedWhenEntityData(BlockPos var0, EntityType<E> var1, Function<E, T> var2, T var3) {
        this.succeedWhen(() -> this.assertEntityData(var0, var1, var2, var3));
    }

    public void assertEntityPosition(Entity var0, AABB var1, Component var2) {
        if (!var1.contains(this.relativeVec(var0.position()))) {
            throw this.assertionException(var2);
        }
    }

    public <E extends Entity> void assertEntityProperty(E var0, Predicate<E> var1, Component var2) {
        if (!var1.test(var0)) {
            throw this.assertionException(var0.blockPosition(), "test.error.entity_property", var0.getName(), var2);
        }
    }

    public <E extends Entity, T> void assertEntityProperty(E var0, Function<E, T> var1, T var2, Component var3) {
        T var4 = var1.apply(var0);
        if (!var4.equals(var2)) {
            throw this.assertionException(var0.blockPosition(), "test.error.entity_property_details", var0.getName(), var3, var4, var2);
        }
    }

    public void assertLivingEntityHasMobEffect(LivingEntity var0, Holder<MobEffect> var1, int var2) {
        MobEffectInstance var3 = var0.getEffect(var1);
        if (var3 == null || var3.getAmplifier() != var2) {
            throw this.assertionException("test.error.expected_entity_effect", var0.getName(), PotionContents.getPotionDescription(var1, var2));
        }
    }

    public void succeedWhenEntityPresent(EntityType<?> var0, int var1, int var2, int var3) {
        this.succeedWhenEntityPresent(var0, new BlockPos(var1, var2, var3));
    }

    public void succeedWhenEntityPresent(EntityType<?> var0, BlockPos var1) {
        this.succeedWhen(() -> this.assertEntityPresent(var0, var1));
    }

    public void succeedWhenEntityNotPresent(EntityType<?> var0, int var1, int var2, int var3) {
        this.succeedWhenEntityNotPresent(var0, new BlockPos(var1, var2, var3));
    }

    public void succeedWhenEntityNotPresent(EntityType<?> var0, BlockPos var1) {
        this.succeedWhen(() -> this.assertEntityNotPresent(var0, var1));
    }

    public void succeed() {
        this.testInfo.succeed();
    }

    private void ensureSingleFinalCheck() {
        if (this.finalCheckAdded) {
            throw new IllegalStateException("This test already has final clause");
        }
        this.finalCheckAdded = true;
    }

    public void succeedIf(Runnable var0) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(0L, var0).thenSucceed();
    }

    public void succeedWhen(Runnable var0) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(var0).thenSucceed();
    }

    public void succeedOnTickWhen(int var0, Runnable var1) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(var0, var1).thenSucceed();
    }

    public void runAtTickTime(long var0, Runnable var2) {
        this.testInfo.setRunAtTickTime(var0, var2);
    }

    public void runAfterDelay(long var0, Runnable var2) {
        this.runAtTickTime((long)this.testInfo.getTick() + var0, var2);
    }

    public void randomTick(BlockPos var0) {
        BlockPos var1 = this.absolutePos(var0);
        ServerLevel var2 = this.getLevel();
        var2.getBlockState(var1).randomTick(var2, var1, var2.random);
    }

    public void tickBlock(BlockPos var0) {
        BlockPos var1 = this.absolutePos(var0);
        ServerLevel var2 = this.getLevel();
        var2.getBlockState(var1).tick(var2, var1, var2.random);
    }

    public void tickPrecipitation(BlockPos var0) {
        BlockPos var1 = this.absolutePos(var0);
        ServerLevel var2 = this.getLevel();
        var2.tickPrecipitation(var1);
    }

    public void tickPrecipitation() {
        AABB var0 = this.getRelativeBounds();
        int var1 = (int)Math.floor(var0.maxX);
        int var2 = (int)Math.floor(var0.maxZ);
        int var3 = (int)Math.floor(var0.maxY);
        for (int var4 = (int)Math.floor(var0.minX); var4 < var1; ++var4) {
            for (int var5 = (int)Math.floor(var0.minZ); var5 < var2; ++var5) {
                this.tickPrecipitation(new BlockPos(var4, var3, var5));
            }
        }
    }

    public int getHeight(Heightmap.Types var0, int var1, int var2) {
        BlockPos var3 = this.absolutePos(new BlockPos(var1, 0, var2));
        return this.relativePos(this.getLevel().getHeightmapPos(var0, var3)).getY();
    }

    public void fail(Component var0, BlockPos var1) {
        throw this.assertionException(var1, var0);
    }

    public void fail(Component var0, Entity var1) {
        throw this.assertionException(var1.blockPosition(), var0);
    }

    public void fail(Component var0) {
        throw this.assertionException(var0);
    }

    public void fail(String var0) {
        throw this.assertionException(Component.literal(var0));
    }

    public void failIf(Runnable var0) {
        this.testInfo.createSequence().thenWaitUntil(var0).thenFail(() -> this.assertionException("test.error.fail", new Object[0]));
    }

    public void failIfEver(Runnable var0) {
        LongStream.range(this.testInfo.getTick(), this.testInfo.getTimeoutTicks()).forEach(var1 -> this.testInfo.setRunAtTickTime(var1, var0::run));
    }

    public GameTestSequence startSequence() {
        return this.testInfo.createSequence();
    }

    public BlockPos absolutePos(BlockPos var0) {
        BlockPos var1 = this.testInfo.getTestOrigin();
        BlockPos var2 = var1.offset(var0);
        return StructureTemplate.transform(var2, Mirror.NONE, this.testInfo.getRotation(), var1);
    }

    public BlockPos relativePos(BlockPos var0) {
        BlockPos var1 = this.testInfo.getTestOrigin();
        Rotation var2 = this.testInfo.getRotation().getRotated(Rotation.CLOCKWISE_180);
        BlockPos var3 = StructureTemplate.transform(var0, Mirror.NONE, var2, var1);
        return var3.subtract(var1);
    }

    public AABB absoluteAABB(AABB var0) {
        Vec3 var1 = this.absoluteVec(var0.getMinPosition());
        Vec3 var2 = this.absoluteVec(var0.getMaxPosition());
        return new AABB(var1, var2);
    }

    public AABB relativeAABB(AABB var0) {
        Vec3 var1 = this.relativeVec(var0.getMinPosition());
        Vec3 var2 = this.relativeVec(var0.getMaxPosition());
        return new AABB(var1, var2);
    }

    public Vec3 absoluteVec(Vec3 var0) {
        Vec3 var1 = Vec3.atLowerCornerOf(this.testInfo.getTestOrigin());
        return StructureTemplate.transform(var1.add(var0), Mirror.NONE, this.testInfo.getRotation(), this.testInfo.getTestOrigin());
    }

    public Vec3 relativeVec(Vec3 var0) {
        Vec3 var1 = Vec3.atLowerCornerOf(this.testInfo.getTestOrigin());
        return StructureTemplate.transform(var0.subtract(var1), Mirror.NONE, this.testInfo.getRotation(), this.testInfo.getTestOrigin());
    }

    public Rotation getTestRotation() {
        return this.testInfo.getRotation();
    }

    public Direction getTestDirection() {
        return this.testInfo.getRotation().rotate(Direction.SOUTH);
    }

    public void assertTrue(boolean var0, Component var1) {
        if (!var0) {
            throw this.assertionException(var1);
        }
    }

    public <N> void assertValueEqual(N var0, N var1, Component var2) {
        if (!var0.equals(var1)) {
            throw this.assertionException("test.error.value_not_equal", var2, var0, var1);
        }
    }

    public void assertFalse(boolean var0, Component var1) {
        this.assertTrue(!var0, var1);
    }

    public long getTick() {
        return this.testInfo.getTick();
    }

    public AABB getBounds() {
        return this.testInfo.getStructureBounds();
    }

    private AABB getRelativeBounds() {
        AABB var0 = this.testInfo.getStructureBounds();
        Rotation var1 = this.testInfo.getRotation();
        switch (var1) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new AABB(0.0, 0.0, 0.0, var0.getZsize(), var0.getYsize(), var0.getXsize());
            }
        }
        return new AABB(0.0, 0.0, 0.0, var0.getXsize(), var0.getYsize(), var0.getZsize());
    }

    public void forEveryBlockInStructure(Consumer<BlockPos> var0) {
        AABB var1 = this.getRelativeBounds().contract(1.0, 1.0, 1.0);
        BlockPos.MutableBlockPos.betweenClosedStream(var1).forEach(var0);
    }

    public void onEachTick(Runnable var0) {
        LongStream.range(this.testInfo.getTick(), this.testInfo.getTimeoutTicks()).forEach(var1 -> this.testInfo.setRunAtTickTime(var1, var0::run));
    }

    public void placeAt(Player var0, ItemStack var1, BlockPos var2, Direction var3) {
        BlockPos var4 = this.absolutePos(var2.relative(var3));
        BlockHitResult var5 = new BlockHitResult(Vec3.atCenterOf(var4), var3, var4, false);
        UseOnContext var6 = new UseOnContext(var0, InteractionHand.MAIN_HAND, var5);
        var1.useOn(var6);
    }

    public void setBiome(ResourceKey<Biome> var0) {
        AABB var1 = this.getBounds();
        BlockPos var2 = BlockPos.containing(var1.minX, var1.minY, var1.minZ);
        BlockPos var3 = BlockPos.containing(var1.maxX, var1.maxY, var1.maxZ);
        Either<Integer, CommandSyntaxException> var4 = FillBiomeCommand.fill(this.getLevel(), var2, var3, this.getLevel().registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(var0));
        if (var4.right().isPresent()) {
            throw this.assertionException("test.error.set_biome", new Object[0]);
        }
    }
}

