/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceSelectorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFinder;
import net.minecraft.gametest.framework.TestInstanceFinder;
import net.minecraft.gametest.framework.TestPosFinder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundGameTestHighlightPosPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.mutable.MutableInt;

public class TestCommand {
    public static final int TEST_NEARBY_SEARCH_RADIUS = 15;
    public static final int TEST_FULL_SEARCH_RADIUS = 250;
    public static final int VERIFY_TEST_GRID_AXIS_SIZE = 10;
    public static final int VERIFY_TEST_BATCH_SIZE = 100;
    private static final int DEFAULT_CLEAR_RADIUS = 250;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;
    private static final SimpleCommandExceptionType CLEAR_NO_TESTS = new SimpleCommandExceptionType((Message)Component.translatable("commands.test.clear.error.no_tests"));
    private static final SimpleCommandExceptionType RESET_NO_TESTS = new SimpleCommandExceptionType((Message)Component.translatable("commands.test.reset.error.no_tests"));
    private static final SimpleCommandExceptionType TEST_INSTANCE_COULD_NOT_BE_FOUND = new SimpleCommandExceptionType((Message)Component.translatable("commands.test.error.test_instance_not_found"));
    private static final SimpleCommandExceptionType NO_STRUCTURES_TO_EXPORT = new SimpleCommandExceptionType((Message)Component.literal("Could not find any structures to export"));
    private static final SimpleCommandExceptionType NO_TEST_INSTANCES = new SimpleCommandExceptionType((Message)Component.translatable("commands.test.error.no_test_instances"));
    private static final Dynamic3CommandExceptionType NO_TEST_CONTAINING = new Dynamic3CommandExceptionType((var0, var1, var2) -> Component.translatableEscape("commands.test.error.no_test_containing_pos", var0, var1, var2));
    private static final DynamicCommandExceptionType TOO_LARGE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.test.error.too_large", var0));

    private static int reset(TestFinder var0) throws CommandSyntaxException {
        TestCommand.stopTests();
        int var12 = TestCommand.toGameTestInfos(var0.source(), RetryOptions.noRetries(), var0).map(var1 -> TestCommand.resetGameTestInfo(var0.source(), var1)).toList().size();
        if (var12 == 0) {
            throw CLEAR_NO_TESTS.create();
        }
        var0.source().sendSuccess(() -> Component.translatable("commands.test.reset.success", var12), true);
        return var12;
    }

    private static int clear(TestFinder var0) throws CommandSyntaxException {
        TestCommand.stopTests();
        CommandSourceStack var12 = var0.source();
        ServerLevel var2 = var12.getLevel();
        List var3 = var0.findTestPos().flatMap(var1 -> var2.getBlockEntity((BlockPos)var1, BlockEntityType.TEST_INSTANCE_BLOCK).stream()).toList();
        for (TestInstanceBlockEntity var5 : var3) {
            StructureUtils.clearSpaceForStructure(var5.getStructureBoundingBox(), var2);
            var5.removeBarriers();
            var2.destroyBlock(var5.getBlockPos(), false);
        }
        if (var3.isEmpty()) {
            throw CLEAR_NO_TESTS.create();
        }
        var12.sendSuccess(() -> Component.translatable("commands.test.clear.success", var3.size()), true);
        return var3.size();
    }

    private static int export(TestFinder var0) throws CommandSyntaxException {
        CommandSourceStack var1 = var0.source();
        ServerLevel var2 = var1.getLevel();
        int var3 = 0;
        boolean var4 = true;
        Object var5 = var0.findTestPos().iterator();
        while (var5.hasNext()) {
            BlockPos var6 = (BlockPos)var5.next();
            BlockEntity blockEntity = var2.getBlockEntity(var6);
            if (blockEntity instanceof TestInstanceBlockEntity) {
                TestInstanceBlockEntity var7 = (TestInstanceBlockEntity)blockEntity;
                if (!var7.exportTest(var1::sendSystemMessage)) {
                    var4 = false;
                }
                ++var3;
                continue;
            }
            throw TEST_INSTANCE_COULD_NOT_BE_FOUND.create();
        }
        if (var3 == 0) {
            throw NO_STRUCTURES_TO_EXPORT.create();
        }
        var5 = "Exported " + var3 + " structures";
        var0.source().sendSuccess(() -> TestCommand.lambda$export$6((String)var5), true);
        return var4 ? 0 : 1;
    }

    private static int verify(TestFinder var0) {
        TestCommand.stopTests();
        CommandSourceStack var1 = var0.source();
        ServerLevel var2 = var1.getLevel();
        BlockPos var3 = TestCommand.createTestPositionAround(var1);
        List<GameTestInfo> var4 = Stream.concat(TestCommand.toGameTestInfos(var1, RetryOptions.noRetries(), var0), TestCommand.toGameTestInfo(var1, RetryOptions.noRetries(), var0, 0)).toList();
        FailedTestTracker.forgetFailedTests();
        ArrayList<GameTestBatch> var5 = new ArrayList<GameTestBatch>();
        for (GameTestInfo gameTestInfo : var4) {
            for (Rotation var11 : Rotation.values()) {
                ArrayList<GameTestInfo> var12 = new ArrayList<GameTestInfo>();
                for (int var13 = 0; var13 < 100; ++var13) {
                    GameTestInfo var14 = new GameTestInfo(gameTestInfo.getTestHolder(), var11, var2, new RetryOptions(1, true));
                    var14.setTestBlockPos(gameTestInfo.getTestBlockPos());
                    var12.add(var14);
                }
                GameTestBatch var13 = GameTestBatchFactory.toGameTestBatch(var12, gameTestInfo.getTest().batch(), var11.ordinal());
                var5.add(var13);
            }
        }
        StructureGridSpawner var6 = new StructureGridSpawner(var3, 10, true);
        GameTestRunner gameTestRunner = GameTestRunner.Builder.fromBatches(var5, var2).batcher(GameTestBatchFactory.fromGameTestInfo(100)).newStructureSpawner(var6).existingStructureSpawner(var6).haltOnError().clearBetweenBatches().build();
        return TestCommand.trackAndStartRunner(var1, gameTestRunner);
    }

    private static int run(TestFinder var0, RetryOptions var1, int var2, int var3) {
        TestCommand.stopTests();
        CommandSourceStack var4 = var0.source();
        ServerLevel var5 = var4.getLevel();
        BlockPos var6 = TestCommand.createTestPositionAround(var4);
        List<GameTestInfo> var7 = Stream.concat(TestCommand.toGameTestInfos(var4, var1, var0), TestCommand.toGameTestInfo(var4, var1, var0, var2)).toList();
        if (var7.isEmpty()) {
            var4.sendSuccess(() -> Component.translatable("commands.test.no_tests"), false);
            return 0;
        }
        FailedTestTracker.forgetFailedTests();
        var4.sendSuccess(() -> Component.translatable("commands.test.run.running", var7.size()), false);
        GameTestRunner var8 = GameTestRunner.Builder.fromInfo(var7, var5).newStructureSpawner(new StructureGridSpawner(var6, var3, false)).build();
        return TestCommand.trackAndStartRunner(var4, var8);
    }

    private static int locate(TestFinder var0) throws CommandSyntaxException {
        var0.source().sendSystemMessage(Component.translatable("commands.test.locate.started"));
        MutableInt var1 = new MutableInt(0);
        BlockPos var2 = BlockPos.containing(var0.source().getPosition());
        var0.findTestPos().forEach(var3 -> {
            Object var5 = var0.source().getLevel().getBlockEntity((BlockPos)var3);
            if (!(var5 instanceof TestInstanceBlockEntity)) {
                return;
            }
            TestInstanceBlockEntity var4 = (TestInstanceBlockEntity)var5;
            var5 = var4.getRotation().rotate(Direction.NORTH);
            BlockPos var6 = var4.getBlockPos().relative((Direction)var5, 2);
            int var7 = (int)((Direction)var5).getOpposite().toYRot();
            String var8 = String.format(Locale.ROOT, "/tp @s %d %d %d %d 0", var6.getX(), var6.getY(), var6.getZ(), var7);
            int var9 = var2.getX() - var3.getX();
            int var10 = var2.getZ() - var3.getZ();
            int var11 = Mth.floor(Mth.sqrt(var9 * var9 + var10 * var10));
            MutableComponent var122 = ComponentUtils.wrapInSquareBrackets(Component.translatable("chat.coordinates", var3.getX(), var3.getY(), var3.getZ())).withStyle(var1 -> var1.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent.SuggestCommand(var8)).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.coordinates.tooltip"))));
            var0.source().sendSuccess(() -> Component.translatable("commands.test.locate.found", var122, var11), false);
            var1.increment();
        });
        int var32 = var1.intValue();
        if (var32 == 0) {
            throw NO_TEST_INSTANCES.create();
        }
        var0.source().sendSuccess(() -> Component.translatable("commands.test.locate.done", var32), true);
        return var32;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> var0, InCommandFunction<CommandContext<CommandSourceStack>, TestFinder> var12, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> var2) {
        return var0.executes(var1 -> TestCommand.run((TestFinder)var12.apply(var1), RetryOptions.noRetries(), 0, 8)).then(((RequiredArgumentBuilder)Commands.argument("numberOfTimes", IntegerArgumentType.integer((int)0)).executes(var1 -> TestCommand.run((TestFinder)var12.apply(var1), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), false), 0, 8))).then(var2.apply(Commands.argument("untilFailed", BoolArgumentType.bool()).executes(var1 -> TestCommand.run((TestFinder)var12.apply(var1), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")), 0, 8)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> var02, InCommandFunction<CommandContext<CommandSourceStack>, TestFinder> var1) {
        return TestCommand.runWithRetryOptions(var02, var1, var0 -> var0);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptionsAndBuildInfo(ArgumentBuilder<CommandSourceStack, ?> var0, InCommandFunction<CommandContext<CommandSourceStack>, TestFinder> var1) {
        return TestCommand.runWithRetryOptions(var0, var1, var12 -> var12.then(((RequiredArgumentBuilder)Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes(var1 -> TestCommand.run((TestFinder)var1.apply(var1), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)var1, (String)"rotationSteps"), 8))).then(Commands.argument("testsPerRow", IntegerArgumentType.integer()).executes(var1 -> TestCommand.run((TestFinder)var1.apply(var1), new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)var1, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)var1, (String)"testsPerRow"))))));
    }

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        ArgumentBuilder<CommandSourceStack, ?> var2 = TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("onlyRequiredTests", BoolArgumentType.bool()), var0 -> TestFinder.builder().failedTests((CommandContext<CommandSourceStack>)var0, BoolArgumentType.getBool((CommandContext)var0, (String)"onlyRequiredTests")));
        LiteralArgumentBuilder var3 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("test").requires(Commands.hasPermission(2))).then(Commands.literal("run").then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("tests", ResourceSelectorArgument.resourceSelector(var1, Registries.TEST_INSTANCE)), var0 -> TestFinder.builder().byResourceSelection((CommandContext<CommandSourceStack>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)var0, "tests")))))).then(Commands.literal("runmultiple").then(((RequiredArgumentBuilder)Commands.argument("tests", ResourceSelectorArgument.resourceSelector(var1, Registries.TEST_INSTANCE)).executes(var0 -> TestCommand.run(TestFinder.builder().byResourceSelection((CommandContext<CommandSourceStack>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)var0, "tests")), RetryOptions.noRetries(), 0, 8))).then(Commands.argument("amount", IntegerArgumentType.integer()).executes(var0 -> TestCommand.run(TestFinder.builder().createMultipleCopies(IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount")).byResourceSelection((CommandContext<CommandSourceStack>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)var0, "tests")), RetryOptions.noRetries(), 0, 8)))))).then(TestCommand.runWithRetryOptions(Commands.literal("runthese"), TestFinder.builder()::allNearby))).then(TestCommand.runWithRetryOptions(Commands.literal("runclosest"), TestFinder.builder()::nearest))).then(TestCommand.runWithRetryOptions(Commands.literal("runthat"), TestFinder.builder()::lookedAt))).then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.literal("runfailed").then(var2), TestFinder.builder()::failedTests))).then(Commands.literal("verify").then(Commands.argument("tests", ResourceSelectorArgument.resourceSelector(var1, Registries.TEST_INSTANCE)).executes(var0 -> TestCommand.verify(TestFinder.builder().byResourceSelection((CommandContext<CommandSourceStack>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)var0, "tests"))))))).then(Commands.literal("locate").then(Commands.argument("tests", ResourceSelectorArgument.resourceSelector(var1, Registries.TEST_INSTANCE)).executes(var0 -> TestCommand.locate(TestFinder.builder().byResourceSelection((CommandContext<CommandSourceStack>)var0, ResourceSelectorArgument.getSelectedResources((CommandContext<CommandSourceStack>)var0, "tests"))))))).then(Commands.literal("resetclosest").executes(var0 -> TestCommand.reset(TestFinder.builder().nearest((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("resetthese").executes(var0 -> TestCommand.reset(TestFinder.builder().allNearby((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("resetthat").executes(var0 -> TestCommand.reset(TestFinder.builder().lookedAt((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("clearthat").executes(var0 -> TestCommand.clear(TestFinder.builder().lookedAt((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("clearthese").executes(var0 -> TestCommand.clear(TestFinder.builder().allNearby((CommandContext<CommandSourceStack>)var0))))).then(((LiteralArgumentBuilder)Commands.literal("clearall").executes(var0 -> TestCommand.clear(TestFinder.builder().radius((CommandContext<CommandSourceStack>)var0, 250)))).then(Commands.argument("radius", IntegerArgumentType.integer()).executes(var0 -> TestCommand.clear(TestFinder.builder().radius((CommandContext<CommandSourceStack>)var0, Mth.clamp(IntegerArgumentType.getInteger((CommandContext)var0, (String)"radius"), 0, 1024))))))).then(Commands.literal("stop").executes(var0 -> TestCommand.stopTests()))).then(((LiteralArgumentBuilder)Commands.literal("pos").executes(var0 -> TestCommand.showPos((CommandSourceStack)var0.getSource(), "pos"))).then(Commands.argument("var", StringArgumentType.word()).executes(var0 -> TestCommand.showPos((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"var")))))).then(Commands.literal("create").then(((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(TestCommand::suggestTestFunction).executes(var0 -> TestCommand.createNewStructure((CommandSourceStack)var0.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), 5, 5, 5))).then(((RequiredArgumentBuilder)Commands.argument("width", IntegerArgumentType.integer()).executes(var0 -> TestCommand.createNewStructure((CommandSourceStack)var0.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width")))).then(Commands.argument("height", IntegerArgumentType.integer()).then(Commands.argument("depth", IntegerArgumentType.integer()).executes(var0 -> TestCommand.createNewStructure((CommandSourceStack)var0.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"height"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"depth"))))))));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            var3 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var3.then(Commands.literal("export").then(Commands.argument("test", ResourceArgument.resource(var1, Registries.TEST_INSTANCE)).executes(var0 -> TestCommand.exportTestStructure((CommandSourceStack)var0.getSource(), ResourceArgument.getResource((CommandContext<CommandSourceStack>)var0, "test", Registries.TEST_INSTANCE)))))).then(Commands.literal("exportclosest").executes(var0 -> TestCommand.export(TestFinder.builder().nearest((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("exportthese").executes(var0 -> TestCommand.export(TestFinder.builder().allNearby((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("exportthat").executes(var0 -> TestCommand.export(TestFinder.builder().lookedAt((CommandContext<CommandSourceStack>)var0))));
        }
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)var3);
    }

    public static CompletableFuture<Suggestions> suggestTestFunction(CommandContext<CommandSourceStack> var0, SuggestionsBuilder var1) {
        Stream<String> var2 = ((CommandSourceStack)var0.getSource()).registryAccess().lookupOrThrow(Registries.TEST_FUNCTION).listElements().map(Holder::getRegisteredName);
        return SharedSuggestionProvider.suggest(var2, var1);
    }

    private static int resetGameTestInfo(CommandSourceStack var0, GameTestInfo var1) {
        TestInstanceBlockEntity var2 = var1.getTestInstanceBlockEntity();
        var2.resetTest(var0::sendSystemMessage);
        return 1;
    }

    private static Stream<GameTestInfo> toGameTestInfos(CommandSourceStack var0, RetryOptions var1, TestPosFinder var22) {
        return var22.findTestPos().map(var2 -> TestCommand.createGameTestInfo(var2, var0, var1)).flatMap(Optional::stream);
    }

    private static Stream<GameTestInfo> toGameTestInfo(CommandSourceStack var0, RetryOptions var12, TestInstanceFinder var2, int var32) {
        return var2.findTests().filter(var1 -> TestCommand.verifyStructureExists(var0, ((GameTestInstance)var1.value()).structure())).map(var3 -> new GameTestInfo((Holder.Reference<GameTestInstance>)var3, StructureUtils.getRotationForRotationSteps(var32), var0.getLevel(), var12));
    }

    private static Optional<GameTestInfo> createGameTestInfo(BlockPos var0, CommandSourceStack var1, RetryOptions var2) {
        ServerLevel var3 = var1.getLevel();
        BlockEntity blockEntity = var3.getBlockEntity(var0);
        if (!(blockEntity instanceof TestInstanceBlockEntity)) {
            var1.sendFailure(Component.translatable("commands.test.error.test_instance_not_found.position", var0.getX(), var0.getY(), var0.getZ()));
            return Optional.empty();
        }
        TestInstanceBlockEntity var4 = (TestInstanceBlockEntity)blockEntity;
        Optional var5 = var4.test().flatMap(((Registry)var1.registryAccess().lookupOrThrow(Registries.TEST_INSTANCE))::get);
        if (var5.isEmpty()) {
            var1.sendFailure(Component.translatable("commands.test.error.non_existant_test", var4.getTestName()));
            return Optional.empty();
        }
        Holder.Reference var6 = (Holder.Reference)var5.get();
        GameTestInfo var7 = new GameTestInfo(var6, var4.getRotation(), var3, var2);
        var7.setTestBlockPos(var0);
        if (!TestCommand.verifyStructureExists(var1, var7.getStructure())) {
            return Optional.empty();
        }
        return Optional.of(var7);
    }

    private static int createNewStructure(CommandSourceStack var0, ResourceLocation var12, int var2, int var3, int var4) throws CommandSyntaxException {
        if (var2 > 48 || var3 > 48 || var4 > 48) {
            throw TOO_LARGE.create((Object)48);
        }
        ServerLevel var5 = var0.getLevel();
        BlockPos var6 = TestCommand.createTestPositionAround(var0);
        TestInstanceBlockEntity var7 = StructureUtils.createNewEmptyTest(var12, var6, new Vec3i(var2, var3, var4), Rotation.NONE, var5);
        BlockPos var8 = var7.getStructurePos();
        BlockPos var9 = var8.offset(var2 - 1, 0, var4 - 1);
        BlockPos.betweenClosedStream(var8, var9).forEach(var1 -> var5.setBlockAndUpdate((BlockPos)var1, Blocks.BEDROCK.defaultBlockState()));
        var0.sendSuccess(() -> Component.translatable("commands.test.create.success", var7.getTestName()), true);
        return 1;
    }

    private static int showPos(CommandSourceStack var0, String var1) throws CommandSyntaxException {
        ServerLevel var5;
        ServerPlayer var2 = var0.getPlayerOrException();
        BlockHitResult var3 = (BlockHitResult)var2.pick(10.0, 1.0f, false);
        BlockPos var4 = var3.getBlockPos();
        Optional<BlockPos> var6 = StructureUtils.findTestContainingPos(var4, 15, var5 = var0.getLevel());
        if (var6.isEmpty()) {
            var6 = StructureUtils.findTestContainingPos(var4, 250, var5);
        }
        if (var6.isEmpty()) {
            throw NO_TEST_CONTAINING.create((Object)var4.getX(), (Object)var4.getY(), (Object)var4.getZ());
        }
        BlockEntity blockEntity = var5.getBlockEntity(var6.get());
        if (!(blockEntity instanceof TestInstanceBlockEntity)) {
            throw TEST_INSTANCE_COULD_NOT_BE_FOUND.create();
        }
        TestInstanceBlockEntity var7 = (TestInstanceBlockEntity)blockEntity;
        BlockPos var8 = var7.getStructurePos();
        BlockPos var9 = var4.subtract(var8);
        String var10 = var9.getX() + ", " + var9.getY() + ", " + var9.getZ();
        String var11 = var7.getTestName().getString();
        MutableComponent var12 = Component.translatable("commands.test.coordinates", var9.getX(), var9.getY(), var9.getZ()).setStyle(Style.EMPTY.withBold(true).withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent.ShowText(Component.translatable("commands.test.coordinates.copy"))).withClickEvent(new ClickEvent.CopyToClipboard("final BlockPos " + var1 + " = new BlockPos(" + var10 + ");")));
        var0.sendSuccess(() -> Component.translatable("commands.test.relative_position", var11, var12), false);
        var2.connection.send(new ClientboundGameTestHighlightPosPacket(var4, var9));
        return 1;
    }

    private static int stopTests() {
        GameTestTicker.SINGLETON.clear();
        return 1;
    }

    public static int trackAndStartRunner(CommandSourceStack var02, GameTestRunner var1) {
        var1.addListener(new TestBatchSummaryDisplayer(var02));
        MultipleTestTracker var2 = new MultipleTestTracker(var1.getTestInfos());
        var2.addListener(new TestSummaryDisplayer(var02, var2));
        var2.addFailureListener(var0 -> FailedTestTracker.rememberFailedTest(var0.getTestHolder()));
        var1.start();
        return 1;
    }

    private static int exportTestStructure(CommandSourceStack var0, Holder<GameTestInstance> var1) {
        if (!TestInstanceBlockEntity.export(var0.getLevel(), var1.value().structure(), var0::sendSystemMessage)) {
            return 0;
        }
        return 1;
    }

    private static boolean verifyStructureExists(CommandSourceStack var0, ResourceLocation var1) {
        if (var0.getLevel().getStructureManager().get(var1).isEmpty()) {
            var0.sendFailure(Component.translatable("commands.test.error.structure_not_found", Component.translationArg(var1)));
            return false;
        }
        return true;
    }

    private static BlockPos createTestPositionAround(CommandSourceStack var0) {
        BlockPos var1 = BlockPos.containing(var0.getPosition());
        int var2 = var0.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, var1).getY();
        return new BlockPos(var1.getX(), var2, var1.getZ() + 3);
    }

    private static /* synthetic */ Component lambda$export$6(String var0) {
        return Component.literal(var0);
    }

    record TestBatchSummaryDisplayer(CommandSourceStack source) implements GameTestBatchListener
    {
        @Override
        public void testBatchStarting(GameTestBatch var0) {
            this.source.sendSuccess(() -> Component.translatable("commands.test.batch.starting", var0.environment().getRegisteredName(), var0.index()), true);
        }

        @Override
        public void testBatchFinished(GameTestBatch var0) {
        }
    }

    public record TestSummaryDisplayer(CommandSourceStack source, MultipleTestTracker tracker) implements GameTestListener
    {
        @Override
        public void testStructureLoaded(GameTestInfo var0) {
        }

        @Override
        public void testPassed(GameTestInfo var0, GameTestRunner var1) {
            this.showTestSummaryIfAllDone();
        }

        @Override
        public void testFailed(GameTestInfo var0, GameTestRunner var1) {
            this.showTestSummaryIfAllDone();
        }

        @Override
        public void testAddedForRerun(GameTestInfo var0, GameTestInfo var1, GameTestRunner var2) {
            this.tracker.addTestToTrack(var1);
        }

        private void showTestSummaryIfAllDone() {
            if (this.tracker.isDone()) {
                this.source.sendSuccess(() -> Component.translatable("commands.test.summary", this.tracker.getTotalCount()).withStyle(ChatFormatting.WHITE), true);
                if (this.tracker.hasFailedRequired()) {
                    this.source.sendFailure(Component.translatable("commands.test.summary.failed", this.tracker.getFailedRequiredCount()));
                } else {
                    this.source.sendSuccess(() -> Component.translatable("commands.test.summary.all_required_passed").withStyle(ChatFormatting.GREEN), true);
                }
                if (this.tracker.hasFailedOptional()) {
                    this.source.sendSystemMessage(Component.translatable("commands.test.summary.optional_failed", this.tracker.getFailedOptionalCount()));
                }
            }
        }
    }
}

