/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.locale.DeprecatedTranslationsInfo;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringDecomposer;
import org.slf4j.Logger;

public abstract class Language {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final Pattern UNSUPPORTED_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    public static final String DEFAULT = "en_us";
    private static volatile Language instance = Language.loadDefault();

    private static Language loadDefault() {
        DeprecatedTranslationsInfo var0 = DeprecatedTranslationsInfo.loadFromDefaultResource();
        HashMap<String, String> var1 = new HashMap<String, String>();
        BiConsumer<String, String> var2 = var1::put;
        Language.parseTranslations(var2, "/assets/minecraft/lang/en_us.json");
        var0.applyToMap(var1);
        final Map<String, String> var3 = Map.copyOf(var1);
        return new Language(){

            @Override
            public String getOrDefault(String var0, String var1) {
                return var3.getOrDefault(var0, var1);
            }

            @Override
            public boolean has(String var0) {
                return var3.containsKey(var0);
            }

            @Override
            public boolean isDefaultRightToLeft() {
                return false;
            }

            @Override
            public FormattedCharSequence getVisualOrder(FormattedText var0) {
                return var12 -> var0.visit((var1, var2) -> StringDecomposer.iterateFormatted(var2, var1, var12) ? Optional.empty() : FormattedText.STOP_ITERATION, Style.EMPTY).isPresent();
            }
        };
    }

    private static void parseTranslations(BiConsumer<String, String> var0, String var1) {
        try (InputStream var2 = Language.class.getResourceAsStream(var1);){
            Language.loadFromJson(var2, var0);
        }
        catch (JsonParseException | IOException var22) {
            LOGGER.error("Couldn't read strings from {}", (Object)var1, (Object)var22);
        }
    }

    public static void loadFromJson(InputStream var0, BiConsumer<String, String> var1) {
        JsonObject var2 = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(var0, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry var4 : var2.entrySet()) {
            String var5 = UNSUPPORTED_FORMAT_PATTERN.matcher(GsonHelper.convertToString((JsonElement)var4.getValue(), (String)var4.getKey())).replaceAll("%$1s");
            var1.accept((String)var4.getKey(), var5);
        }
    }

    public static Language getInstance() {
        return instance;
    }

    public static void inject(Language var0) {
        instance = var0;
    }

    public String getOrDefault(String var0) {
        return this.getOrDefault(var0, var0);
    }

    public abstract String getOrDefault(String var1, String var2);

    public abstract boolean has(String var1);

    public abstract boolean isDefaultRightToLeft();

    public abstract FormattedCharSequence getVisualOrder(FormattedText var1);

    public List<FormattedCharSequence> getVisualOrder(List<FormattedText> var0) {
        return (List)var0.stream().map(this::getVisualOrder).collect(ImmutableList.toImmutableList());
    }
}

