/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;
import org.slf4j.Logger;

public final class CompoundTag
implements Tag {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<CompoundTag> CODEC = Codec.PASSTHROUGH.comapFlatMap(var0 -> {
        Tag var1 = (Tag)var0.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        if (var1 instanceof CompoundTag) {
            CompoundTag var2 = (CompoundTag)var1;
            return DataResult.success((Object)(var2 == var0.getValue() ? var2.copy() : var2));
        }
        return DataResult.error(() -> "Not a compound tag: " + String.valueOf(var1));
    }, var0 -> new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)var0.copy()));
    private static final int SELF_SIZE_IN_BYTES = 48;
    private static final int MAP_ENTRY_SIZE_IN_BYTES = 32;
    public static final TagType<CompoundTag> TYPE = new TagType.VariableSize<CompoundTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompoundTag load(DataInput var0, NbtAccounter var1) throws IOException {
            var1.pushDepth();
            try {
                CompoundTag compoundTag = 1.loadCompound(var0, var1);
                return compoundTag;
            }
            finally {
                var1.popDepth();
            }
        }

        private static CompoundTag loadCompound(DataInput var0, NbtAccounter var1) throws IOException {
            byte var3;
            var1.accountBytes(48L);
            HashMap var2 = Maps.newHashMap();
            while ((var3 = var0.readByte()) != 0) {
                Tag var5;
                String var4 = 1.readString(var0, var1);
                if (var2.put(var4, var5 = CompoundTag.readNamedTagData(TagTypes.getType(var3), var4, var0, var1)) != null) continue;
                var1.accountBytes(36L);
            }
            return new CompoundTag(var2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput var0, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
            var2.pushDepth();
            try {
                StreamTagVisitor.ValueResult valueResult = 1.parseCompound(var0, var1, var2);
                return valueResult;
            }
            finally {
                var2.popDepth();
            }
        }

        private static StreamTagVisitor.ValueResult parseCompound(DataInput var0, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
            byte var3;
            var2.accountBytes(48L);
            block13: while ((var3 = var0.readByte()) != 0) {
                TagType<?> var4 = TagTypes.getType(var3);
                switch (var1.visitEntry(var4)) {
                    case HALT: {
                        return StreamTagVisitor.ValueResult.HALT;
                    }
                    case BREAK: {
                        StringTag.skipString(var0);
                        var4.skip(var0, var2);
                        break block13;
                    }
                    case SKIP: {
                        StringTag.skipString(var0);
                        var4.skip(var0, var2);
                        continue block13;
                    }
                    default: {
                        String var5 = 1.readString(var0, var2);
                        switch (var1.visitEntry(var4, var5)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                var4.skip(var0, var2);
                                break block13;
                            }
                            case SKIP: {
                                var4.skip(var0, var2);
                                continue block13;
                            }
                        }
                        var2.accountBytes(36L);
                        switch (var4.parse(var0, var1, var2)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (var3 != 0) {
                while ((var3 = var0.readByte()) != 0) {
                    StringTag.skipString(var0);
                    TagTypes.getType(var3).skip(var0, var2);
                }
            }
            return var1.visitContainerEnd();
        }

        private static String readString(DataInput var0, NbtAccounter var1) throws IOException {
            String var2 = var0.readUTF();
            var1.accountBytes(28L);
            var1.accountBytes(2L, var2.length());
            return var2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput var0, NbtAccounter var1) throws IOException {
            var1.pushDepth();
            try {
                byte var2;
                while ((var2 = var0.readByte()) != 0) {
                    StringTag.skipString(var0);
                    TagTypes.getType(var2).skip(var0, var1);
                }
            }
            finally {
                var1.popDepth();
            }
        }

        @Override
        public String getName() {
            return "COMPOUND";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Compound";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final Map<String, Tag> tags;

    CompoundTag(Map<String, Tag> var0) {
        this.tags = var0;
    }

    public CompoundTag() {
        this(new HashMap<String, Tag>());
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        for (String var2 : this.tags.keySet()) {
            Tag var3 = this.tags.get(var2);
            CompoundTag.writeNamedTag(var2, var3, var0);
        }
        var0.writeByte(0);
    }

    @Override
    public int sizeInBytes() {
        int var0 = 48;
        for (Map.Entry<String, Tag> var2 : this.tags.entrySet()) {
            var0 += 28 + 2 * var2.getKey().length();
            var0 += 36;
            var0 += var2.getValue().sizeInBytes();
        }
        return var0;
    }

    public Set<String> keySet() {
        return this.tags.keySet();
    }

    public Set<Map.Entry<String, Tag>> entrySet() {
        return this.tags.entrySet();
    }

    public Collection<Tag> values() {
        return this.tags.values();
    }

    public void forEach(BiConsumer<String, Tag> var0) {
        this.tags.forEach(var0);
    }

    @Override
    public byte getId() {
        return 10;
    }

    public TagType<CompoundTag> getType() {
        return TYPE;
    }

    public int size() {
        return this.tags.size();
    }

    @Nullable
    public Tag put(String var0, Tag var1) {
        return this.tags.put(var0, var1);
    }

    public void putByte(String var0, byte var1) {
        this.tags.put(var0, ByteTag.valueOf(var1));
    }

    public void putShort(String var0, short var1) {
        this.tags.put(var0, ShortTag.valueOf(var1));
    }

    public void putInt(String var0, int var1) {
        this.tags.put(var0, IntTag.valueOf(var1));
    }

    public void putLong(String var0, long var1) {
        this.tags.put(var0, LongTag.valueOf(var1));
    }

    public void putFloat(String var0, float var1) {
        this.tags.put(var0, FloatTag.valueOf(var1));
    }

    public void putDouble(String var0, double var1) {
        this.tags.put(var0, DoubleTag.valueOf(var1));
    }

    public void putString(String var0, String var1) {
        this.tags.put(var0, StringTag.valueOf(var1));
    }

    public void putByteArray(String var0, byte[] var1) {
        this.tags.put(var0, new ByteArrayTag(var1));
    }

    public void putIntArray(String var0, int[] var1) {
        this.tags.put(var0, new IntArrayTag(var1));
    }

    public void putLongArray(String var0, long[] var1) {
        this.tags.put(var0, new LongArrayTag(var1));
    }

    public void putBoolean(String var0, boolean var1) {
        this.tags.put(var0, ByteTag.valueOf(var1));
    }

    @Nullable
    public Tag get(String var0) {
        return this.tags.get(var0);
    }

    public boolean contains(String var0) {
        return this.tags.containsKey(var0);
    }

    private Optional<Tag> getOptional(String var0) {
        return Optional.ofNullable(this.tags.get(var0));
    }

    public Optional<Byte> getByte(String var0) {
        return this.getOptional(var0).flatMap(Tag::asByte);
    }

    public byte getByteOr(String var0, byte var1) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof NumericTag) {
            NumericTag var2 = (NumericTag)tag;
            return var2.byteValue();
        }
        return var1;
    }

    public Optional<Short> getShort(String var0) {
        return this.getOptional(var0).flatMap(Tag::asShort);
    }

    public short getShortOr(String var0, short var1) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof NumericTag) {
            NumericTag var2 = (NumericTag)tag;
            return var2.shortValue();
        }
        return var1;
    }

    public Optional<Integer> getInt(String var0) {
        return this.getOptional(var0).flatMap(Tag::asInt);
    }

    public int getIntOr(String var0, int var1) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof NumericTag) {
            NumericTag var2 = (NumericTag)tag;
            return var2.intValue();
        }
        return var1;
    }

    public Optional<Long> getLong(String var0) {
        return this.getOptional(var0).flatMap(Tag::asLong);
    }

    public long getLongOr(String var0, long var1) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof NumericTag) {
            NumericTag var3 = (NumericTag)tag;
            return var3.longValue();
        }
        return var1;
    }

    public Optional<Float> getFloat(String var0) {
        return this.getOptional(var0).flatMap(Tag::asFloat);
    }

    public float getFloatOr(String var0, float var1) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof NumericTag) {
            NumericTag var2 = (NumericTag)tag;
            return var2.floatValue();
        }
        return var1;
    }

    public Optional<Double> getDouble(String var0) {
        return this.getOptional(var0).flatMap(Tag::asDouble);
    }

    public double getDoubleOr(String var0, double var1) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof NumericTag) {
            NumericTag var3 = (NumericTag)tag;
            return var3.doubleValue();
        }
        return var1;
    }

    public Optional<String> getString(String var0) {
        return this.getOptional(var0).flatMap(Tag::asString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStringOr(String var0, String var1) {
        Tag tag = this.tags.get(var0);
        if (!(tag instanceof StringTag)) return var1;
        StringTag stringTag = (StringTag)tag;
        try {
            String string = stringTag.value();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public Optional<byte[]> getByteArray(String var0) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag var1 = (ByteArrayTag)tag;
            return Optional.of(var1.getAsByteArray());
        }
        return Optional.empty();
    }

    public Optional<int[]> getIntArray(String var0) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof IntArrayTag) {
            IntArrayTag var1 = (IntArrayTag)tag;
            return Optional.of(var1.getAsIntArray());
        }
        return Optional.empty();
    }

    public Optional<long[]> getLongArray(String var0) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof LongArrayTag) {
            LongArrayTag var1 = (LongArrayTag)tag;
            return Optional.of(var1.getAsLongArray());
        }
        return Optional.empty();
    }

    public Optional<CompoundTag> getCompound(String var0) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof CompoundTag) {
            CompoundTag var1 = (CompoundTag)tag;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public CompoundTag getCompoundOrEmpty(String var0) {
        return this.getCompound(var0).orElseGet(CompoundTag::new);
    }

    public Optional<ListTag> getList(String var0) {
        Tag tag = this.tags.get(var0);
        if (tag instanceof ListTag) {
            ListTag var1 = (ListTag)tag;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public ListTag getListOrEmpty(String var0) {
        return this.getList(var0).orElseGet(ListTag::new);
    }

    public Optional<Boolean> getBoolean(String var0) {
        return this.getOptional(var0).flatMap(Tag::asBoolean);
    }

    public boolean getBooleanOr(String var0, boolean var1) {
        return this.getByteOr(var0, var1 ? (byte)1 : 0) != 0;
    }

    public void remove(String var0) {
        this.tags.remove(var0);
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitCompound(this);
        return var0.build();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    protected CompoundTag shallowCopy() {
        return new CompoundTag(new HashMap<String, Tag>(this.tags));
    }

    @Override
    public CompoundTag copy() {
        HashMap<String, Tag> var0 = new HashMap<String, Tag>();
        this.tags.forEach((? super K var1, ? super V var2) -> var0.put((String)var1, var2.copy()));
        return new CompoundTag(var0);
    }

    @Override
    public Optional<CompoundTag> asCompound() {
        return Optional.of(this);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof CompoundTag && Objects.equals(this.tags, ((CompoundTag)var0).tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    private static void writeNamedTag(String var0, Tag var1, DataOutput var2) throws IOException {
        var2.writeByte(var1.getId());
        if (var1.getId() == 0) {
            return;
        }
        var2.writeUTF(var0);
        var1.write(var2);
    }

    static Tag readNamedTagData(TagType<?> var0, String var1, DataInput var2, NbtAccounter var3) {
        try {
            return var0.load(var2, var3);
        }
        catch (IOException var4) {
            CrashReport var5 = CrashReport.forThrowable(var4, "Loading NBT data");
            CrashReportCategory var6 = var5.addCategory("NBT Tag");
            var6.setDetail("Tag name", var1);
            var6.setDetail("Tag type", var0.getName());
            throw new ReportedNbtException(var5);
        }
    }

    public CompoundTag merge(CompoundTag var0) {
        for (String var2 : var0.tags.keySet()) {
            Tag var3 = var0.tags.get(var2);
            if (var3 instanceof CompoundTag) {
                CompoundTag var4 = (CompoundTag)var3;
                Tag tag = this.tags.get(var2);
                if (tag instanceof CompoundTag) {
                    CompoundTag var5 = (CompoundTag)tag;
                    var5.merge(var4);
                    continue;
                }
            }
            this.put(var2, var3.copy());
        }
        return this;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitCompound(this);
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor var0) {
        block14: for (Map.Entry<String, Tag> var2 : this.tags.entrySet()) {
            Tag var3 = var2.getValue();
            TagType<?> var4 = var3.getType();
            StreamTagVisitor.EntryResult var5 = var0.visitEntry(var4);
            switch (var5) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            var5 = var0.visitEntry(var4, var2.getKey());
            switch (var5) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            StreamTagVisitor.ValueResult var6 = var3.accept(var0);
            switch (var6) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
            }
        }
        return var0.visitContainerEnd();
    }

    public <T> void store(String var0, Codec<T> var1, T var2) {
        this.store(var0, var1, NbtOps.INSTANCE, var2);
    }

    public <T> void storeNullable(String var0, Codec<T> var1, @Nullable T var2) {
        if (var2 != null) {
            this.store(var0, var1, var2);
        }
    }

    public <T> void store(String var0, Codec<T> var1, DynamicOps<Tag> var2, T var3) {
        this.put(var0, (Tag)var1.encodeStart(var2, var3).getOrThrow());
    }

    public <T> void storeNullable(String var0, Codec<T> var1, DynamicOps<Tag> var2, @Nullable T var3) {
        if (var3 != null) {
            this.store(var0, var1, var2, var3);
        }
    }

    public <T> void store(MapCodec<T> var0, T var1) {
        this.store(var0, NbtOps.INSTANCE, var1);
    }

    public <T> void store(MapCodec<T> var0, DynamicOps<Tag> var1, T var2) {
        this.merge((CompoundTag)var0.encoder().encodeStart(var1, var2).getOrThrow());
    }

    public <T> Optional<T> read(String var0, Codec<T> var1) {
        return this.read(var0, var1, NbtOps.INSTANCE);
    }

    public <T> Optional<T> read(String var0, Codec<T> var1, DynamicOps<Tag> var22) {
        Tag var3 = this.get(var0);
        if (var3 == null) {
            return Optional.empty();
        }
        return var1.parse(var22, (Object)var3).resultOrPartial(var2 -> LOGGER.error("Failed to read field ({}={}): {}", new Object[]{var0, var3, var2}));
    }

    public <T> Optional<T> read(MapCodec<T> var0) {
        return this.read(var0, NbtOps.INSTANCE);
    }

    public <T> Optional<T> read(MapCodec<T> var02, DynamicOps<Tag> var1) {
        return var02.decode(var1, (MapLike)var1.getMap((Object)this).getOrThrow()).resultOrPartial(var0 -> LOGGER.error("Failed to read value ({}): {}", (Object)this, var0));
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

