/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;

public class CollectToTag
implements StreamTagVisitor {
    private final Deque<ContainerBuilder> containerStack = new ArrayDeque<ContainerBuilder>();

    public CollectToTag() {
        this.containerStack.addLast(new RootBuilder());
    }

    @Nullable
    public Tag getResult() {
        return this.containerStack.getFirst().build();
    }

    protected int depth() {
        return this.containerStack.size() - 1;
    }

    private void appendEntry(Tag var0) {
        this.containerStack.getLast().acceptValue(var0);
    }

    @Override
    public StreamTagVisitor.ValueResult visitEnd() {
        this.appendEntry(EndTag.INSTANCE);
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(String var0) {
        this.appendEntry(StringTag.valueOf(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(byte var0) {
        this.appendEntry(ByteTag.valueOf(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(short var0) {
        this.appendEntry(ShortTag.valueOf(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(int var0) {
        this.appendEntry(IntTag.valueOf(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(long var0) {
        this.appendEntry(LongTag.valueOf(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(float var0) {
        this.appendEntry(FloatTag.valueOf(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(double var0) {
        this.appendEntry(DoubleTag.valueOf(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(byte[] var0) {
        this.appendEntry(new ByteArrayTag(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(int[] var0) {
        this.appendEntry(new IntArrayTag(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visit(long[] var0) {
        this.appendEntry(new LongArrayTag(var0));
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visitList(TagType<?> var0, int var1) {
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.EntryResult visitElement(TagType<?> var0, int var1) {
        this.enterContainerIfNeeded(var0);
        return StreamTagVisitor.EntryResult.ENTER;
    }

    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> var0) {
        return StreamTagVisitor.EntryResult.ENTER;
    }

    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> var0, String var1) {
        this.containerStack.getLast().acceptKey(var1);
        this.enterContainerIfNeeded(var0);
        return StreamTagVisitor.EntryResult.ENTER;
    }

    private void enterContainerIfNeeded(TagType<?> var0) {
        if (var0 == ListTag.TYPE) {
            this.containerStack.addLast(new ListBuilder());
        } else if (var0 == CompoundTag.TYPE) {
            this.containerStack.addLast(new CompoundBuilder());
        }
    }

    @Override
    public StreamTagVisitor.ValueResult visitContainerEnd() {
        ContainerBuilder var0 = this.containerStack.removeLast();
        Tag var1 = var0.build();
        if (var1 != null) {
            this.containerStack.getLast().acceptValue(var1);
        }
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    @Override
    public StreamTagVisitor.ValueResult visitRootEntry(TagType<?> var0) {
        this.enterContainerIfNeeded(var0);
        return StreamTagVisitor.ValueResult.CONTINUE;
    }

    static class RootBuilder
    implements ContainerBuilder {
        @Nullable
        private Tag result;

        RootBuilder() {
        }

        @Override
        public void acceptValue(Tag var0) {
            this.result = var0;
        }

        @Override
        @Nullable
        public Tag build() {
            return this.result;
        }
    }

    static interface ContainerBuilder {
        default public void acceptKey(String var0) {
        }

        public void acceptValue(Tag var1);

        @Nullable
        public Tag build();
    }

    static class ListBuilder
    implements ContainerBuilder {
        private final ListTag list = new ListTag();

        ListBuilder() {
        }

        @Override
        public void acceptValue(Tag var0) {
            this.list.addAndUnwrap(var0);
        }

        @Override
        public Tag build() {
            return this.list;
        }
    }

    static class CompoundBuilder
    implements ContainerBuilder {
        private final CompoundTag compound = new CompoundTag();
        private String lastId = "";

        CompoundBuilder() {
        }

        @Override
        public void acceptKey(String var0) {
            this.lastId = var0;
        }

        @Override
        public void acceptValue(Tag var0) {
            this.compound.put(this.lastId, var0);
        }

        @Override
        public Tag build() {
            return this.compound;
        }
    }
}

