/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;

public final class Style {
    public static final Style EMPTY = new Style(null, null, null, null, null, null, null, null, null, null, null);
    @Nullable
    final TextColor color;
    @Nullable
    final Integer shadowColor;
    @Nullable
    final Boolean bold;
    @Nullable
    final Boolean italic;
    @Nullable
    final Boolean underlined;
    @Nullable
    final Boolean strikethrough;
    @Nullable
    final Boolean obfuscated;
    @Nullable
    final ClickEvent clickEvent;
    @Nullable
    final HoverEvent hoverEvent;
    @Nullable
    final String insertion;
    @Nullable
    final FontDescription font;

    private static Style create(Optional<TextColor> var0, Optional<Integer> var1, Optional<Boolean> var2, Optional<Boolean> var3, Optional<Boolean> var4, Optional<Boolean> var5, Optional<Boolean> var6, Optional<ClickEvent> var7, Optional<HoverEvent> var8, Optional<String> var9, Optional<FontDescription> var10) {
        Style var11 = new Style(var0.orElse(null), var1.orElse(null), var2.orElse(null), var3.orElse(null), var4.orElse(null), var5.orElse(null), var6.orElse(null), var7.orElse(null), var8.orElse(null), var9.orElse(null), var10.orElse(null));
        if (var11.equals(EMPTY)) {
            return EMPTY;
        }
        return var11;
    }

    private Style(@Nullable TextColor var0, @Nullable Integer var1, @Nullable Boolean var2, @Nullable Boolean var3, @Nullable Boolean var4, @Nullable Boolean var5, @Nullable Boolean var6, @Nullable ClickEvent var7, @Nullable HoverEvent var8, @Nullable String var9, @Nullable FontDescription var10) {
        this.color = var0;
        this.shadowColor = var1;
        this.bold = var2;
        this.italic = var3;
        this.underlined = var4;
        this.strikethrough = var5;
        this.obfuscated = var6;
        this.clickEvent = var7;
        this.hoverEvent = var8;
        this.insertion = var9;
        this.font = var10;
    }

    @Nullable
    public TextColor getColor() {
        return this.color;
    }

    @Nullable
    public Integer getShadowColor() {
        return this.shadowColor;
    }

    public boolean isBold() {
        return this.bold == Boolean.TRUE;
    }

    public boolean isItalic() {
        return this.italic == Boolean.TRUE;
    }

    public boolean isStrikethrough() {
        return this.strikethrough == Boolean.TRUE;
    }

    public boolean isUnderlined() {
        return this.underlined == Boolean.TRUE;
    }

    public boolean isObfuscated() {
        return this.obfuscated == Boolean.TRUE;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Nullable
    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }

    @Nullable
    public HoverEvent getHoverEvent() {
        return this.hoverEvent;
    }

    @Nullable
    public String getInsertion() {
        return this.insertion;
    }

    public FontDescription getFont() {
        return this.font != null ? this.font : FontDescription.DEFAULT;
    }

    private static <T> Style checkEmptyAfterChange(Style var0, @Nullable T var1, @Nullable T var2) {
        if (var1 != null && var2 == null && var0.equals(EMPTY)) {
            return EMPTY;
        }
        return var0;
    }

    public Style withColor(@Nullable TextColor var0) {
        if (Objects.equals(this.color, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(var0, this.shadowColor, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.color, var0);
    }

    public Style withColor(@Nullable ChatFormatting var0) {
        return this.withColor(var0 != null ? TextColor.fromLegacyFormat(var0) : null);
    }

    public Style withColor(int var0) {
        return this.withColor(TextColor.fromRgb(var0));
    }

    public Style withShadowColor(int var0) {
        if (Objects.equals(this.shadowColor, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, var0, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.shadowColor, var0);
    }

    public Style withBold(@Nullable Boolean var0) {
        if (Objects.equals(this.bold, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, var0, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.bold, var0);
    }

    public Style withItalic(@Nullable Boolean var0) {
        if (Objects.equals(this.italic, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, this.bold, var0, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.italic, var0);
    }

    public Style withUnderlined(@Nullable Boolean var0) {
        if (Objects.equals(this.underlined, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, this.bold, this.italic, var0, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.underlined, var0);
    }

    public Style withStrikethrough(@Nullable Boolean var0) {
        if (Objects.equals(this.strikethrough, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, this.bold, this.italic, this.underlined, var0, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.strikethrough, var0);
    }

    public Style withObfuscated(@Nullable Boolean var0) {
        if (Objects.equals(this.obfuscated, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, this.bold, this.italic, this.underlined, this.strikethrough, var0, this.clickEvent, this.hoverEvent, this.insertion, this.font), this.obfuscated, var0);
    }

    public Style withClickEvent(@Nullable ClickEvent var0) {
        if (Objects.equals(this.clickEvent, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, var0, this.hoverEvent, this.insertion, this.font), this.clickEvent, var0);
    }

    public Style withHoverEvent(@Nullable HoverEvent var0) {
        if (Objects.equals(this.hoverEvent, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, var0, this.insertion, this.font), this.hoverEvent, var0);
    }

    public Style withInsertion(@Nullable String var0) {
        if (Objects.equals(this.insertion, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, var0, this.font), this.insertion, var0);
    }

    public Style withFont(@Nullable FontDescription var0) {
        if (Objects.equals(this.font, var0)) {
            return this;
        }
        return Style.checkEmptyAfterChange(new Style(this.color, this.shadowColor, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion, var0), this.font, var0);
    }

    public Style applyFormat(ChatFormatting var0) {
        TextColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        switch (var0) {
            case OBFUSCATED: {
                var6 = true;
                break;
            }
            case BOLD: {
                var2 = true;
                break;
            }
            case STRIKETHROUGH: {
                var4 = true;
                break;
            }
            case UNDERLINE: {
                var5 = true;
                break;
            }
            case ITALIC: {
                var3 = true;
                break;
            }
            case RESET: {
                return EMPTY;
            }
            default: {
                var1 = TextColor.fromLegacyFormat(var0);
            }
        }
        return new Style(var1, this.shadowColor, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public Style applyLegacyFormat(ChatFormatting var0) {
        TextColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        switch (var0) {
            case OBFUSCATED: {
                var6 = true;
                break;
            }
            case BOLD: {
                var2 = true;
                break;
            }
            case STRIKETHROUGH: {
                var4 = true;
                break;
            }
            case UNDERLINE: {
                var5 = true;
                break;
            }
            case ITALIC: {
                var3 = true;
                break;
            }
            case RESET: {
                return EMPTY;
            }
            default: {
                var6 = false;
                var2 = false;
                var4 = false;
                var5 = false;
                var3 = false;
                var1 = TextColor.fromLegacyFormat(var0);
            }
        }
        return new Style(var1, this.shadowColor, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public Style applyFormats(ChatFormatting ... var0) {
        TextColor var1 = this.color;
        Boolean var2 = this.bold;
        Boolean var3 = this.italic;
        Boolean var4 = this.strikethrough;
        Boolean var5 = this.underlined;
        Boolean var6 = this.obfuscated;
        block8: for (ChatFormatting var10 : var0) {
            switch (var10) {
                case OBFUSCATED: {
                    var6 = true;
                    continue block8;
                }
                case BOLD: {
                    var2 = true;
                    continue block8;
                }
                case STRIKETHROUGH: {
                    var4 = true;
                    continue block8;
                }
                case UNDERLINE: {
                    var5 = true;
                    continue block8;
                }
                case ITALIC: {
                    var3 = true;
                    continue block8;
                }
                case RESET: {
                    return EMPTY;
                }
                default: {
                    var1 = TextColor.fromLegacyFormat(var10);
                }
            }
        }
        return new Style(var1, this.shadowColor, var2, var3, var5, var4, var6, this.clickEvent, this.hoverEvent, this.insertion, this.font);
    }

    public Style applyTo(Style var0) {
        if (this == EMPTY) {
            return var0;
        }
        if (var0 == EMPTY) {
            return this;
        }
        return new Style(this.color != null ? this.color : var0.color, this.shadowColor != null ? this.shadowColor : var0.shadowColor, this.bold != null ? this.bold : var0.bold, this.italic != null ? this.italic : var0.italic, this.underlined != null ? this.underlined : var0.underlined, this.strikethrough != null ? this.strikethrough : var0.strikethrough, this.obfuscated != null ? this.obfuscated : var0.obfuscated, this.clickEvent != null ? this.clickEvent : var0.clickEvent, this.hoverEvent != null ? this.hoverEvent : var0.hoverEvent, this.insertion != null ? this.insertion : var0.insertion, this.font != null ? this.font : var0.font);
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder("{");
        class Collector {
            private boolean isNotFirst;
            final /* synthetic */ StringBuilder val$result;

            Collector(Style var0, StringBuilder stringBuilder) {
                this.val$result = stringBuilder;
            }

            private void prependSeparator() {
                if (this.isNotFirst) {
                    this.val$result.append(',');
                }
                this.isNotFirst = true;
            }

            void addFlagString(String var0, @Nullable Boolean var1) {
                if (var1 != null) {
                    this.prependSeparator();
                    if (!var1.booleanValue()) {
                        this.val$result.append('!');
                    }
                    this.val$result.append(var0);
                }
            }

            void addValueString(String var0, @Nullable Object var1) {
                if (var1 != null) {
                    this.prependSeparator();
                    this.val$result.append(var0);
                    this.val$result.append('=');
                    this.val$result.append(var1);
                }
            }
        }
        Collector var1 = new Collector(this, var0);
        var1.addValueString("color", this.color);
        var1.addValueString("shadowColor", this.shadowColor);
        var1.addFlagString("bold", this.bold);
        var1.addFlagString("italic", this.italic);
        var1.addFlagString("underlined", this.underlined);
        var1.addFlagString("strikethrough", this.strikethrough);
        var1.addFlagString("obfuscated", this.obfuscated);
        var1.addValueString("clickEvent", this.clickEvent);
        var1.addValueString("hoverEvent", this.hoverEvent);
        var1.addValueString("insertion", this.insertion);
        var1.addValueString("font", this.font);
        var0.append("}");
        return var0.toString();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof Style) {
            Style var1 = (Style)var0;
            return this.bold == var1.bold && Objects.equals(this.getColor(), var1.getColor()) && Objects.equals(this.getShadowColor(), var1.getShadowColor()) && this.italic == var1.italic && this.obfuscated == var1.obfuscated && this.strikethrough == var1.strikethrough && this.underlined == var1.underlined && Objects.equals(this.clickEvent, var1.clickEvent) && Objects.equals(this.hoverEvent, var1.hoverEvent) && Objects.equals(this.insertion, var1.insertion) && Objects.equals(this.font, var1.font);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.shadowColor, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.clickEvent, this.hoverEvent, this.insertion);
    }

    public static class Serializer {
        public static final MapCodec<Style> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)TextColor.CODEC.optionalFieldOf("color").forGetter(var0 -> Optional.ofNullable(var0.color)), (App)ExtraCodecs.ARGB_COLOR_CODEC.optionalFieldOf("shadow_color").forGetter(var0 -> Optional.ofNullable(var0.shadowColor)), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(var0 -> Optional.ofNullable(var0.bold)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(var0 -> Optional.ofNullable(var0.italic)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(var0 -> Optional.ofNullable(var0.underlined)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(var0 -> Optional.ofNullable(var0.strikethrough)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(var0 -> Optional.ofNullable(var0.obfuscated)), (App)ClickEvent.CODEC.optionalFieldOf("click_event").forGetter(var0 -> Optional.ofNullable(var0.clickEvent)), (App)HoverEvent.CODEC.optionalFieldOf("hover_event").forGetter(var0 -> Optional.ofNullable(var0.hoverEvent)), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(var0 -> Optional.ofNullable(var0.insertion)), (App)FontDescription.CODEC.optionalFieldOf("font").forGetter(var0 -> Optional.ofNullable(var0.font))).apply((Applicative)var02, Style::create));
        public static final Codec<Style> CODEC = MAP_CODEC.codec();
        public static final StreamCodec<RegistryFriendlyByteBuf, Style> TRUSTED_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistriesTrusted(CODEC);
    }
}

