/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundCommandsPacket> STREAM_CODEC = Packet.codec(ClientboundCommandsPacket::write, ClientboundCommandsPacket::new);
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte FLAG_RESTRICTED = 32;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<Entry> entries;

    public <S> ClientboundCommandsPacket(RootCommandNode<S> var0, NodeInspector<S> var1) {
        Object2IntMap<CommandNode<S>> var2 = ClientboundCommandsPacket.enumerateNodes(var0);
        this.entries = ClientboundCommandsPacket.createEntries(var2, var1);
        this.rootIndex = var2.getInt(var0);
    }

    private ClientboundCommandsPacket(FriendlyByteBuf var0) {
        this.entries = var0.readList(ClientboundCommandsPacket::readNode);
        this.rootIndex = var0.readVarInt();
        ClientboundCommandsPacket.validateEntries(this.entries);
    }

    private void write(FriendlyByteBuf var02) {
        var02.writeCollection(this.entries, (var0, var1) -> var1.write((FriendlyByteBuf)((Object)var0)));
        var02.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<Entry> var0, BiPredicate<Entry, IntSet> var1) {
        IntOpenHashSet var2 = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)var0.size()));
        while (!var2.isEmpty()) {
            boolean var3 = var2.removeIf(arg_0 -> ClientboundCommandsPacket.lambda$validateEntries$1(var1, var0, (IntSet)var2, arg_0));
            if (var3) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<Entry> var0) {
        ClientboundCommandsPacket.validateEntries(var0, Entry::canBuild);
        ClientboundCommandsPacket.validateEntries(var0, Entry::canResolve);
    }

    private static <S> Object2IntMap<CommandNode<S>> enumerateNodes(RootCommandNode<S> var0) {
        CommandNode var3;
        Object2IntOpenHashMap var1 = new Object2IntOpenHashMap();
        ArrayDeque<Object> var2 = new ArrayDeque<Object>();
        var2.add(var0);
        while ((var3 = (CommandNode)var2.poll()) != null) {
            if (var1.containsKey((Object)var3)) continue;
            int var4 = var1.size();
            var1.put((Object)var3, var4);
            var2.addAll(var3.getChildren());
            if (var3.getRedirect() == null) continue;
            var2.add(var3.getRedirect());
        }
        return var1;
    }

    private static <S> List<Entry> createEntries(Object2IntMap<CommandNode<S>> var0, NodeInspector<S> var1) {
        ObjectArrayList var2 = new ObjectArrayList(var0.size());
        var2.size(var0.size());
        for (Object2IntMap.Entry var4 : Object2IntMaps.fastIterable(var0)) {
            var2.set(var4.getIntValue(), (Object)ClientboundCommandsPacket.createEntry((CommandNode)var4.getKey(), var1, var0));
        }
        return var2;
    }

    private static Entry readNode(FriendlyByteBuf var0) {
        byte var1 = var0.readByte();
        int[] var2 = var0.readVarIntArray();
        int var3 = (var1 & 8) != 0 ? var0.readVarInt() : 0;
        NodeStub var4 = ClientboundCommandsPacket.read(var0, var1);
        return new Entry(var4, var1, var3, var2);
    }

    @Nullable
    private static NodeStub read(FriendlyByteBuf var0, byte var1) {
        int var2 = var1 & 3;
        if (var2 == 2) {
            String var3 = var0.readUtf();
            int var4 = var0.readVarInt();
            ArgumentTypeInfo var5 = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId(var4);
            if (var5 == null) {
                return null;
            }
            Object var6 = var5.deserializeFromNetwork(var0);
            ResourceLocation var7 = (var1 & 0x10) != 0 ? var0.readResourceLocation() : null;
            return new ArgumentNodeStub(var3, (ArgumentTypeInfo.Template<?>)var6, var7);
        }
        if (var2 == 1) {
            String var3 = var0.readUtf();
            return new LiteralNodeStub(var3);
        }
        return null;
    }

    private static <S> Entry createEntry(CommandNode<S> var0, NodeInspector<S> var1, Object2IntMap<CommandNode<S>> var2) {
        Record var5;
        int var4;
        int var3 = 0;
        if (var0.getRedirect() != null) {
            var3 |= 8;
            var4 = var2.getInt(var0.getRedirect());
        } else {
            var4 = 0;
        }
        if (var1.isExecutable(var0)) {
            var3 |= 4;
        }
        if (var1.isRestricted(var0)) {
            var3 |= 0x20;
        }
        CommandNode<S> commandNode = var0;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, ArgumentCommandNode.class, LiteralCommandNode.class}, commandNode2, n)) {
            case 0: {
                RootCommandNode var8 = (RootCommandNode)commandNode2;
                var3 |= 0;
                var5 = null;
                break;
            }
            case 1: {
                ArgumentCommandNode var9 = (ArgumentCommandNode)commandNode2;
                ResourceLocation var10 = var1.suggestionId(var9);
                var5 = new ArgumentNodeStub(var9.getName(), ArgumentTypeInfos.unpack(var9.getType()), var10);
                var3 |= 2;
                if (var10 != null) {
                    var3 |= 0x10;
                }
                break;
            }
            case 2: {
                LiteralCommandNode var10 = (LiteralCommandNode)commandNode2;
                var5 = new LiteralNodeStub(var10.getLiteral());
                var3 |= 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(var0));
            }
        }
        int[] var6 = var0.getChildren().stream().mapToInt(arg_0 -> var2.getInt(arg_0)).toArray();
        return new Entry((NodeStub)((Object)var5), var3, var4, var6);
    }

    @Override
    public PacketType<ClientboundCommandsPacket> type() {
        return GamePacketTypes.CLIENTBOUND_COMMANDS;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleCommands(this);
    }

    public <S> RootCommandNode<S> getRoot(CommandBuildContext var0, NodeBuilder<S> var1) {
        return (RootCommandNode)new NodeResolver<S>(var0, var1, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean lambda$validateEntries$1(BiPredicate var0, List var1, IntSet var2, int var3) {
        return var0.test((Entry)var1.get(var3), var2);
    }

    public static interface NodeInspector<S> {
        @Nullable
        public ResourceLocation suggestionId(ArgumentCommandNode<S, ?> var1);

        public boolean isExecutable(CommandNode<S> var1);

        public boolean isRestricted(CommandNode<S> var1);
    }

    static final class Entry
    extends Record {
        @Nullable
        final NodeStub stub;
        final int flags;
        final int redirect;
        final int[] children;

        Entry(@Nullable NodeStub var0, int var1, int var2, int[] var3) {
            this.stub = var0;
            this.flags = var1;
            this.redirect = var2;
            this.children = var3;
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeByte(this.flags);
            var0.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                var0.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(var0);
            }
        }

        public boolean canBuild(IntSet var0) {
            if ((this.flags & 8) != 0) {
                return !var0.contains(this.redirect);
            }
            return true;
        }

        public boolean canResolve(IntSet var0) {
            for (int var4 : this.children) {
                if (!var0.contains(var4)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "stub;flags;redirect;children", "stub", "flags", "redirect", "children"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "stub;flags;redirect;children", "stub", "flags", "redirect", "children"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "stub;flags;redirect;children", "stub", "flags", "redirect", "children"}, this, var0);
        }

        @Nullable
        public NodeStub stub() {
            return this.stub;
        }

        public int flags() {
            return this.flags;
        }

        public int redirect() {
            return this.redirect;
        }

        public int[] children() {
            return this.children;
        }
    }

    static interface NodeStub {
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var1, NodeBuilder<S> var2);

        public void write(FriendlyByteBuf var1);
    }

    record ArgumentNodeStub(String id, ArgumentTypeInfo.Template<?> argumentType, @Nullable ResourceLocation suggestionId) implements NodeStub
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var0, NodeBuilder<S> var1) {
            Object var2 = this.argumentType.instantiate(var0);
            return var1.createArgument(this.id, (ArgumentType<?>)var2, this.suggestionId);
        }

        @Override
        public void write(FriendlyByteBuf var0) {
            var0.writeUtf(this.id);
            ArgumentNodeStub.serializeCap(var0, this.argumentType);
            if (this.suggestionId != null) {
                var0.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(FriendlyByteBuf var0, ArgumentTypeInfo.Template<A> var1) {
            ArgumentNodeStub.serializeCap(var0, var1.type(), var1);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeCap(FriendlyByteBuf var0, ArgumentTypeInfo<A, T> var1, ArgumentTypeInfo.Template<A> var2) {
            var0.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(var1));
            var1.serializeToNetwork(var2, var0);
        }
    }

    record LiteralNodeStub(String id) implements NodeStub
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var0, NodeBuilder<S> var1) {
            return var1.createLiteral(this.id);
        }

        @Override
        public void write(FriendlyByteBuf var0) {
            var0.writeUtf(this.id);
        }
    }

    static class NodeResolver<S> {
        private final CommandBuildContext context;
        private final NodeBuilder<S> builder;
        private final List<Entry> entries;
        private final List<CommandNode<S>> nodes;

        NodeResolver(CommandBuildContext var0, NodeBuilder<S> var1, List<Entry> var2) {
            this.context = var0;
            this.builder = var1;
            this.entries = var2;
            ObjectArrayList var3 = new ObjectArrayList();
            var3.size(var2.size());
            this.nodes = var3;
        }

        public CommandNode<S> resolve(int var0) {
            Object var3;
            CommandNode<S> var1 = this.nodes.get(var0);
            if (var1 != null) {
                return var1;
            }
            Entry var2 = this.entries.get(var0);
            if (var2.stub == null) {
                var3 = new RootCommandNode();
            } else {
                ArgumentBuilder<S, ?> var4 = var2.stub.build(this.context, this.builder);
                if ((var2.flags & 8) != 0) {
                    var4.redirect(this.resolve(var2.redirect));
                }
                boolean var5 = (var2.flags & 4) != 0;
                boolean var6 = (var2.flags & 0x20) != 0;
                var3 = this.builder.configure(var4, var5, var6).build();
            }
            this.nodes.set(var0, (CommandNode<S>)var3);
            for (int var7 : var2.children) {
                CommandNode<S> var8 = this.resolve(var7);
                if (var8 instanceof RootCommandNode) continue;
                var3.addChild(var8);
            }
            return var3;
        }
    }

    public static interface NodeBuilder<S> {
        public ArgumentBuilder<S, ?> createLiteral(String var1);

        public ArgumentBuilder<S, ?> createArgument(String var1, ArgumentType<?> var2, @Nullable ResourceLocation var3);

        public ArgumentBuilder<S, ?> configure(ArgumentBuilder<S, ?> var1, boolean var2, boolean var3);
    }
}

