/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.chase;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ChaseServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String serverBindAddress;
    private final int serverPort;
    private final PlayerList playerList;
    private final int broadcastIntervalMs;
    private volatile boolean wantsToRun;
    @Nullable
    private ServerSocket serverSocket;
    private final CopyOnWriteArrayList<Socket> clientSockets = new CopyOnWriteArrayList();

    public ChaseServer(String var0, int var1, PlayerList var2, int var3) {
        this.serverBindAddress = var0;
        this.serverPort = var1;
        this.playerList = var2;
        this.broadcastIntervalMs = var3;
    }

    public void start() throws IOException {
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            LOGGER.warn("Remote control server was asked to start, but it is already running. Will ignore.");
            return;
        }
        this.wantsToRun = true;
        this.serverSocket = new ServerSocket(this.serverPort, 50, InetAddress.getByName(this.serverBindAddress));
        Thread var0 = new Thread(this::runAcceptor, "chase-server-acceptor");
        var0.setDaemon(true);
        var0.start();
        Thread var1 = new Thread(this::runSender, "chase-server-sender");
        var1.setDaemon(true);
        var1.start();
    }

    private void runSender() {
        PlayerPosition var0 = null;
        while (this.wantsToRun) {
            if (!this.clientSockets.isEmpty()) {
                Object var2;
                PlayerPosition var1 = this.getPlayerPosition();
                if (var1 != null && !var1.equals(var0)) {
                    var0 = var1;
                    var2 = var1.format().getBytes(StandardCharsets.US_ASCII);
                    for (Socket var4 : this.clientSockets) {
                        if (var4.isClosed()) continue;
                        Util.ioPool().execute(() -> ChaseServer.lambda$runSender$0(var4, (byte[])var2));
                    }
                }
                var2 = this.clientSockets.stream().filter(Socket::isClosed).collect(Collectors.toList());
                this.clientSockets.removeAll((Collection<?>)var2);
            }
            if (!this.wantsToRun) continue;
            try {
                Thread.sleep(this.broadcastIntervalMs);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        this.wantsToRun = false;
        IOUtils.closeQuietly((ServerSocket)this.serverSocket);
        this.serverSocket = null;
    }

    private void runAcceptor() {
        try {
            while (this.wantsToRun) {
                if (this.serverSocket == null) continue;
                LOGGER.info("Remote control server is listening for connections on port {}", (Object)this.serverPort);
                Socket var0 = this.serverSocket.accept();
                LOGGER.info("Remote control server received client connection on port {}", (Object)var0.getPort());
                this.clientSockets.add(var0);
            }
        }
        catch (ClosedByInterruptException var0) {
            if (this.wantsToRun) {
                LOGGER.info("Remote control server closed by interrupt");
            }
        }
        catch (IOException var0) {
            if (this.wantsToRun) {
                LOGGER.error("Remote control server closed because of an IO exception", (Throwable)var0);
            }
        }
        finally {
            IOUtils.closeQuietly((ServerSocket)this.serverSocket);
        }
        LOGGER.info("Remote control server is now stopped");
        this.wantsToRun = false;
    }

    @Nullable
    private PlayerPosition getPlayerPosition() {
        List<ServerPlayer> var0 = this.playerList.getPlayers();
        if (var0.isEmpty()) {
            return null;
        }
        ServerPlayer var1 = var0.get(0);
        String var2 = (String)ChaseCommand.DIMENSION_NAMES.inverse().get(var1.level().dimension());
        if (var2 == null) {
            return null;
        }
        return new PlayerPosition(var2, var1.getX(), var1.getY(), var1.getZ(), var1.getYRot(), var1.getXRot());
    }

    private static /* synthetic */ void lambda$runSender$0(Socket var0, byte[] var1) {
        try {
            OutputStream var2 = var0.getOutputStream();
            var2.write(var1);
            var2.flush();
        }
        catch (IOException var2) {
            LOGGER.info("Remote control client socket got an IO exception and will be closed", (Throwable)var2);
            IOUtils.closeQuietly((Socket)var0);
        }
    }

    record PlayerPosition(String dimensionName, double x, double y, double z, float yRot, float xRot) {
        String format() {
            return String.format(Locale.ROOT, "t %s %.2f %.2f %.2f %.2f %.2f\n", this.dimensionName, this.x, this.y, this.z, Float.valueOf(this.yRot), Float.valueOf(this.xRot));
        }
    }
}

