/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.BanListEntry;
import net.minecraft.server.players.PlayerList;

public class BanListCommands {
    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("banlist").requires(Commands.hasPermission(3))).executes(var0 -> {
            PlayerList var1 = ((CommandSourceStack)var0.getSource()).getServer().getPlayerList();
            return BanListCommands.showList((CommandSourceStack)var0.getSource(), Lists.newArrayList((Iterable)Iterables.concat(var1.getBans().getEntries(), var1.getIpBans().getEntries())));
        })).then(Commands.literal("ips").executes(var0 -> BanListCommands.showList((CommandSourceStack)var0.getSource(), ((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getIpBans().getEntries())))).then(Commands.literal("players").executes(var0 -> BanListCommands.showList((CommandSourceStack)var0.getSource(), ((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getBans().getEntries())))));
    }

    private static int showList(CommandSourceStack var0, Collection<? extends BanListEntry<?>> var1) {
        if (var1.isEmpty()) {
            var0.sendSuccess(() -> Component.translatable("commands.banlist.none"), false);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.banlist.list", var1.size()), false);
            for (BanListEntry<?> var3 : var1) {
                var0.sendSuccess(() -> Component.translatable("commands.banlist.entry", var3.getDisplayName(), var3.getSource(), var3.getReasonMessage()), false);
            }
        }
        return var1.size();
    }
}

