/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ExperienceCommand {
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("commands.experience.set.points.invalid"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        LiteralCommandNode<CommandSourceStack> var1 = var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("experience").requires(Commands.hasPermission(2))).then(Commands.literal("add").then(Commands.argument("target", EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("amount", IntegerArgumentType.integer()).executes(var0 -> ExperienceCommand.addExperience((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Type.POINTS))).then(Commands.literal("points").executes(var0 -> ExperienceCommand.addExperience((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Type.POINTS)))).then(Commands.literal("levels").executes(var0 -> ExperienceCommand.addExperience((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Type.LEVELS))))))).then(Commands.literal("set").then(Commands.argument("target", EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("amount", IntegerArgumentType.integer((int)0)).executes(var0 -> ExperienceCommand.setExperience((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Type.POINTS))).then(Commands.literal("points").executes(var0 -> ExperienceCommand.setExperience((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Type.POINTS)))).then(Commands.literal("levels").executes(var0 -> ExperienceCommand.setExperience((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Type.LEVELS))))))).then(Commands.literal("query").then(((RequiredArgumentBuilder)Commands.argument("target", EntityArgument.player()).then(Commands.literal("points").executes(var0 -> ExperienceCommand.queryExperience((CommandSourceStack)var0.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)var0, "target"), Type.POINTS)))).then(Commands.literal("levels").executes(var0 -> ExperienceCommand.queryExperience((CommandSourceStack)var0.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)var0, "target"), Type.LEVELS)))))));
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("xp").requires(Commands.hasPermission(2))).redirect(var1)));
    }

    private static int queryExperience(CommandSourceStack var0, ServerPlayer var1, Type var2) {
        int var3 = var2.query.applyAsInt(var1);
        var0.sendSuccess(() -> Component.translatable("commands.experience.query." + var0.name, var1.getDisplayName(), var3), false);
        return var3;
    }

    private static int addExperience(CommandSourceStack var0, Collection<? extends ServerPlayer> var1, int var2, Type var3) {
        for (ServerPlayer serverPlayer : var1) {
            var3.add.accept(serverPlayer, var2);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.experience.add." + var0.name + ".success.single", var1, ((ServerPlayer)var2.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.experience.add." + var0.name + ".success.multiple", var1, var2.size()), true);
        }
        return var1.size();
    }

    private static int setExperience(CommandSourceStack var0, Collection<? extends ServerPlayer> var1, int var2, Type var3) throws CommandSyntaxException {
        int var4 = 0;
        for (ServerPlayer serverPlayer : var1) {
            if (!var3.set.test(serverPlayer, var2)) continue;
            ++var4;
        }
        if (var4 == 0) {
            throw ERROR_SET_POINTS_INVALID.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.experience.set." + var0.name + ".success.single", var1, ((ServerPlayer)var2.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.experience.set." + var0.name + ".success.multiple", var1, var2.size()), true);
        }
        return var1.size();
    }

    static enum Type {
        POINTS("points", Player::giveExperiencePoints, (var0, var1) -> {
            if (var1 >= var0.getXpNeededForNextLevel()) {
                return false;
            }
            var0.setExperiencePoints((int)var1);
            return true;
        }, var0 -> Mth.floor(var0.experienceProgress * (float)var0.getXpNeededForNextLevel())),
        LEVELS("levels", ServerPlayer::giveExperienceLevels, (var0, var1) -> {
            var0.setExperienceLevels((int)var1);
            return true;
        }, var0 -> var0.experienceLevel);

        public final BiConsumer<ServerPlayer, Integer> add;
        public final BiPredicate<ServerPlayer, Integer> set;
        public final String name;
        final ToIntFunction<ServerPlayer> query;

        private Type(String var2, BiConsumer var3, BiPredicate var4, ToIntFunction var5) {
            this.add = var3;
            this.name = var2;
            this.set = var4;
            this.query = var5;
        }
    }
}

