/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;

public class MsgCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        LiteralCommandNode<CommandSourceStack> var1 = var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("msg").then(Commands.argument("targets", EntityArgument.players()).then(Commands.argument("message", MessageArgument.message()).executes(var0 -> {
            Collection<ServerPlayer> var1 = EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets");
            if (!var1.isEmpty()) {
                MessageArgument.resolveChatMessage((CommandContext<CommandSourceStack>)var0, "message", var2 -> MsgCommand.sendMessage((CommandSourceStack)var0.getSource(), var1, var2));
            }
            return var1.size();
        })))));
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("tell").redirect(var1)));
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("w").redirect(var1)));
    }

    private static void sendMessage(CommandSourceStack var0, Collection<ServerPlayer> var1, PlayerChatMessage var2) {
        ChatType.Bound var3 = ChatType.bind(ChatType.MSG_COMMAND_INCOMING, var0);
        OutgoingChatMessage var4 = OutgoingChatMessage.create(var2);
        boolean var5 = false;
        for (ServerPlayer var7 : var1) {
            ChatType.Bound var8 = ChatType.bind(ChatType.MSG_COMMAND_OUTGOING, var0).withTargetName(var7.getDisplayName());
            var0.sendChatMessage(var4, false, var8);
            boolean var9 = var0.shouldFilterMessageTo(var7);
            var7.sendChatMessage(var4, var9, var3);
            var5 |= var9 && var2.isFullyFiltered();
        }
        if (var5) {
            var0.sendSystemMessage(PlayerList.CHAT_FILTERED_FULL);
        }
    }
}

