/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec2;

public class SetWorldSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setworldspawn").requires(Commands.hasPermission(2))).executes(var0 -> SetWorldSpawnCommand.setSpawn((CommandSourceStack)var0.getSource(), BlockPos.containing(((CommandSourceStack)var0.getSource()).getPosition()), WorldCoordinates.ZERO_ROTATION))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(var0 -> SetWorldSpawnCommand.setSpawn((CommandSourceStack)var0.getSource(), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)var0, "pos"), WorldCoordinates.ZERO_ROTATION))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(var0 -> SetWorldSpawnCommand.setSpawn((CommandSourceStack)var0.getSource(), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)var0, "pos"), RotationArgument.getRotation((CommandContext<CommandSourceStack>)var0, "rotation")))))));
    }

    private static int setSpawn(CommandSourceStack var0, BlockPos var1, Coordinates var2) {
        ServerLevel var3 = var0.getLevel();
        Vec2 var4 = var2.getRotation(var0);
        float var5 = var4.y;
        float var6 = var4.x;
        var3.setRespawnData(LevelData.RespawnData.of(var3.dimension(), var1, var5, var6));
        var0.sendSuccess(() -> Component.translatable("commands.setworldspawn.success", var1.getX(), var1.getY(), var1.getZ(), Float.valueOf(var5), Float.valueOf(var6), var3.dimension().location().toString()), true);
        return 1;
    }
}

