/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.google.common.net.InetAddresses;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.util.ExtraCodecs;

public class IpBanlistService {
    private static final String BAN_SOURCE = "Management server";

    public static List<IpBanDto> get(MinecraftApi var0) {
        return var0.banListService().getIpBanEntries().stream().map(IpBan::from).map(IpBanDto::from).toList();
    }

    public static List<IpBanDto> add(MinecraftApi var02, List<IncomingIpBanDto> var1, ClientInfo var22) {
        var1.stream().map(var2 -> IpBanlistService.banIp(var02, var2, var22)).flatMap(Collection::stream).forEach(var0 -> var0.connection.disconnect(Component.translatable("multiplayer.disconnect.ip_banned")));
        return IpBanlistService.get(var02);
    }

    private static List<ServerPlayer> banIp(MinecraftApi var0, IncomingIpBanDto var1, ClientInfo var2) {
        Optional<ServerPlayer> var4;
        IpBan var3 = var1.toIpBan();
        if (var3 != null) {
            return IpBanlistService.banIp(var0, var3, var2);
        }
        if (var1.player().isPresent() && (var4 = var0.playerListService().getPlayer(var1.player().get().id(), var1.player().get().name())).isPresent()) {
            return IpBanlistService.banIp(var0, var1.toIpBan(var4.get()), var2);
        }
        return List.of();
    }

    private static List<ServerPlayer> banIp(MinecraftApi var0, IpBan var1, ClientInfo var2) {
        var0.banListService().addIpBan(var1.toIpBanEntry(), var2);
        return var0.playerListService().getPlayersWithAddress(var1.ip());
    }

    public static List<IpBanDto> clear(MinecraftApi var0, ClientInfo var1) {
        var0.banListService().clearIpBans(var1);
        return IpBanlistService.get(var0);
    }

    public static List<IpBanDto> remove(MinecraftApi var0, List<String> var1, ClientInfo var22) {
        var1.forEach(var2 -> var0.banListService().removeIpBan((String)var2, var22));
        return IpBanlistService.get(var0);
    }

    public static List<IpBanDto> set(MinecraftApi var02, List<IpBanDto> var12, ClientInfo var22) {
        Set var3 = var12.stream().filter(var0 -> InetAddresses.isInetAddress((String)var0.ip())).map(IpBanDto::toIpBan).collect(Collectors.toSet());
        Set var4 = var02.banListService().getIpBanEntries().stream().map(IpBan::from).collect(Collectors.toSet());
        var4.stream().filter(var1 -> !var3.contains(var1)).forEach(var2 -> var02.banListService().removeIpBan(var2.ip(), var22));
        var3.stream().filter(var1 -> !var4.contains(var1)).forEach(var2 -> var02.banListService().addIpBan(var2.toIpBanEntry(), var22));
        var3.stream().filter(var1 -> !var4.contains(var1)).flatMap(var1 -> var02.playerListService().getPlayersWithAddress(var1.ip()).stream()).forEach(var0 -> var0.connection.disconnect(Component.translatable("multiplayer.disconnect.ip_banned")));
        return IpBanlistService.get(var02);
    }

    public record IncomingIpBanDto(Optional<PlayerDto> player, Optional<String> ip, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<IncomingIpBanDto> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)PlayerDto.CODEC.codec().optionalFieldOf("player").forGetter(IncomingIpBanDto::player), (App)Codec.STRING.optionalFieldOf("ip").forGetter(IncomingIpBanDto::ip), (App)Codec.STRING.optionalFieldOf("reason").forGetter(IncomingIpBanDto::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(IncomingIpBanDto::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(IncomingIpBanDto::expires)).apply((Applicative)var0, IncomingIpBanDto::new));

        IpBan toIpBan(ServerPlayer var0) {
            return new IpBan(var0.getIpAddress(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires());
        }

        @Nullable
        IpBan toIpBan() {
            if (this.ip().isEmpty() || !InetAddresses.isInetAddress((String)this.ip().get())) {
                return null;
            }
            return new IpBan(this.ip().get(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires());
        }
    }

    record IpBan(String ip, @Nullable String reason, String source, Optional<Instant> expires) {
        static IpBan from(IpBanListEntry var0) {
            return new IpBan(Objects.requireNonNull((String)var0.getUser()), var0.getReason(), var0.getSource(), Optional.ofNullable(var0.getExpires()).map(Date::toInstant));
        }

        IpBanListEntry toIpBanEntry() {
            return new IpBanListEntry(this.ip(), null, this.source(), (Date)this.expires().map(Date::from).orElse(null), this.reason());
        }
    }

    public record IpBanDto(String ip, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<IpBanDto> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("ip").forGetter(IpBanDto::ip), (App)Codec.STRING.optionalFieldOf("reason").forGetter(IpBanDto::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(IpBanDto::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(IpBanDto::expires)).apply((Applicative)var0, IpBanDto::new));

        private static IpBanDto from(IpBan var0) {
            return new IpBanDto(var0.ip(), Optional.ofNullable(var0.reason()), Optional.of(var0.source()), var0.expires());
        }

        public static IpBanDto from(IpBanListEntry var0) {
            return IpBanDto.from(IpBan.from(var0));
        }

        private IpBan toIpBan() {
            return new IpBan(this.ip(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires());
        }
    }
}

