/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;

public class ServerBossEvent
extends BossEvent {
    private final Set<ServerPlayer> players = Sets.newHashSet();
    private final Set<ServerPlayer> unmodifiablePlayers = Collections.unmodifiableSet(this.players);
    public boolean visible = true;

    public ServerBossEvent(Component var0, BossEvent.BossBarColor var1, BossEvent.BossBarOverlay var2) {
        super(Mth.createInsecureUUID(), var0, var1, var2);
    }

    @Override
    public void setProgress(float var0) {
        if (var0 != this.progress) {
            super.setProgress(var0);
            this.broadcast(ClientboundBossEventPacket::createUpdateProgressPacket);
        }
    }

    @Override
    public void setColor(BossEvent.BossBarColor var0) {
        if (var0 != this.color) {
            super.setColor(var0);
            this.broadcast(ClientboundBossEventPacket::createUpdateStylePacket);
        }
    }

    @Override
    public void setOverlay(BossEvent.BossBarOverlay var0) {
        if (var0 != this.overlay) {
            super.setOverlay(var0);
            this.broadcast(ClientboundBossEventPacket::createUpdateStylePacket);
        }
    }

    @Override
    public BossEvent setDarkenScreen(boolean var0) {
        if (var0 != this.darkenScreen) {
            super.setDarkenScreen(var0);
            this.broadcast(ClientboundBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public BossEvent setPlayBossMusic(boolean var0) {
        if (var0 != this.playBossMusic) {
            super.setPlayBossMusic(var0);
            this.broadcast(ClientboundBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public BossEvent setCreateWorldFog(boolean var0) {
        if (var0 != this.createWorldFog) {
            super.setCreateWorldFog(var0);
            this.broadcast(ClientboundBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    @Override
    public void setName(Component var0) {
        if (!Objects.equal((Object)var0, (Object)this.name)) {
            super.setName(var0);
            this.broadcast(ClientboundBossEventPacket::createUpdateNamePacket);
        }
    }

    public void broadcast(Function<BossEvent, ClientboundBossEventPacket> var0) {
        if (this.visible) {
            ClientboundBossEventPacket var1 = var0.apply(this);
            for (ServerPlayer var3 : this.players) {
                var3.connection.send(var1);
            }
        }
    }

    public void addPlayer(ServerPlayer var0) {
        if (this.players.add(var0) && this.visible) {
            var0.connection.send(ClientboundBossEventPacket.createAddPacket(this));
        }
    }

    public void removePlayer(ServerPlayer var0) {
        if (this.players.remove(var0) && this.visible) {
            var0.connection.send(ClientboundBossEventPacket.createRemovePacket(this.getId()));
        }
    }

    public void removeAllPlayers() {
        if (!this.players.isEmpty()) {
            for (ServerPlayer var1 : Lists.newArrayList(this.players)) {
                this.removePlayer(var1);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean var0) {
        if (var0 != this.visible) {
            this.visible = var0;
            for (ServerPlayer var2 : this.players) {
                var2.connection.send(var0 ? ClientboundBossEventPacket.createAddPacket(this) : ClientboundBossEventPacket.createRemovePacket(this.getId()));
            }
        }
    }

    public Collection<ServerPlayer> getPlayers() {
        return this.unmodifiablePlayers;
    }
}

