/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.slf4j.Logger;

public class FolderRepositorySource
implements RepositorySource {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final PackSelectionConfig DISCOVERED_PACK_SELECTION_CONFIG = new PackSelectionConfig(false, Pack.Position.TOP, false);
    private final Path folder;
    private final PackType packType;
    private final PackSource packSource;
    private final DirectoryValidator validator;

    public FolderRepositorySource(Path var0, PackType var1, PackSource var2, DirectoryValidator var3) {
        this.folder = var0;
        this.packType = var1;
        this.packSource = var2;
        this.validator = var3;
    }

    private static String nameFromPath(Path var0) {
        return var0.getFileName().toString();
    }

    @Override
    public void loadPacks(Consumer<Pack> var0) {
        try {
            FileUtil.createDirectoriesSafe(this.folder);
            FolderRepositorySource.discoverPacks(this.folder, this.validator, (var1, var2) -> {
                PackLocationInfo var3 = this.createDiscoveredFilePackInfo((Path)var1);
                Pack var4 = Pack.readMetaAndCreate(var3, var2, this.packType, DISCOVERED_PACK_SELECTION_CONFIG);
                if (var4 != null) {
                    var0.accept(var4);
                }
            });
        }
        catch (IOException var12) {
            LOGGER.warn("Failed to list packs in {}", (Object)this.folder, (Object)var12);
        }
    }

    private PackLocationInfo createDiscoveredFilePackInfo(Path var0) {
        String var1 = FolderRepositorySource.nameFromPath(var0);
        return new PackLocationInfo("file/" + var1, Component.literal(var1), this.packSource, Optional.empty());
    }

    public static void discoverPacks(Path var0, DirectoryValidator var1, BiConsumer<Path, Pack.ResourcesSupplier> var2) throws IOException {
        FolderPackDetector var3 = new FolderPackDetector(var1);
        try (DirectoryStream<Path> var4 = Files.newDirectoryStream(var0);){
            for (Path var6 : var4) {
                try {
                    ArrayList<ForbiddenSymlinkInfo> var7 = new ArrayList<ForbiddenSymlinkInfo>();
                    Pack.ResourcesSupplier var8 = (Pack.ResourcesSupplier)var3.detectPackResources(var6, var7);
                    if (!var7.isEmpty()) {
                        LOGGER.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.getMessage(var6, var7));
                        continue;
                    }
                    if (var8 != null) {
                        var2.accept(var6, var8);
                        continue;
                    }
                    LOGGER.info("Found non-pack entry '{}', ignoring", (Object)var6);
                }
                catch (IOException var7) {
                    LOGGER.warn("Failed to read properties of '{}', ignoring", (Object)var6, (Object)var7);
                }
            }
        }
    }

    static class FolderPackDetector
    extends PackDetector<Pack.ResourcesSupplier> {
        protected FolderPackDetector(DirectoryValidator var0) {
            super(var0);
        }

        @Override
        @Nullable
        protected Pack.ResourcesSupplier createZipPack(Path var0) {
            FileSystem var1 = var0.getFileSystem();
            if (var1 == FileSystems.getDefault() || var1 instanceof LinkFileSystem) {
                return new FilePackResources.FileResourcesSupplier(var0);
            }
            LOGGER.info("Can't open pack archive at {}", (Object)var0);
            return null;
        }

        @Override
        protected Pack.ResourcesSupplier createDirectoryPack(Path var0) {
            return new PathPackResources.PathResourcesSupplier(var0);
        }

        @Override
        protected /* synthetic */ Object createDirectoryPack(Path path) throws IOException {
            return this.createDirectoryPack(path);
        }

        @Override
        @Nullable
        protected /* synthetic */ Object createZipPack(Path path) throws IOException {
            return this.createZipPack(path);
        }
    }
}

