/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.UnaryOperator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<FriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.composite(TypeSettings.STREAM_CODEC, var0 -> var0.crafting, TypeSettings.STREAM_CODEC, var0 -> var0.furnace, TypeSettings.STREAM_CODEC, var0 -> var0.blastFurnace, TypeSettings.STREAM_CODEC, var0 -> var0.smoker, RecipeBookSettings::new);
    public static final MapCodec<RecipeBookSettings> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)TypeSettings.CRAFTING_MAP_CODEC.forGetter(var0 -> var0.crafting), (App)TypeSettings.FURNACE_MAP_CODEC.forGetter(var0 -> var0.furnace), (App)TypeSettings.BLAST_FURNACE_MAP_CODEC.forGetter(var0 -> var0.blastFurnace), (App)TypeSettings.SMOKER_MAP_CODEC.forGetter(var0 -> var0.smoker)).apply((Applicative)var02, RecipeBookSettings::new));
    private TypeSettings crafting;
    private TypeSettings furnace;
    private TypeSettings blastFurnace;
    private TypeSettings smoker;

    public RecipeBookSettings() {
        this(TypeSettings.DEFAULT, TypeSettings.DEFAULT, TypeSettings.DEFAULT, TypeSettings.DEFAULT);
    }

    private RecipeBookSettings(TypeSettings var0, TypeSettings var1, TypeSettings var2, TypeSettings var3) {
        this.crafting = var0;
        this.furnace = var1;
        this.blastFurnace = var2;
        this.smoker = var3;
    }

    @VisibleForTesting
    public TypeSettings getSettings(RecipeBookType var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case RecipeBookType.CRAFTING -> this.crafting;
            case RecipeBookType.FURNACE -> this.furnace;
            case RecipeBookType.BLAST_FURNACE -> this.blastFurnace;
            case RecipeBookType.SMOKER -> this.smoker;
        };
    }

    private void updateSettings(RecipeBookType var0, UnaryOperator<TypeSettings> var1) {
        switch (var0) {
            case CRAFTING: {
                this.crafting = (TypeSettings)var1.apply(this.crafting);
                break;
            }
            case FURNACE: {
                this.furnace = (TypeSettings)var1.apply(this.furnace);
                break;
            }
            case BLAST_FURNACE: {
                this.blastFurnace = (TypeSettings)var1.apply(this.blastFurnace);
                break;
            }
            case SMOKER: {
                this.smoker = (TypeSettings)var1.apply(this.smoker);
            }
        }
    }

    public boolean isOpen(RecipeBookType var0) {
        return this.getSettings((RecipeBookType)var0).open;
    }

    public void setOpen(RecipeBookType var0, boolean var12) {
        this.updateSettings(var0, var1 -> var1.setOpen(var12));
    }

    public boolean isFiltering(RecipeBookType var0) {
        return this.getSettings((RecipeBookType)var0).filtering;
    }

    public void setFiltering(RecipeBookType var0, boolean var12) {
        this.updateSettings(var0, var1 -> var1.setFiltering(var12));
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(this.crafting, this.furnace, this.blastFurnace, this.smoker);
    }

    public void replaceFrom(RecipeBookSettings var0) {
        this.crafting = var0.crafting;
        this.furnace = var0.furnace;
        this.blastFurnace = var0.blastFurnace;
        this.smoker = var0.smoker;
    }

    public static final class TypeSettings
    extends Record {
        final boolean open;
        final boolean filtering;
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);
        public static final MapCodec<TypeSettings> CRAFTING_MAP_CODEC = TypeSettings.codec("isGuiOpen", "isFilteringCraftable");
        public static final MapCodec<TypeSettings> FURNACE_MAP_CODEC = TypeSettings.codec("isFurnaceGuiOpen", "isFurnaceFilteringCraftable");
        public static final MapCodec<TypeSettings> BLAST_FURNACE_MAP_CODEC = TypeSettings.codec("isBlastingFurnaceGuiOpen", "isBlastingFurnaceFilteringCraftable");
        public static final MapCodec<TypeSettings> SMOKER_MAP_CODEC = TypeSettings.codec("isSmokerGuiOpen", "isSmokerFilteringCraftable");
        public static final StreamCodec<ByteBuf, TypeSettings> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.BOOL, TypeSettings::open, ByteBufCodecs.BOOL, TypeSettings::filtering, TypeSettings::new);

        public TypeSettings(boolean var0, boolean var1) {
            this.open = var0;
            this.filtering = var1;
        }

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean var0) {
            return new TypeSettings(var0, this.filtering);
        }

        public TypeSettings setFiltering(boolean var0) {
            return new TypeSettings(this.open, var0);
        }

        private static MapCodec<TypeSettings> codec(String var0, String var1) {
            return RecordCodecBuilder.mapCodec(var2 -> var2.group((App)Codec.BOOL.optionalFieldOf(var0, (Object)false).forGetter(TypeSettings::open), (App)Codec.BOOL.optionalFieldOf(var1, (Object)false).forGetter(TypeSettings::filtering)).apply((Applicative)var2, TypeSettings::new));
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TypeSettings.class, "open;filtering", "open", "filtering"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TypeSettings.class, "open;filtering", "open", "filtering"}, this, var0);
        }

        public boolean open() {
            return this.open;
        }

        public boolean filtering() {
            return this.filtering;
        }
    }
}

