/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;

public class AddFieldFix
extends DataFix {
    private final String name;
    private final DSL.TypeReference type;
    private final String fieldName;
    private final String[] path;
    private final Function<Dynamic<?>, Dynamic<?>> fieldGenerator;

    public AddFieldFix(Schema var0, DSL.TypeReference var1, String var2, Function<Dynamic<?>, Dynamic<?>> var3, String ... var4) {
        super(var0, false);
        this.name = String.format(Locale.ROOT, "Adding field `%s` to type `%s`", var2, var1.typeName().toLowerCase());
        this.type = var1;
        this.fieldName = var2;
        this.path = var4;
        this.fieldGenerator = var3;
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped(this.name, this.getInputSchema().getType(this.type), this.getOutputSchema().getType(this.type), var02 -> var02.update(DSL.remainderFinder(), var0 -> this.addField((Dynamic<?>)var0, 0)));
    }

    private Dynamic<?> addField(Dynamic<?> var0, int var1) {
        if (var1 >= this.path.length) {
            return var0.set(this.fieldName, this.fieldGenerator.apply(var0));
        }
        Optional var2 = var0.get(this.path[var1]).result();
        if (var2.isEmpty()) {
            return var0;
        }
        return this.addField((Dynamic)var2.get(), var1 + 1);
    }
}

