/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.NamedEntityWriteReadFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class RemoveEmptyItemInBrushableBlockFix
extends NamedEntityWriteReadFix {
    public RemoveEmptyItemInBrushableBlockFix(Schema var0) {
        super(var0, false, "RemoveEmptyItemInSuspiciousBlockFix", References.BLOCK_ENTITY, "minecraft:brushable_block");
    }

    @Override
    protected <T> Dynamic<T> fix(Dynamic<T> var0) {
        Optional var1 = var0.get("item").result();
        if (var1.isPresent() && RemoveEmptyItemInBrushableBlockFix.isEmptyStack((Dynamic)var1.get())) {
            return var0.remove("item");
        }
        return var0;
    }

    private static boolean isEmptyStack(Dynamic<?> var0) {
        String var1 = NamespacedSchema.ensureNamespaced(var0.get("id").asString("minecraft:air"));
        int var2 = var0.get("count").asInt(0);
        return var1.equals("minecraft:air") || var2 == 0;
    }
}

