/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.joml.Vector3f;

class InfestedMobEffect
extends MobEffect {
    private final float chanceToSpawn;
    private final ToIntFunction<RandomSource> spawnedCount;

    protected InfestedMobEffect(MobEffectCategory mobeffectinfo, int i, float f, ToIntFunction<RandomSource> tointfunction) {
        super(mobeffectinfo, i, ParticleTypes.INFESTED);
        this.chanceToSpawn = f;
        this.spawnedCount = tointfunction;
    }

    @Override
    public void onMobHurt(ServerLevel worldserver, LivingEntity entityliving, int i, DamageSource damagesource, float f) {
        if (entityliving.getRandom().nextFloat() <= this.chanceToSpawn) {
            int j = this.spawnedCount.applyAsInt(entityliving.getRandom());
            for (int k = 0; k < j; ++k) {
                this.spawnSilverfish(worldserver, entityliving, entityliving.getX(), entityliving.getY() + (double)entityliving.getBbHeight() / 2.0, entityliving.getZ());
            }
        }
    }

    private void spawnSilverfish(ServerLevel worldserver, LivingEntity entityliving, double d0, double d1, double d2) {
        Silverfish entitysilverfish = EntityType.SILVERFISH.create(worldserver, EntitySpawnReason.TRIGGERED);
        if (entitysilverfish != null) {
            RandomSource randomsource = entityliving.getRandom();
            float f = 1.5707964f;
            float f1 = Mth.randomBetween(randomsource, -1.5707964f, 1.5707964f);
            Vector3f vector3f = entityliving.getLookAngle().toVector3f().mul(0.3f).mul(1.0f, 1.5f, 1.0f).rotateY(f1);
            entitysilverfish.snapTo(d0, d1, d2, worldserver.getRandom().nextFloat() * 360.0f, 0.0f);
            entitysilverfish.setDeltaMovement(new Vec3(vector3f));
            if (!worldserver.addFreshEntity(entitysilverfish, CreatureSpawnEvent.SpawnReason.POTION_EFFECT)) {
                return;
            }
            entitysilverfish.playSound(SoundEvents.SILVERFISH_HURT);
        }
    }
}

