/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class ExperienceOrb
extends Entity {
    protected static final EntityDataAccessor<Integer> DATA_VALUE = SynchedEntityData.defineId(ExperienceOrb.class, EntityDataSerializers.INT);
    private static final int LIFETIME = 6000;
    private static final int ENTITY_SCAN_PERIOD = 20;
    private static final int MAX_FOLLOW_DIST = 8;
    private static final int ORB_GROUPS_PER_AREA = 40;
    private static final double ORB_MERGE_DISTANCE = 0.5;
    private static final short DEFAULT_HEALTH = 5;
    private static final short DEFAULT_AGE = 0;
    private static final short DEFAULT_VALUE = 0;
    private static final int DEFAULT_COUNT = 1;
    private int age = 0;
    private int health = 5;
    private int count = 1;
    @Nullable
    private Player followingPlayer;
    private final InterpolationHandler interpolation = new InterpolationHandler(this);

    public ExperienceOrb(Level world, double d0, double d1, double d2, int i) {
        this(world, new Vec3(d0, d1, d2), Vec3.ZERO, i);
    }

    public ExperienceOrb(Level world, Vec3 vec3d, Vec3 vec3d1, int i) {
        this((EntityType<? extends ExperienceOrb>)EntityType.EXPERIENCE_ORB, world);
        this.setPos(vec3d);
        if (!world.isClientSide()) {
            this.setYRot(this.random.nextFloat() * 360.0f);
            Vec3 vec3d2 = new Vec3((this.random.nextDouble() * 0.2 - 0.1) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * 0.2 - 0.1) * 2.0);
            if (vec3d1.lengthSqr() > 0.0 && vec3d1.dot(vec3d2) < 0.0) {
                vec3d2 = vec3d2.scale(-1.0);
            }
            double d0 = this.getBoundingBox().getSize();
            this.setPos(vec3d.add(vec3d1.normalize().scale(d0 * 0.5)));
            this.setDeltaMovement(vec3d2);
            if (!world.noCollision(this.getBoundingBox())) {
                this.unstuckIfPossible(d0);
            }
        }
        this.setValue(i);
    }

    public ExperienceOrb(EntityType<? extends ExperienceOrb> entitytypes, Level world) {
        super(entitytypes, world);
    }

    protected void unstuckIfPossible(double d0) {
        Vec3 vec3d = this.position().add(0.0, (double)this.getBbHeight() / 2.0, 0.0);
        VoxelShape voxelshape = Shapes.create(AABB.ofSize(vec3d, d0, d0, d0));
        this.level().findFreePosition(this, voxelshape, vec3d, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()).ifPresent(vec3d1 -> this.setPos(vec3d1.add(0.0, (double)(-this.getBbHeight()) / 2.0, 0.0)));
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_VALUE, 0);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }

    @Override
    public void tick() {
        this.interpolation.interpolate();
        if (this.firstTick && this.level().isClientSide()) {
            this.firstTick = false;
        } else {
            boolean flag;
            super.tick();
            boolean bl = flag = !this.level().noCollision(this.getBoundingBox());
            if (this.isEyeInFluid(FluidTags.WATER)) {
                this.setUnderwaterMovement();
            } else if (!flag) {
                this.applyGravity();
            }
            if (this.level().getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
                this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            if (this.tickCount % 20 == 1) {
                this.scanForMerges();
            }
            this.followNearbyPlayer();
            if (this.followingPlayer == null && !this.level().isClientSide() && flag) {
                boolean flag1;
                boolean bl2 = flag1 = !this.level().noCollision(this.getBoundingBox().move(this.getDeltaMovement()));
                if (flag1) {
                    this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
                    this.hasImpulse = true;
                }
            }
            double d0 = this.getDeltaMovement().y;
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            float f = 0.98f;
            if (this.onGround()) {
                f = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(f));
            if (this.verticalCollisionBelow && d0 < -this.getGravity()) {
                this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, -d0 * 0.4, this.getDeltaMovement().z));
            }
            ++this.age;
            if (this.age >= 6000) {
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    private void followNearbyPlayer() {
        Player prevTarget = this.followingPlayer;
        if (this.followingPlayer == null || this.followingPlayer.isSpectator() || this.followingPlayer.distanceToSqr(this) > 64.0) {
            Player entityhuman = this.level().getNearestPlayer(this, 8.0);
            this.followingPlayer = entityhuman != null && !entityhuman.isSpectator() && !entityhuman.isDeadOrDying() ? entityhuman : null;
        }
        boolean cancelled = false;
        if (this.followingPlayer != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.followingPlayer, this.followingPlayer != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            LivingEntity target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.followingPlayer = prevTarget;
            } else {
                Player player = this.followingPlayer = target instanceof Player ? (Player)target : null;
            }
        }
        if (this.followingPlayer != null && !cancelled) {
            Vec3 vec3d = new Vec3(this.followingPlayer.getX() - this.getX(), this.followingPlayer.getY() + (double)this.followingPlayer.getEyeHeight() / 2.0 - this.getY(), this.followingPlayer.getZ() - this.getZ());
            double d0 = vec3d.lengthSqr();
            double d1 = 1.0 - Math.sqrt(d0) / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add(vec3d.normalize().scale(d1 * d1 * 0.1)));
        }
    }

    @Override
    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void scanForMerges() {
        if (this.level() instanceof ServerLevel) {
            for (ExperienceOrb entityexperienceorb : this.level().getEntities(EntityTypeTest.forClass(ExperienceOrb.class), this.getBoundingBox().inflate(0.5), this::canMerge)) {
                this.merge(entityexperienceorb);
            }
        }
    }

    public static void award(ServerLevel worldserver, Vec3 vec3d, int i) {
        ExperienceOrb.awardWithDirection(worldserver, vec3d, Vec3.ZERO, i);
    }

    public static void awardWithDirection(ServerLevel worldserver, Vec3 vec3d, Vec3 vec3d1, int i) {
        while (i > 0) {
            int j = ExperienceOrb.getExperienceValue(i);
            i -= j;
            if (ExperienceOrb.tryMergeToExisting(worldserver, vec3d, j)) continue;
            worldserver.addFreshEntity(new ExperienceOrb(worldserver, vec3d, vec3d1, j));
        }
    }

    private static boolean tryMergeToExisting(ServerLevel worldserver, Vec3 vec3d, int i) {
        AABB axisalignedbb = AABB.ofSize(vec3d, 1.0, 1.0, 1.0);
        int j = worldserver.getRandom().nextInt(40);
        List<ExperienceOrb> list = worldserver.getEntities(EntityTypeTest.forClass(ExperienceOrb.class), axisalignedbb, entityexperienceorb -> ExperienceOrb.canMerge(entityexperienceorb, j, i));
        if (!list.isEmpty()) {
            ExperienceOrb entityexperienceorb2 = list.get(0);
            ++entityexperienceorb2.count;
            entityexperienceorb2.age = 0;
            return true;
        }
        return false;
    }

    private boolean canMerge(ExperienceOrb entityexperienceorb) {
        return entityexperienceorb != this && ExperienceOrb.canMerge(entityexperienceorb, this.getId(), this.getValue());
    }

    private static boolean canMerge(ExperienceOrb entityexperienceorb, int i, int j) {
        return !entityexperienceorb.isRemoved() && (entityexperienceorb.getId() - i) % 40 == 0 && entityexperienceorb.getValue() == j;
    }

    private void merge(ExperienceOrb entityexperienceorb) {
        this.count += entityexperienceorb.count;
        this.age = Math.min(this.age, entityexperienceorb.age);
        entityexperienceorb.discard(EntityRemoveEvent.Cause.MERGE);
    }

    private void setUnderwaterMovement() {
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x * (double)0.99f, Math.min(vec3d.y + (double)5.0E-4f, (double)0.06f), vec3d.z * (double)0.99f);
    }

    @Override
    protected void doWaterSplashEffect() {
    }

    @Override
    public final boolean hurtClient(DamageSource damagesource) {
        return !this.isInvulnerableToBase(damagesource);
    }

    @Override
    public final boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isInvulnerableToBase(damagesource)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - f);
        if (this.health <= 0) {
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.putShort("Health", (short)this.health);
        valueoutput.putShort("Age", (short)this.age);
        valueoutput.putShort("Value", (short)this.getValue());
        valueoutput.putInt("Count", this.count);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.health = valueinput.getShortOr("Health", (short)5);
        this.age = valueinput.getShortOr("Age", (short)0);
        this.setValue(valueinput.getShortOr("Value", (short)0));
        this.count = valueinput.read("Count", ExtraCodecs.POSITIVE_INT).orElse(1);
    }

    @Override
    public void playerTouch(Player entityhuman) {
        if (entityhuman instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entityhuman;
            if (entityhuman.takeXpDelay == 0) {
                entityhuman.takeXpDelay = CraftEventFactory.callPlayerXpCooldownEvent(entityhuman, 2, PlayerExpCooldownChangeEvent.ChangeReason.PICKUP_ORB).getNewCooldown();
                entityhuman.take(this, 1);
                int i = this.repairPlayerItems(entityplayer, this.getValue());
                if (i > 0) {
                    entityhuman.giveExperiencePoints(CraftEventFactory.callPlayerExpChangeEvent(entityhuman, i).getAmount());
                }
                --this.count;
                if (this.count == 0) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                }
            }
        }
    }

    private int repairPlayerItems(ServerPlayer entityplayer, int i) {
        Optional<EnchantedItemInUse> optional = EnchantmentHelper.getRandomItemWith(EnchantmentEffectComponents.REPAIR_WITH_XP, entityplayer, ItemStack::isDamaged);
        if (optional.isPresent()) {
            int l;
            ItemStack itemstack = optional.get().itemStack();
            int j = EnchantmentHelper.modifyDurabilityToRepairFromXp(entityplayer.level(), itemstack, i);
            int k = Math.min(j, itemstack.getDamageValue());
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(entityplayer, this, itemstack, optional.get().inSlot(), k);
            k = event.getRepairAmount();
            if (event.isCancelled()) {
                return i;
            }
            itemstack.setDamageValue(itemstack.getDamageValue() - k);
            if (k > 0 && (l = i - k * i / j) > 0) {
                this.setValue(l);
                return this.repairPlayerItems(entityplayer, l);
            }
            return 0;
        }
        return i;
    }

    public int getValue() {
        return this.entityData.get(DATA_VALUE);
    }

    public void setValue(int i) {
        this.entityData.set(DATA_VALUE, i);
    }

    public int getIcon() {
        int i = this.getValue();
        return i >= 2477 ? 10 : (i >= 1237 ? 9 : (i >= 617 ? 8 : (i >= 307 ? 7 : (i >= 149 ? 6 : (i >= 73 ? 5 : (i >= 37 ? 4 : (i >= 17 ? 3 : (i >= 7 ? 2 : (i >= 3 ? 1 : 0)))))))));
    }

    public static int getExperienceValue(int i) {
        if (i > 162670129) {
            return i - 100000;
        }
        if (i > 81335063) {
            return 81335063;
        }
        if (i > 40667527) {
            return 40667527;
        }
        if (i > 20333759) {
            return 20333759;
        }
        if (i > 10166857) {
            return 10166857;
        }
        if (i > 5083423) {
            return 5083423;
        }
        if (i > 2541701) {
            return 2541701;
        }
        if (i > 1270849) {
            return 1270849;
        }
        if (i > 635413) {
            return 635413;
        }
        if (i > 317701) {
            return 317701;
        }
        if (i > 158849) {
            return 158849;
        }
        if (i > 79423) {
            return 79423;
        }
        if (i > 39709) {
            return 39709;
        }
        if (i > 19853) {
            return 19853;
        }
        if (i > 9923) {
            return 9923;
        }
        if (i > 4957) {
            return 4957;
        }
        return i >= 2477 ? 2477 : (i >= 1237 ? 1237 : (i >= 617 ? 617 : (i >= 307 ? 307 : (i >= 149 ? 149 : (i >= 73 ? 73 : (i >= 37 ? 37 : (i >= 17 ? 17 : (i >= 7 ? 7 : (i >= 3 ? 3 : 1)))))))));
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }
}

