/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.scores.PlayerTeam;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTeleportEvent;

public abstract class TamableAnimal
extends Animal
implements OwnableEntity {
    public static final int TELEPORT_WHEN_DISTANCE_IS_SQ = 144;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 1;
    private static final boolean DEFAULT_ORDERED_TO_SIT = false;
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(TamableAnimal.class, EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_OWNERUUID_ID = SynchedEntityData.defineId(TamableAnimal.class, EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
    private boolean orderedToSit = false;

    protected TamableAnimal(EntityType<? extends TamableAnimal> entitytypes, Level world) {
        super((EntityType<? extends Animal>)entitytypes, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_FLAGS_ID, (byte)0);
        datawatcher_a.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        EntityReference<LivingEntity> entityreference = this.getOwnerReference();
        EntityReference.store(entityreference, valueoutput, "Owner");
        valueoutput.putBoolean("Sitting", this.orderedToSit);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        EntityReference entityreference = EntityReference.readWithOldOwnerConversion(valueinput, "Owner", this.level());
        if (entityreference != null) {
            try {
                this.entityData.set(DATA_OWNERUUID_ID, Optional.of(entityreference));
                this.setTame(true, false);
            }
            catch (Throwable throwable) {
                this.setTame(false, true);
            }
        } else {
            this.entityData.set(DATA_OWNERUUID_ID, Optional.empty());
            this.setTame(false, true);
        }
        this.orderedToSit = valueinput.getBooleanOr("Sitting", false);
        this.setInSittingPose(this.orderedToSit);
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    protected void spawnTamingParticles(boolean flag) {
        SimpleParticleType particleparam = ParticleTypes.HEART;
        if (!flag) {
            particleparam = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particleparam, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 7) {
            this.spawnTamingParticles(true);
        } else if (b0 == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(b0);
        }
    }

    public boolean isTame() {
        return (this.entityData.get(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean flag, boolean flag1) {
        byte b0 = this.entityData.get(DATA_FLAGS_ID);
        if (flag) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(b0 | 4));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(b0 & 0xFFFFFFFB));
        }
        if (flag1) {
            this.applyTamingSideEffects();
        }
    }

    protected void applyTamingSideEffects() {
    }

    public boolean isInSittingPose() {
        return (this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean flag) {
        byte b0 = this.entityData.get(DATA_FLAGS_ID);
        if (flag) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(b0 | 1));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public EntityReference<LivingEntity> getOwnerReference() {
        return this.entityData.get(DATA_OWNERUUID_ID).orElse(null);
    }

    public void setOwner(@Nullable LivingEntity entityliving) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(entityliving).map(EntityReference::of));
    }

    public void setOwnerReference(@Nullable EntityReference<LivingEntity> entityreference) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(entityreference));
    }

    public void tame(Player entityhuman) {
        this.setTame(true, true);
        this.setOwner(entityhuman);
        if (entityhuman instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entityhuman;
            CriteriaTriggers.TAME_ANIMAL.trigger(entityplayer, this);
        }
    }

    @Override
    public boolean canAttack(LivingEntity entityliving) {
        return this.isOwnedBy(entityliving) ? false : super.canAttack(entityliving);
    }

    public boolean isOwnedBy(LivingEntity entityliving) {
        return entityliving == this.getOwner();
    }

    public boolean wantsToAttack(LivingEntity entityliving, LivingEntity entityliving1) {
        return true;
    }

    @Override
    @Nullable
    public PlayerTeam getTeam() {
        LivingEntity entityliving;
        PlayerTeam scoreboardteam = super.getTeam();
        if (scoreboardteam != null) {
            return scoreboardteam;
        }
        if (this.isTame() && (entityliving = this.getRootOwner()) != null) {
            return entityliving.getTeam();
        }
        return null;
    }

    @Override
    protected boolean considersEntityAsAlly(Entity entity) {
        if (this.isTame()) {
            LivingEntity entityliving = this.getRootOwner();
            if (entity == entityliving) {
                return true;
            }
            if (entityliving != null) {
                return entityliving.considersEntityAsAlly(entity);
            }
        }
        return super.considersEntityAsAlly(entity);
    }

    @Override
    public void die(DamageSource damagesource) {
        LivingEntity entityliving;
        ServerLevel worldserver;
        Level world = this.level();
        if (world instanceof ServerLevel && (worldserver = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && (entityliving = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entityliving;
            entityplayer.sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(damagesource);
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOrderedToSit(boolean flag) {
        this.orderedToSit = flag;
    }

    public void tryToTeleportToOwner() {
        LivingEntity entityliving = this.getOwner();
        if (entityliving != null) {
            this.teleportToAroundBlockPos(entityliving.blockPosition());
        }
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity entityliving = this.getOwner();
        return entityliving != null && this.distanceToSqr(this.getOwner()) >= 144.0;
    }

    private void teleportToAroundBlockPos(BlockPos blockposition) {
        for (int i = 0; i < 10; ++i) {
            int j = this.random.nextIntBetweenInclusive(-3, 3);
            int k = this.random.nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(blockposition.getX() + j, blockposition.getY() + l, blockposition.getZ() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int i, int j, int k) {
        if (!this.canTeleportTo(new BlockPos(i, j, k))) {
            return false;
        }
        EntityTeleportEvent event = CraftEventFactory.callEntityTeleportEvent(this, (double)i + 0.5, j, (double)k + 0.5);
        if (event.isCancelled()) {
            return false;
        }
        Location to = event.getTo();
        this.snapTo(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos blockposition) {
        PathType pathtype = WalkNodeEvaluator.getPathTypeStatic(this, blockposition);
        if (pathtype != PathType.WALKABLE) {
            return false;
        }
        BlockState iblockdata = this.level().getBlockState(blockposition.below());
        if (!this.canFlyToOwner() && iblockdata.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockposition1 = blockposition.subtract(this.blockPosition());
        return this.level().noCollision(this, this.getBoundingBox().move(blockposition1));
    }

    public final boolean unableToMoveToOwner() {
        return this.isOrderedToSit() || this.isPassenger() || this.mayBeLeashed() || this.getOwner() != null && this.getOwner().isSpectator();
    }

    protected boolean canFlyToOwner() {
        return false;
    }

    public class TamableAnimalPanicGoal
    extends PanicGoal {
        public TamableAnimalPanicGoal(double d0, TagKey tagkey) {
            super((PathfinderMob)TamableAnimal.this, d0, tagkey);
        }

        public TamableAnimalPanicGoal(double d0) {
            super(TamableAnimal.this, d0);
        }

        @Override
        public void tick() {
            if (!TamableAnimal.this.unableToMoveToOwner() && TamableAnimal.this.shouldTryTeleportToOwner()) {
                TamableAnimal.this.tryToTeleportToOwner();
            }
            super.tick();
        }
    }
}

