/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Function;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BabyFollowAdult {
    public static OneShot<LivingEntity> create(UniformInt uniformint, float f) {
        return BabyFollowAdult.create(uniformint, entityliving -> Float.valueOf(f), MemoryModuleType.NEAREST_VISIBLE_ADULT, false);
    }

    public static OneShot<LivingEntity> create(UniformInt uniformint, Function<LivingEntity, Float> function, MemoryModuleType<? extends LivingEntity> memorymoduletype, boolean flag) {
        return BehaviorBuilder.create(behaviorbuilder_b -> behaviorbuilder_b.group(behaviorbuilder_b.present(memorymoduletype), behaviorbuilder_b.registered(MemoryModuleType.LOOK_TARGET), behaviorbuilder_b.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1, memoryaccessor2) -> (worldserver, entityliving, i) -> {
            if (!entityliving.isBaby()) {
                return false;
            }
            LivingEntity entityliving1 = (LivingEntity)behaviorbuilder_b.get(memoryaccessor);
            if (entityliving.closerThan(entityliving1, uniformint.getMaxValue() + 1) && !entityliving.closerThan(entityliving1, uniformint.getMinValue())) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityliving, entityliving1, EntityTargetEvent.TargetReason.FOLLOW_LEADER);
                if (event.isCancelled()) {
                    return false;
                }
                if (event.getTarget() == null) {
                    memoryaccessor.erase();
                    return true;
                }
                entityliving1 = ((CraftLivingEntity)event.getTarget()).getHandle();
                WalkTarget memorytarget = new WalkTarget(new EntityTracker(entityliving1, flag, flag), ((Float)function.apply(entityliving)).floatValue(), uniformint.getMinValue() - 1);
                memoryaccessor1.set(new EntityTracker(entityliving1, true, flag));
                memoryaccessor2.set(memorytarget);
                return true;
            }
            return false;
        }));
    }
}

