/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos;
import net.minecraft.world.level.block.Block;

public class LongJumpToPreferredBlock<E extends Mob>
extends LongJumpToRandomPos<E> {
    private final TagKey<Block> preferredBlockTag;
    private final float preferredBlocksChance;
    private final List<LongJumpToRandomPos.PossibleJump> notPrefferedJumpCandidates = new ArrayList<LongJumpToRandomPos.PossibleJump>();
    private boolean currentlyWantingPreferredOnes;

    public LongJumpToPreferredBlock(UniformInt var0, int var1, int var2, float var3, Function<E, SoundEvent> var4, TagKey<Block> var5, float var6, BiPredicate<E, BlockPos> var7) {
        super(var0, var1, var2, var3, var4, var7);
        this.preferredBlockTag = var5;
        this.preferredBlocksChance = var6;
    }

    @Override
    protected void start(ServerLevel var0, E var1, long var2) {
        super.start(var0, var1, var2);
        this.notPrefferedJumpCandidates.clear();
        this.currentlyWantingPreferredOnes = ((Entity)var1).getRandom().nextFloat() < this.preferredBlocksChance;
    }

    @Override
    protected Optional<LongJumpToRandomPos.PossibleJump> getJumpCandidate(ServerLevel var0) {
        if (!this.currentlyWantingPreferredOnes) {
            return super.getJumpCandidate(var0);
        }
        BlockPos.MutableBlockPos var1 = new BlockPos.MutableBlockPos();
        while (!this.jumpCandidates.isEmpty()) {
            Optional<LongJumpToRandomPos.PossibleJump> var2 = super.getJumpCandidate(var0);
            if (!var2.isPresent()) continue;
            LongJumpToRandomPos.PossibleJump var3 = var2.get();
            if (var0.getBlockState(var1.setWithOffset((Vec3i)var3.targetPos(), Direction.DOWN)).is(this.preferredBlockTag)) {
                return var2;
            }
            this.notPrefferedJumpCandidates.add(var3);
        }
        if (!this.notPrefferedJumpCandidates.isEmpty()) {
            return Optional.of(this.notPrefferedJumpCandidates.remove(0));
        }
        return Optional.empty();
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (E)((Mob)livingEntity), l);
    }
}

