/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class PrepareRamNearestTarget<E extends PathfinderMob>
extends Behavior<E> {
    public static final int TIME_OUT_DURATION = 160;
    private final ToIntFunction<E> getCooldownOnFail;
    private final int minRamDistance;
    private final int maxRamDistance;
    private final float walkSpeed;
    private final TargetingConditions ramTargeting;
    private final int ramPrepareTime;
    private final Function<E, SoundEvent> getPrepareRamSound;
    private Optional<Long> reachedRamPositionTimestamp = Optional.empty();
    private Optional<RamCandidate> ramCandidate = Optional.empty();

    public PrepareRamNearestTarget(ToIntFunction<E> tointfunction, int i, int j, float f, TargetingConditions pathfindertargetcondition, int k, Function<E, SoundEvent> function) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.RAM_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 160);
        this.getCooldownOnFail = tointfunction;
        this.minRamDistance = i;
        this.maxRamDistance = j;
        this.walkSpeed = f;
        this.ramTargeting = pathfindertargetcondition;
        this.ramPrepareTime = k;
        this.getPrepareRamSound = function;
    }

    @Override
    protected void start(ServerLevel worldserver, PathfinderMob entitycreature, long i) {
        Brain<?> behaviorcontroller = entitycreature.getBrain();
        behaviorcontroller.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(nearestvisiblelivingentities -> nearestvisiblelivingentities.findClosest(entityliving -> this.ramTargeting.test(worldserver, entitycreature, (LivingEntity)entityliving))).ifPresent(entityliving -> {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entitycreature, entityliving, entityliving instanceof ServerPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled() || event.getTarget() == null) {
                return;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            this.chooseRamPosition(entitycreature, (LivingEntity)entityliving);
        });
    }

    @Override
    protected void stop(ServerLevel worldserver, E e0, long i) {
        Brain<Vec3> behaviorcontroller = ((LivingEntity)e0).getBrain();
        if (!behaviorcontroller.hasMemoryValue(MemoryModuleType.RAM_TARGET)) {
            worldserver.broadcastEntityEvent((Entity)e0, (byte)59);
            behaviorcontroller.setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, this.getCooldownOnFail.applyAsInt(e0));
        }
    }

    @Override
    protected boolean canStillUse(ServerLevel worldserver, PathfinderMob entitycreature, long i) {
        return this.ramCandidate.isPresent() && this.ramCandidate.get().getTarget().isAlive();
    }

    @Override
    protected void tick(ServerLevel worldserver, E e0, long i) {
        if (!this.ramCandidate.isEmpty()) {
            boolean flag;
            ((LivingEntity)e0).getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(this.ramCandidate.get().getStartPosition(), this.walkSpeed, 0));
            ((LivingEntity)e0).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(this.ramCandidate.get().getTarget(), true));
            boolean bl = flag = !this.ramCandidate.get().getTarget().blockPosition().equals(this.ramCandidate.get().getTargetPosition());
            if (flag) {
                worldserver.broadcastEntityEvent((Entity)e0, (byte)59);
                ((Mob)e0).getNavigation().stop();
                this.chooseRamPosition((PathfinderMob)e0, this.ramCandidate.get().target);
            } else {
                BlockPos blockposition = ((Entity)e0).blockPosition();
                if (blockposition.equals(this.ramCandidate.get().getStartPosition())) {
                    worldserver.broadcastEntityEvent((Entity)e0, (byte)58);
                    if (this.reachedRamPositionTimestamp.isEmpty()) {
                        this.reachedRamPositionTimestamp = Optional.of(i);
                    }
                    if (i - this.reachedRamPositionTimestamp.get() >= (long)this.ramPrepareTime) {
                        ((LivingEntity)e0).getBrain().setMemory(MemoryModuleType.RAM_TARGET, this.getEdgeOfBlock(blockposition, this.ramCandidate.get().getTargetPosition()));
                        worldserver.playSound((Entity)null, (Entity)e0, this.getPrepareRamSound.apply(e0), SoundSource.NEUTRAL, 1.0f, ((LivingEntity)e0).getVoicePitch());
                        this.ramCandidate = Optional.empty();
                    }
                }
            }
        }
    }

    private Vec3 getEdgeOfBlock(BlockPos blockposition, BlockPos blockposition1) {
        double d0 = 0.5;
        double d1 = 0.5 * (double)Mth.sign(blockposition1.getX() - blockposition.getX());
        double d2 = 0.5 * (double)Mth.sign(blockposition1.getZ() - blockposition.getZ());
        return Vec3.atBottomCenterOf(blockposition1).add(d1, 0.0, d2);
    }

    private Optional<BlockPos> calculateRammingStartPosition(PathfinderMob entitycreature, LivingEntity entityliving) {
        BlockPos blockposition = entityliving.blockPosition();
        if (!this.isWalkableBlock(entitycreature, blockposition)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            blockposition_mutableblockposition.set(blockposition);
            for (int i = 0; i < this.maxRamDistance; ++i) {
                if (this.isWalkableBlock(entitycreature, blockposition_mutableblockposition.move(enumdirection))) continue;
                blockposition_mutableblockposition.move(enumdirection.getOpposite());
                break;
            }
            if (blockposition_mutableblockposition.distManhattan(blockposition) < this.minRamDistance) continue;
            list.add(blockposition_mutableblockposition.immutable());
        }
        PathNavigation navigationabstract = entitycreature.getNavigation();
        Stream stream = list.stream();
        BlockPos blockposition1 = entitycreature.blockPosition();
        Objects.requireNonNull(blockposition1);
        return stream.sorted(Comparator.comparingDouble(blockposition1::distSqr)).filter(blockposition2 -> {
            Path pathentity = navigationabstract.createPath((BlockPos)blockposition2, 0);
            return pathentity != null && pathentity.canReach();
        }).findFirst();
    }

    private boolean isWalkableBlock(PathfinderMob entitycreature, BlockPos blockposition) {
        return entitycreature.getNavigation().isStableDestination(blockposition) && entitycreature.getPathfindingMalus(WalkNodeEvaluator.getPathTypeStatic(entitycreature, blockposition)) == 0.0f;
    }

    private void chooseRamPosition(PathfinderMob entitycreature, LivingEntity entityliving) {
        this.reachedRamPositionTimestamp = Optional.empty();
        this.ramCandidate = this.calculateRammingStartPosition(entitycreature, entityliving).map(blockposition -> new RamCandidate((BlockPos)blockposition, entityliving.blockPosition(), entityliving));
    }

    public static class RamCandidate {
        private final BlockPos startPosition;
        private final BlockPos targetPosition;
        final LivingEntity target;

        public RamCandidate(BlockPos blockposition, BlockPos blockposition1, LivingEntity entityliving) {
            this.startPosition = blockposition;
            this.targetPosition = blockposition1;
            this.target = entityliving;
        }

        public BlockPos getStartPosition() {
            return this.startPosition;
        }

        public BlockPos getTargetPosition() {
            return this.targetPosition;
        }

        public LivingEntity getTarget() {
            return this.target;
        }
    }
}

