/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class RandomLookAround
extends Behavior<Mob> {
    private final IntProvider interval;
    private final float maxYaw;
    private final float minPitch;
    private final float pitchRange;

    public RandomLookAround(IntProvider var0, float var1, float var2, float var3) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.GAZE_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        if (var2 > var3) {
            throw new IllegalArgumentException("Minimum pitch is larger than maximum pitch! " + var2 + " > " + var3);
        }
        this.interval = var0;
        this.maxYaw = var1;
        this.minPitch = var2;
        this.pitchRange = var3 - var2;
    }

    @Override
    protected void start(ServerLevel var0, Mob var1, long var2) {
        RandomSource var4 = var1.getRandom();
        float var5 = Mth.clamp(var4.nextFloat() * this.pitchRange + this.minPitch, -90.0f, 90.0f);
        float var6 = Mth.wrapDegrees(var1.getYRot() + 2.0f * var4.nextFloat() * this.maxYaw - this.maxYaw);
        Vec3 var7 = Vec3.directionFromRotation(var5, var6);
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(var1.getEyePosition().add(var7)));
        var1.getBrain().setMemory(MemoryModuleType.GAZE_COOLDOWN_TICKS, this.interval.sample(var4));
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Mob)livingEntity, l);
    }
}

