/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;

public class PlayerSensor
extends Sensor<LivingEntity> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_PLAYERS, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYERS);
    }

    @Override
    protected void doTick(ServerLevel var0, LivingEntity var12) {
        List var22 = var0.players().stream().filter(EntitySelector.NO_SPECTATORS).filter(var1 -> var12.closerThan((Entity)var1, this.getFollowDistance(var12))).sorted(Comparator.comparingDouble(var12::distanceToSqr)).collect(Collectors.toList());
        Brain<?> var3 = var12.getBrain();
        var3.setMemory(MemoryModuleType.NEAREST_PLAYERS, var22);
        List var4 = var22.stream().filter(var2 -> PlayerSensor.isEntityTargetable(var0, var12, var2)).collect(Collectors.toList());
        var3.setMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER, var4.isEmpty() ? null : (Player)var4.get(0));
        List<Player> var5 = var4.stream().filter(var2 -> PlayerSensor.isEntityAttackable(var0, var12, var2)).toList();
        var3.setMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYERS, var5);
        var3.setMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, var5.isEmpty() ? null : var5.get(0));
    }

    protected double getFollowDistance(LivingEntity var0) {
        return var0.getAttributeValue(Attributes.FOLLOW_RANGE);
    }
}

