/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.CraftAnvilView;
import org.bukkit.entity.HumanEntity;
import org.slf4j.Logger;

public class AnvilMenu
extends ItemCombinerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG_COST = false;
    public static final int MAX_NAME_LENGTH = 50;
    public int repairItemCountCost;
    @Nullable
    public String itemName;
    public final DataSlot cost = DataSlot.standalone();
    private boolean onlyRenaming = false;
    private static final int COST_FAIL = 0;
    private static final int COST_BASE = 1;
    private static final int COST_ADDED_BASE = 1;
    private static final int COST_REPAIR_MATERIAL = 1;
    private static final int COST_REPAIR_SACRIFICE = 2;
    private static final int COST_INCOMPATIBLE_PENALTY = 1;
    private static final int COST_RENAME = 1;
    private static final int INPUT_SLOT_X_PLACEMENT = 27;
    private static final int ADDITIONAL_SLOT_X_PLACEMENT = 76;
    private static final int RESULT_SLOT_X_PLACEMENT = 134;
    private static final int SLOT_Y_PLACEMENT = 47;
    public static final int DEFAULT_DENIED_COST = -1;
    public int maximumRepairCost = 40;
    private CraftAnvilView bukkitEntity;

    public AnvilMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, ContainerLevelAccess.NULL);
    }

    public AnvilMenu(int i, Inventory playerinventory, ContainerLevelAccess containeraccess) {
        super(MenuType.ANVIL, i, playerinventory, containeraccess, AnvilMenu.createInputSlotDefinitions());
        this.addDataSlot(this.cost);
    }

    private static ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, itemstack -> true).withSlot(1, 76, 47, itemstack -> true).withResultSlot(2, 134, 47).build();
    }

    @Override
    protected boolean isValidBlock(BlockState iblockdata) {
        return iblockdata.is(BlockTags.ANVIL);
    }

    @Override
    protected boolean mayPickup(Player entityhuman, boolean flag) {
        return (entityhuman.hasInfiniteMaterials() || entityhuman.experienceLevel >= this.cost.get()) && this.cost.get() > -1 && flag;
    }

    @Override
    protected void onTake(Player entityhuman, ItemStack itemstack) {
        if (!entityhuman.hasInfiniteMaterials()) {
            entityhuman.giveExperienceLevels(-this.cost.get());
        }
        if (this.repairItemCountCost > 0) {
            ItemStack itemstack1 = this.inputSlots.getItem(1);
            if (!itemstack1.isEmpty() && itemstack1.getCount() > this.repairItemCountCost) {
                itemstack1.shrink(this.repairItemCountCost);
                this.inputSlots.setItem(1, itemstack1);
            } else {
                this.inputSlots.setItem(1, ItemStack.EMPTY);
            }
        } else if (!this.onlyRenaming) {
            this.inputSlots.setItem(1, ItemStack.EMPTY);
        }
        this.cost.set(-1);
        if (entityhuman instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entityhuman;
            if (!StringUtil.isBlank(this.itemName) && !this.inputSlots.getItem(0).getHoverName().getString().equals(this.itemName)) {
                entityplayer.getTextFilter().processStreamMessage(this.itemName);
            }
        }
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        this.access.execute((world, blockposition) -> {
            BlockState iblockdata = world.getBlockState((BlockPos)blockposition);
            if (!entityhuman.hasInfiniteMaterials() && iblockdata.is(BlockTags.ANVIL) && entityhuman.getRandom().nextFloat() < 0.12f) {
                BlockState iblockdata1 = AnvilBlock.damage(iblockdata);
                if (iblockdata1 == null) {
                    world.removeBlock((BlockPos)blockposition, false);
                    world.levelEvent(1029, (BlockPos)blockposition, 0);
                } else {
                    world.setBlock((BlockPos)blockposition, iblockdata1, 2);
                    world.levelEvent(1030, (BlockPos)blockposition, 0);
                }
            } else {
                world.levelEvent(1030, (BlockPos)blockposition, 0);
            }
        });
    }

    @Override
    public void createResult() {
        ItemStack itemstack = this.inputSlots.getItem(0);
        this.onlyRenaming = false;
        this.cost.set(1);
        int i = 0;
        long j = 0L;
        int k = 0;
        if (!itemstack.isEmpty() && EnchantmentHelper.canStoreEnchantments(itemstack)) {
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = this.inputSlots.getItem(1);
            ItemEnchantments.Mutable itemenchantments_a = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting(itemstack1));
            j += (long)itemstack.getOrDefault(DataComponents.REPAIR_COST, 0).intValue() + (long)itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0).intValue();
            this.repairItemCountCost = 0;
            if (!itemstack2.isEmpty()) {
                boolean flag = itemstack2.has(DataComponents.STORED_ENCHANTMENTS);
                if (itemstack1.isDamageableItem() && itemstack.isValidRepairItem(itemstack2)) {
                    int i1;
                    int l = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    if (l <= 0) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                    for (i1 = 0; l > 0 && i1 < itemstack2.getCount(); ++i1) {
                        int j1 = itemstack1.getDamageValue() - l;
                        itemstack1.setDamageValue(j1);
                        ++i;
                        l = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    }
                    this.repairItemCountCost = i1;
                } else {
                    if (!(flag || itemstack1.is(itemstack2.getItem()) && itemstack1.isDamageableItem())) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                    if (itemstack1.isDamageableItem() && !flag) {
                        int k1 = itemstack.getMaxDamage() - itemstack.getDamageValue();
                        int l1 = itemstack2.getMaxDamage() - itemstack2.getDamageValue();
                        int i2 = l1 + itemstack1.getMaxDamage() * 12 / 100;
                        int j2 = k1 + i2;
                        int k2 = itemstack1.getMaxDamage() - j2;
                        if (k2 < 0) {
                            k2 = 0;
                        }
                        if (k2 < itemstack1.getDamageValue()) {
                            itemstack1.setDamageValue(k2);
                            i += 2;
                        }
                    }
                    ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting(itemstack2);
                    boolean flag1 = false;
                    boolean flag2 = false;
                    for (Object2IntMap.Entry<Holder<Enchantment>> object2intmap_entry : itemenchantments.entrySet()) {
                        int i3;
                        Holder holder = (Holder)object2intmap_entry.getKey();
                        int l2 = itemenchantments_a.getLevel(holder);
                        i3 = l2 == (i3 = object2intmap_entry.getIntValue()) ? i3 + 1 : Math.max(i3, l2);
                        Enchantment enchantment = (Enchantment)holder.value();
                        boolean flag3 = enchantment.canEnchant(itemstack);
                        if (this.player.hasInfiniteMaterials() || itemstack.is(Items.ENCHANTED_BOOK)) {
                            flag3 = true;
                        }
                        for (Holder<Enchantment> holder1 : itemenchantments_a.keySet()) {
                            if (holder1.equals(holder) || Enchantment.areCompatible(holder, holder1)) continue;
                            flag3 = false;
                            ++i;
                        }
                        if (!flag3) {
                            flag2 = true;
                            continue;
                        }
                        flag1 = true;
                        if (i3 > enchantment.getMaxLevel()) {
                            i3 = enchantment.getMaxLevel();
                        }
                        itemenchantments_a.set(holder, i3);
                        int j3 = enchantment.getAnvilCost();
                        if (flag) {
                            j3 = Math.max(1, j3 / 2);
                        }
                        i += j3 * i3;
                        if (itemstack.getCount() <= 1) continue;
                        i = 40;
                    }
                    if (flag2 && !flag1) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                }
            }
            if (this.itemName != null && !StringUtil.isBlank(this.itemName)) {
                if (!this.itemName.equals(itemstack.getHoverName().getString())) {
                    k = 1;
                    i += k;
                    itemstack1.set(DataComponents.CUSTOM_NAME, Component.literal(this.itemName));
                }
            } else if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                k = 1;
                i += k;
                itemstack1.remove(DataComponents.CUSTOM_NAME);
            }
            int k3 = i <= 0 ? 0 : (int)Mth.clamp(j + (long)i, 0L, Integer.MAX_VALUE);
            this.cost.set(k3);
            if (i <= 0) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (k == i && k > 0) {
                if (this.cost.get() >= this.maximumRepairCost) {
                    this.cost.set(this.maximumRepairCost - 1);
                }
                this.onlyRenaming = true;
            }
            if (this.cost.get() >= this.maximumRepairCost && !this.player.hasInfiniteMaterials()) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (!itemstack1.isEmpty()) {
                int l3 = itemstack1.getOrDefault(DataComponents.REPAIR_COST, 0);
                if (l3 < itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0)) {
                    l3 = itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0);
                }
                if (k != i || k == 0) {
                    l3 = AnvilMenu.calculateIncreasedRepairCost(l3);
                }
                itemstack1.set(DataComponents.REPAIR_COST, l3);
                EnchantmentHelper.setEnchantments(itemstack1, itemenchantments_a.toImmutable());
            }
            CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), itemstack1);
            this.broadcastChanges();
        } else {
            CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), ItemStack.EMPTY);
            this.cost.set(-1);
        }
        this.sendAllDataToRemote();
    }

    public static int calculateIncreasedRepairCost(int i) {
        return (int)Math.min((long)i * 2L + 1L, Integer.MAX_VALUE);
    }

    public boolean setItemName(String s) {
        String s1 = AnvilMenu.validateName(s);
        if (s1 != null && !s1.equals(this.itemName)) {
            this.itemName = s1;
            if (this.getSlot(2).hasItem()) {
                ItemStack itemstack = this.getSlot(2).getItem();
                if (StringUtil.isBlank(s1)) {
                    itemstack.remove(DataComponents.CUSTOM_NAME);
                } else {
                    itemstack.set(DataComponents.CUSTOM_NAME, Component.literal(s1));
                }
            }
            this.createResult();
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String s) {
        String s1 = StringUtil.filterText(s);
        return s1.length() <= 50 ? s1 : null;
    }

    public int getCost() {
        return this.cost.get();
    }

    @Override
    public CraftAnvilView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.access.getLocation(), this.inputSlots, this.resultSlots);
        this.bukkitEntity = new CraftAnvilView((HumanEntity)this.player.getBukkitEntity(), inventory, this);
        this.bukkitEntity.updateFromLegacy(inventory);
        return this.bukkitEntity;
    }
}

