/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;

public class ItemCombinerMenuSlotDefinition {
    private final List<SlotDefinition> slots;
    private final SlotDefinition resultSlot;

    ItemCombinerMenuSlotDefinition(List<SlotDefinition> var0, SlotDefinition var1) {
        if (var0.isEmpty() || var1.equals(SlotDefinition.EMPTY)) {
            throw new IllegalArgumentException("Need to define both inputSlots and resultSlot");
        }
        this.slots = var0;
        this.resultSlot = var1;
    }

    public static Builder create() {
        return new Builder();
    }

    public SlotDefinition getSlot(int var0) {
        return this.slots.get(var0);
    }

    public SlotDefinition getResultSlot() {
        return this.resultSlot;
    }

    public List<SlotDefinition> getSlots() {
        return this.slots;
    }

    public int getNumOfInputSlots() {
        return this.slots.size();
    }

    public int getResultSlotIndex() {
        return this.getNumOfInputSlots();
    }

    public static final class SlotDefinition
    extends Record {
        final int slotIndex;
        private final int x;
        private final int y;
        private final Predicate<ItemStack> mayPlace;
        static final SlotDefinition EMPTY = new SlotDefinition(0, 0, 0, var0 -> true);

        public SlotDefinition(int var0, int var1, int var2, Predicate<ItemStack> var3) {
            this.slotIndex = var0;
            this.x = var1;
            this.y = var2;
            this.mayPlace = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SlotDefinition.class, "slotIndex;x;y;mayPlace", "slotIndex", "x", "y", "mayPlace"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SlotDefinition.class, "slotIndex;x;y;mayPlace", "slotIndex", "x", "y", "mayPlace"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SlotDefinition.class, "slotIndex;x;y;mayPlace", "slotIndex", "x", "y", "mayPlace"}, this, var0);
        }

        public int slotIndex() {
            return this.slotIndex;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public Predicate<ItemStack> mayPlace() {
            return this.mayPlace;
        }
    }

    public static class Builder {
        private final List<SlotDefinition> inputSlots = new ArrayList<SlotDefinition>();
        private SlotDefinition resultSlot = SlotDefinition.EMPTY;

        public Builder withSlot(int var0, int var1, int var2, Predicate<ItemStack> var3) {
            this.inputSlots.add(new SlotDefinition(var0, var1, var2, var3));
            return this;
        }

        public Builder withResultSlot(int var02, int var1, int var2) {
            this.resultSlot = new SlotDefinition(var02, var1, var2, var0 -> false);
            return this;
        }

        public ItemCombinerMenuSlotDefinition build() {
            int var0 = this.inputSlots.size();
            for (int var1 = 0; var1 < var0; ++var1) {
                SlotDefinition var2 = this.inputSlots.get(var1);
                if (var2.slotIndex == var1) continue;
                throw new IllegalArgumentException("Expected input slots to have continous indexes");
            }
            if (this.resultSlot.slotIndex != var0) {
                throw new IllegalArgumentException("Expected result slot index to follow last input slot");
            }
            return new ItemCombinerMenuSlotDefinition(this.inputSlots, this.resultSlot);
        }
    }
}

